/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.ControllMaterialsOverview;
import gui.FillerCalculator;
import gui.MaterialsOverview;
import gui_elements.PCComboBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ListIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import model.Material;
import model.MaterialList;
import model.Polymer;
import persistence.MaterialListException;
import persistence.MaterialPersistence;

public class ControllFillerCalculator {
    private MaterialList model;
    private FillerCalculator viewFillerCalculator;
    private String MATERIALLIST_DEFAULT_NAME = "materials.ab";
    private MaterialPersistence persistence;

    public ControllFillerCalculator(FillerCalculator viewFillerCalculator) throws MaterialListException {
        this.viewFillerCalculator = viewFillerCalculator;
        this.initPersistence();
        this.initFillerBox();
        this.initController();
        this.checkMaterials();
    }

    public void initPersistence() throws MaterialListException {
        String listDirPath = "material_list";
        File listDir = new File(listDirPath);
        listDir.mkdir();
        String listPath = String.valueOf(listDirPath) + "/" + this.MATERIALLIST_DEFAULT_NAME;
        this.persistence = new MaterialPersistence(listPath);
        File listFile = new File(listPath);
        if (listFile.exists()) {
            System.out.println("Material list found, load list.");
            this.model = this.persistence.loadList();
        } else {
            System.out.println("Material list not found, create new list.");
            this.model = new MaterialList();
        }
    }

    private void initFillerBox() {
        PCComboBox fillerBox = this.viewFillerCalculator.getFillerBox();
        fillerBox.removeAllItems();
        ListIterator<Material> iteratorMat = this.model.materialIterator();
        while (iteratorMat.hasNext()) {
            Material materialChoice = (Material)iteratorMat.next();
            fillerBox.addItem(materialChoice.getMaterialName());
        }
        fillerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ControllFillerCalculator.this.viewFillerCalculator.getInput().setText(ControllFillerCalculator.this.viewFillerCalculator.getInput().getText());
            }
        });
        PCComboBox polymerBox = this.viewFillerCalculator.getPolymerBox();
        polymerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ControllFillerCalculator.this.viewFillerCalculator.getInput().setText(ControllFillerCalculator.this.viewFillerCalculator.getInput().getText());
            }
        });
    }

    private void initController() {
        this.viewFillerCalculator.getInput().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Float inFloat;
                if (ControllFillerCalculator.this.viewFillerCalculator.getInput().getText().equals("")) {
                    ControllFillerCalculator.this.viewFillerCalculator.getOutput().setText("");
                    ControllFillerCalculator.this.viewFillerCalculator.getOutput().setBackground(Color.YELLOW);
                    return;
                }
                try {
                    inFloat = Float.valueOf(ControllFillerCalculator.this.viewFillerCalculator.getInput().getText());
                }
                catch (NumberFormatException f) {
                    ControllFillerCalculator.this.viewFillerCalculator.getOutput().setText("#invalid#");
                    ControllFillerCalculator.this.viewFillerCalculator.getOutput().setBackground(new Color(255, 69, 0));
                    return;
                }
                String label = ControllFillerCalculator.this.viewFillerCalculator.getInputLabel().getText();
                String inMaterial = ControllFillerCalculator.this.viewFillerCalculator.getFillerBox().getSelectedItem().toString();
                Polymer polymer = Polymer.valueOf(ControllFillerCalculator.this.viewFillerCalculator.getPolymerBox().getSelectedItem().toString());
                DecimalFormat df = new DecimalFormat("#.#");
                ControllFillerCalculator.this.viewFillerCalculator.getOutput().setBackground(new Color(67, 205, 128));
                if (label.equals("\u0394Shore A")) {
                    ControllFillerCalculator.this.viewFillerCalculator.getOutput().setText(df.format(ControllFillerCalculator.this.model.shaToPhr(inMaterial, polymer, inFloat.floatValue())).replace(",", "."));
                } else {
                    ControllFillerCalculator.this.viewFillerCalculator.getOutput().setText(df.format(ControllFillerCalculator.this.model.phrToSha(inMaterial, polymer, inFloat.floatValue())).replace(",", "."));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }
        });
        this.viewFillerCalculator.getEditMaterialsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialsOverview matOverview = new MaterialsOverview();
                matOverview.getMainFrame().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent f) {
                        ControllFillerCalculator.this.initFillerBox();
                        ControllFillerCalculator.this.checkMaterials();
                        try {
                            ControllFillerCalculator.this.persistence.storeList(ControllFillerCalculator.this.model);
                            System.out.println("Material list stored successfully.");
                        }
                        catch (MaterialListException e) {
                            ControllFillerCalculator.this.viewFillerCalculator.getSaveSlot().setText("Error saving materials!");
                            e.printStackTrace();
                        }
                    }
                });
                ControllMaterialsOverview contMatOverview = new ControllMaterialsOverview(ControllFillerCalculator.this.model, matOverview);
            }
        });
    }

    private void checkMaterials() {
        PCComboBox fillerBox = this.viewFillerCalculator.getFillerBox();
        if (fillerBox.getItemCount() == 0) {
            this.viewFillerCalculator.getInput().setEditable(false);
            this.viewFillerCalculator.getSaveSlot().setText("Add material first!");
        } else {
            this.viewFillerCalculator.getInput().setEditable(true);
            this.viewFillerCalculator.getSaveSlot().setText("");
        }
    }
}

