/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.ControllModifyMaterials;
import gui.MaterialsModify;
import gui.MaterialsOverview;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import model.Filler;
import model.Material;
import model.MaterialList;

public class ControllMaterialsOverview {
    private MaterialList model;
    private MaterialsOverview viewMaterialsOverview;

    ControllMaterialsOverview(MaterialList model, MaterialsOverview viewMaterialsOverview) {
        this.model = model;
        this.viewMaterialsOverview = viewMaterialsOverview;
        this.addAllData();
        this.initController();
    }

    private void addAllData() {
        ListIterator<Material> matIterator = this.model.materialIterator();
        while (matIterator.hasNext()) {
            Material current = (Material)matIterator.next();
            this.viewMaterialsOverview.addMaterialData(current.getMaterialName(), current.getFactorNR(), current.getFactorEPDM(), current.getComment());
        }
    }

    public void initController() {
        this.viewMaterialsOverview.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String mName = ControllMaterialsOverview.this.viewMaterialsOverview.getMaterialField().getText();
                    if (mName.equals("")) {
                        ControllMaterialsOverview.this.viewMaterialsOverview.setStatusMessage("Error. Insert material!", Color.RED);
                        return;
                    }
                    float factorNR = Float.valueOf(ControllMaterialsOverview.this.viewMaterialsOverview.getFactorNRField().getText()).floatValue();
                    float factorEPDM = Float.valueOf(ControllMaterialsOverview.this.viewMaterialsOverview.getFactorEPDMField().getText()).floatValue();
                    String comment = ControllMaterialsOverview.this.viewMaterialsOverview.getCommentField().getText();
                    ControllMaterialsOverview.this.model.addMaterial(new Filler(mName, factorNR, factorEPDM, comment));
                    ControllMaterialsOverview.this.viewMaterialsOverview.removeAllMaterialData();
                    ControllMaterialsOverview.this.addAllData();
                    ControllMaterialsOverview.this.viewMaterialsOverview.setStatusMessage(String.valueOf(mName) + " added.", Color.BLUE);
                    ControllMaterialsOverview.this.viewMaterialsOverview.getMaterialField().setText("");
                    ControllMaterialsOverview.this.viewMaterialsOverview.getFactorNRField().setText("");
                    ControllMaterialsOverview.this.viewMaterialsOverview.getFactorEPDMField().setText("");
                    ControllMaterialsOverview.this.viewMaterialsOverview.getCommentField().setText("");
                }
                catch (NumberFormatException f) {
                    System.out.println(f.getMessage());
                    ControllMaterialsOverview.this.viewMaterialsOverview.setStatusMessage("Error. Insert factor!", Color.RED);
                    return;
                }
            }
        });
        this.viewMaterialsOverview.getModifyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialsModify modifyGUI = new MaterialsModify();
                ControllModifyMaterials modifyControll = new ControllModifyMaterials(ControllMaterialsOverview.this.model, modifyGUI);
                modifyGUI.getMainFrame().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent f) {
                        ControllMaterialsOverview.this.viewMaterialsOverview.removeAllMaterialData();
                        ControllMaterialsOverview.this.addAllData();
                    }
                });
            }
        });
    }
}

