/*
 * Decompiled with CFR 0.152.
 */
package controller;

import gui.MaterialsModify;
import gui_elements.PCComboBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import model.Material;
import model.MaterialList;

public class ControllModifyMaterials {
    private MaterialList model;
    private MaterialsModify view;

    public ControllModifyMaterials(MaterialList model, MaterialsModify view) {
        this.model = model;
        this.view = view;
        this.initFillerBox();
        this.initActionListener();
    }

    private void initFillerBox() {
        PCComboBox fillerBox = this.view.getFillerBox();
        fillerBox.removeAllItems();
        ListIterator<Material> iteratorMat = this.model.materialIterator();
        fillerBox.addItem("");
        while (iteratorMat.hasNext()) {
            Material materialChoice = (Material)iteratorMat.next();
            fillerBox.addItem(materialChoice.getMaterialName());
        }
    }

    private void initActionListener() {
        final PCComboBox fillerBox = this.view.getFillerBox();
        fillerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selection;
                try {
                    selection = fillerBox.getSelectedItem().toString();
                }
                catch (NullPointerException f) {
                    return;
                }
                if (selection.equals("")) {
                    ControllModifyMaterials.this.view.getNameTextField().setText("");
                    ControllModifyMaterials.this.view.getFactorNRField().setText("");
                    ControllModifyMaterials.this.view.getFactorEPDMField().setText("");
                    ControllModifyMaterials.this.view.getCommentField().setText("");
                } else {
                    ControllModifyMaterials.this.view.getNameTextField().setText(ControllModifyMaterials.this.model.findMaterial(selection).getMaterialName());
                    ControllModifyMaterials.this.view.getFactorNRField().setText(Float.toString(ControllModifyMaterials.this.model.findMaterial(selection).getFactorNR()));
                    ControllModifyMaterials.this.view.getFactorEPDMField().setText(Float.toString(ControllModifyMaterials.this.model.findMaterial(selection).getFactorEPDM()));
                    ControllModifyMaterials.this.view.getCommentField().setText(ControllModifyMaterials.this.model.findMaterial(selection).getComment());
                }
            }
        });
        this.view.getDeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = ControllModifyMaterials.this.view.getFillerBox().getSelectedItem().toString();
                if (selection.equals("")) {
                    return;
                }
                String message = "Delete " + selection + "?";
                new JOptionPane();
                int n = JOptionPane.showConfirmDialog(ControllModifyMaterials.this.view.getMainFrame(), message, "", 0);
                if (n != 0) {
                    return;
                }
                ControllModifyMaterials.this.model.removeMaterial(ControllModifyMaterials.this.model.findMaterial(selection));
                ControllModifyMaterials.this.initFillerBox();
                ControllModifyMaterials.this.view.getStatusLabel().setHorizontalAlignment(0);
                ControllModifyMaterials.this.view.getStatusLabel().setForeground(Color.RED);
                ControllModifyMaterials.this.view.getStatusLabel().setText(String.valueOf(selection) + " deleted.");
            }
        });
        this.view.getSaveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Material material = ControllModifyMaterials.this.model.findMaterial(ControllModifyMaterials.this.view.getFillerBox().getSelectedItem().toString());
                material.setMaterialName(ControllModifyMaterials.this.view.getNameTextField().getText());
                material.setFacorNR(Float.valueOf(ControllModifyMaterials.this.view.getFactorNRField().getText()).floatValue());
                material.setFactorEPDM(Float.valueOf(ControllModifyMaterials.this.view.getFactorEPDMField().getText()).floatValue());
                material.setComment(ControllModifyMaterials.this.view.getCommentField().getText());
                ControllModifyMaterials.this.view.getStatusLabel().setForeground(Color.BLUE);
                ControllModifyMaterials.this.view.getStatusLabel().setHorizontalAlignment(0);
                ControllModifyMaterials.this.view.getStatusLabel().setText("Changes saved.");
            }
        });
    }
}

