/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui_elements.FloatPCTextField;
import gui_elements.PCLabel;
import gui_elements.PCTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ActiveContentCalculator {
    private JPanel activeContentPanel = new JPanel(new BorderLayout());
    private Color backgroundColor = new Color(198, 226, 255);
    private JPanel northPanel = new JPanel();
    private FloatPCTextField activeContentIST = new FloatPCTextField();
    private FloatPCTextField activeContentSOLL = new FloatPCTextField();
    private FloatPCTextField phrIST = new FloatPCTextField();
    private FloatPCTextField phrSOLL = new FloatPCTextField();
    private JPanel southPanel = new JPanel();
    String[] title = new String[]{"[%]:", "100", "90", "80", "70", "60", "50", "40"};
    String[][] calcPHR;
    PCTable table;
    JScrollPane tablePane;

    public ActiveContentCalculator() {
        this.activeContentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(100, 100, 100), 2), BorderFactory.createEmptyBorder(20, 5, 10, 5)));
        this.activeContentPanel.setBackground(this.backgroundColor);
        this.createNorthPanel();
        this.createSouthPanel();
        this.activeContentPanel.add((Component)this.northPanel, "Center");
        this.activeContentPanel.add((Component)this.southPanel, "South");
    }

    private void createNorthPanel() {
        this.northPanel.setBackground(this.backgroundColor);
        this.northPanel.setLayout(new GridLayout(2, 5, 5, 5));
        this.northPanel.add(new PCLabel("cont.[%]", 1));
        this.northPanel.add(new PCLabel("phr", 1));
        this.northPanel.add(new PCLabel("\u2192", 1));
        this.northPanel.add(new PCLabel("cont.[%]:", 1));
        this.northPanel.add(new PCLabel("phr", 1));
        this.activeContentIST.setText("100");
        this.northPanel.add(this.activeContentIST);
        this.phrIST.setText("0");
        this.northPanel.add(this.phrIST);
        this.northPanel.add(new PCLabel("\u2192", 1));
        this.northPanel.add(this.activeContentSOLL);
        this.northPanel.add(this.phrSOLL);
        this.phrSOLL.setBackground(Color.YELLOW);
        this.phrSOLL.setFocusable(false);
        this.activeContentIST.getDocument().addDocumentListener(new CalcListener());
        this.phrIST.getDocument().addDocumentListener(new CalcListener());
        this.activeContentSOLL.getDocument().addDocumentListener(new CalcListener());
        this.activeContentIST.addFocusListener(new DeleteListener());
        this.phrIST.addFocusListener(new DeleteListener());
        this.activeContentSOLL.addFocusListener(new DeleteListener());
    }

    private void createSouthPanel() {
        this.southPanel.setBorder(BorderFactory.createEmptyBorder(20, 5, 10, 5));
        this.southPanel.setBackground(this.backgroundColor);
        this.southPanel.setLayout(new BorderLayout());
        this.calcPHR = new String[1][this.title.length];
        this.calcPHR[0][0] = "phr:";
        int i = 1;
        while (i < this.title.length) {
            this.calcPHR[0][i] = Integer.toString(0);
            ++i;
        }
        this.table = new PCTable(this.calcPHR, this.title);
        this.tablePane = new JScrollPane(this.table);
        this.tablePane.setBorder(BorderFactory.createEmptyBorder());
        this.southPanel.add((Component)this.tablePane, "North");
    }

    public JPanel getActiveContentCalculatorPanel() {
        return this.activeContentPanel;
    }

    private class CalcListener
    implements DocumentListener {
        private CalcListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Float acSOLLFloat;
            Float phrISTFloat;
            Float acISTFloat;
            DecimalFormat dfTable = new DecimalFormat("#.###");
            if (!ActiveContentCalculator.this.activeContentIST.getText().equals("") && !ActiveContentCalculator.this.phrIST.getText().equals("")) {
                float acISTFloat2 = Float.valueOf(ActiveContentCalculator.this.activeContentIST.getText()).floatValue();
                float phrISTFloat2 = Float.valueOf(ActiveContentCalculator.this.phrIST.getText()).floatValue();
                int i = 1;
                while (i < ActiveContentCalculator.this.title.length) {
                    float iFloat = Float.valueOf(i).floatValue();
                    float factor = (11.0f - iFloat) / 10.0f;
                    ActiveContentCalculator.this.calcPHR[0][i] = dfTable.format(phrISTFloat2 * (acISTFloat2 / 100.0f) / factor);
                    ++i;
                }
                ActiveContentCalculator.this.southPanel.repaint();
            }
            if (ActiveContentCalculator.this.activeContentIST.getText().equals("") || ActiveContentCalculator.this.phrIST.getText().equals("") || ActiveContentCalculator.this.activeContentSOLL.getText().equals("")) {
                ActiveContentCalculator.this.phrSOLL.setText("");
                ActiveContentCalculator.this.phrSOLL.setBackground(Color.YELLOW);
                return;
            }
            try {
                acISTFloat = Float.valueOf(ActiveContentCalculator.this.activeContentIST.getText());
                phrISTFloat = Float.valueOf(ActiveContentCalculator.this.phrIST.getText());
                acSOLLFloat = Float.valueOf(ActiveContentCalculator.this.activeContentSOLL.getText());
            }
            catch (NumberFormatException f) {
                ActiveContentCalculator.this.phrSOLL.setText("#inv#");
                ActiveContentCalculator.this.phrSOLL.setBackground(new Color(255, 69, 0));
                return;
            }
            DecimalFormat df = new DecimalFormat("#.###");
            ActiveContentCalculator.this.phrSOLL.setBackground(new Color(67, 205, 128));
            ActiveContentCalculator.this.phrSOLL.setText(df.format(phrISTFloat.floatValue() * (acISTFloat.floatValue() / 100.0f) / (acSOLLFloat.floatValue() / 100.0f)).replace(",", "."));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }
    }

    private class DeleteListener
    implements FocusListener {
        private DeleteListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ((FloatPCTextField)e.getComponent()).setText("");
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

