/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui_elements.FloatPCTextField;
import gui_elements.PCButton;
import gui_elements.PCComboBox;
import gui_elements.PCLabel;
import gui_elements.PCTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import model.Polymer;

public class FillerCalculator {
    private JPanel fillerPanel = new JPanel(new BorderLayout());
    private Color backgroundColor = new Color(198, 226, 255);
    private JPanel centerPanel = new JPanel(new GridLayout(0, 2));
    private PCButton editMaterialsButton = new PCButton("Edit materials");
    private JPanel leftPanel;
    private String[] labelText = new String[]{"\u0394Shore A", "Polymer", "Filler", "\u0394PHR"};
    private PCLabel[] labels = new PCLabel[this.labelText.length];
    private FloatPCTextField input = new FloatPCTextField();
    private PCComboBox polymer = new PCComboBox(Polymer.valuesAsString());
    private PCComboBox filler = new PCComboBox();
    private PCTextField output = new PCTextField();
    private PCButton switchButton = new PCButton("ShA\u2194PHR");
    private PCButton saveButton = new PCButton("save");
    private JPanel rightPanel;
    private PCLabel[] saveSlot = new PCLabel[5];

    public FillerCalculator() {
        this.fillerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(100, 100, 100), 2), BorderFactory.createEmptyBorder(10, 5, 20, 5)));
        this.fillerPanel.setBackground(this.backgroundColor);
        this.fillerPanel.add((Component)this.editMaterialsButton, "South");
        this.centerPanel.setBackground(this.backgroundColor);
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.fillerPanel.add((Component)this.centerPanel, "Center");
        this.createLeftPanel();
        this.createRightPanel();
    }

    private void createLeftPanel() {
        this.leftPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.leftPanel.setBackground(this.backgroundColor);
        int i = 0;
        while (i < this.labelText.length) {
            this.labels[i] = new PCLabel("");
            this.labels[i].setText(this.labelText[i]);
            ++i;
        }
        this.output.setBackground(Color.YELLOW);
        this.output.setFocusable(false);
        this.leftPanel.add(this.labels[0]);
        this.leftPanel.add(this.input);
        this.leftPanel.add(this.labels[1]);
        this.leftPanel.add(this.polymer);
        this.leftPanel.add(this.labels[2]);
        this.filler.setFont(new Font("Tahoma", 0, 18));
        this.leftPanel.add(this.filler);
        this.leftPanel.add(this.labels[3]);
        this.leftPanel.add(this.output);
        this.leftPanel.add(this.switchButton);
        this.switchButton.addActionListener(new switchAction());
        this.leftPanel.add(this.saveButton);
        this.saveButton.addActionListener(new saveAction());
        this.centerPanel.add(this.leftPanel);
    }

    private void createRightPanel() {
        this.rightPanel = new JPanel(new GridLayout(5, 0, 5, 5));
        this.rightPanel.setBackground(this.backgroundColor);
        Font labelFont = new Font("Tahoma", 0, 15);
        int i = 0;
        while (i < this.saveSlot.length) {
            this.saveSlot[i] = new PCLabel(" ");
            this.saveSlot[i].setHorizontalAlignment(0);
            this.saveSlot[i].setFont(labelFont);
            this.rightPanel.add(this.saveSlot[i]);
            ++i;
        }
        this.centerPanel.add(this.rightPanel);
    }

    public JPanel getFillerCalculatorPanel() {
        return this.fillerPanel;
    }

    public PCLabel getInputLabel() {
        return this.labels[0];
    }

    public FloatPCTextField getInput() {
        return this.input;
    }

    public PCComboBox getPolymerBox() {
        return this.polymer;
    }

    public PCComboBox getFillerBox() {
        return this.filler;
    }

    public PCTextField getOutput() {
        return this.output;
    }

    public PCButton getSwitchButton() {
        return this.switchButton;
    }

    public PCButton getEditMaterialsButton() {
        return this.editMaterialsButton;
    }

    public PCLabel getSaveSlot() {
        return this.saveSlot[0];
    }

    private class saveAction
    extends AbstractAction {
        saveAction() {
            super("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = FillerCalculator.this.saveSlot.length;
            while (i > 1) {
                FillerCalculator.this.saveSlot[i - 1].setText(FillerCalculator.this.saveSlot[i - 2].getText());
                --i;
            }
            String[] inputData = new String[6];
            try {
                inputData[0] = FillerCalculator.this.input.getText();
                inputData[1] = FillerCalculator.this.labels[0].getText().equals("\u0394Shore A") ? "ShA" : "phr";
                inputData[2] = FillerCalculator.this.output.getText();
                inputData[3] = FillerCalculator.this.labels[0].getText().equals("\u0394Shore A") ? "phr" : "ShA";
                inputData[4] = FillerCalculator.this.polymer.getSelectedItem().toString();
                inputData[5] = FillerCalculator.this.filler.getSelectedItem().toString();
            }
            catch (NullPointerException ex) {
                FillerCalculator.this.saveSlot[0].setText("Missing input value!");
                return;
            }
            String saveString = String.valueOf(inputData[0]) + " " + inputData[1] + " \u2194 " + inputData[2] + " " + inputData[3] + " (" + inputData[4] + " / " + inputData[5] + ")";
            FillerCalculator.this.saveSlot[0].setText(saveString);
        }
    }

    private class switchAction
    extends AbstractAction {
        switchAction() {
            super("switch");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String buffer = FillerCalculator.this.labels[0].getText();
            FillerCalculator.this.labels[0].setText(FillerCalculator.this.labels[3].getText());
            FillerCalculator.this.labels[3].setText(buffer);
            String bufferInput = FillerCalculator.this.input.getText();
            FillerCalculator.this.input.setText(" ");
            FillerCalculator.this.input.setText(bufferInput);
        }
    }
}

