/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui_elements.FloatPCTextField;
import gui_elements.PCButton;
import gui_elements.PCLabel;
import gui_elements.PCTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MaterialsOverview {
    private Color background = new Color(198, 226, 255);
    private JFrame mainFrame;
    private int rowNumber = 2;
    private JPanel centerPanel;
    private PCTextField newMaterial = new PCTextField();
    private FloatPCTextField factorNR = new FloatPCTextField();
    private FloatPCTextField factorEPDM = new FloatPCTextField();
    private PCTextField comment = new PCTextField();
    private JPanel eastPanel;
    private JPanel southPanel;
    PCLabel statusMessage = new PCLabel("");
    private PCButton addButton = new PCButton("ADD material");
    private PCButton modifyButton = new PCButton("Modify/Delete material");

    public MaterialsOverview() {
        this.createMainFrame();
        this.createCenterPanel();
        this.createEastPanel();
        this.createSouthPanel();
        this.addDialog();
        this.mainFrame.setSize(new Dimension(551, 226));
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setVisible(true);
    }

    private void createMainFrame() {
        this.mainFrame = new JFrame();
        this.mainFrame.setTitle("Materials Overview");
        this.mainFrame.setLayout(new BorderLayout());
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.getRootPane().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(100, 100, 100), 2), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
        try {
            System.out.println(this.getClass().getResource("icon.png"));
            BufferedImage image = ImageIO.read(this.getClass().getResource("icon.png"));
            this.mainFrame.setIconImage(image);
        }
        catch (IOException e) {
            System.out.println("Can't find logo.");
            e.printStackTrace();
        }
    }

    private void createCenterPanel() {
        String[] columnLabels = new String[]{"Material", "Factor NR", "Factor EPDM"};
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new GridLayout(0, columnLabels.length, 0, 5));
        int i = 0;
        while (i < columnLabels.length) {
            PCLabel title = new PCLabel(columnLabels[i]);
            title.setBackground(this.background);
            title.setHorizontalAlignment(0);
            title.setOpaque(true);
            this.centerPanel.add(title);
            ++i;
        }
        this.mainFrame.add((Component)this.centerPanel, "Center");
    }

    private void createEastPanel() {
        this.eastPanel = new JPanel();
        this.eastPanel.setLayout(new GridLayout(0, 1, 5, 5));
        PCLabel titleComment = new PCLabel("Comment");
        titleComment.setBackground(this.background);
        titleComment.setOpaque(true);
        this.eastPanel.add(titleComment);
        this.mainFrame.add((Component)this.eastPanel, "East");
    }

    private void createSouthPanel() {
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.southPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.statusMessage.setBorder(null);
        this.southPanel.add(this.statusMessage);
        this.southPanel.add(new JLabel(""));
        this.southPanel.add(this.addButton);
        this.southPanel.add(this.modifyButton);
        this.mainFrame.add((Component)this.southPanel, "South");
    }

    public void addMaterialData(String name, float factorNR, float factorEPDM, String comment) {
        PCTextField[] addField = new PCTextField[4];
        int i = 0;
        while (i < addField.length - 1) {
            addField[i] = new PCTextField();
            addField[i].setEditable(false);
            this.centerPanel.add(addField[i]);
            ++i;
        }
        addField[addField.length - 1] = new PCTextField();
        addField[addField.length - 1].setEditable(false);
        addField[addField.length - 1].setFocusable(false);
        addField[addField.length - 1].setHorizontalAlignment(2);
        this.eastPanel.add(addField[addField.length - 1]);
        addField[0].setText(name);
        addField[1].setText(Float.toString(factorNR));
        addField[2].setText(Float.toString(factorEPDM));
        addField[3].setText(comment);
        ++this.rowNumber;
        if (this.rowNumber < 4) {
            this.mainFrame.setSize(new Dimension((int)this.mainFrame.getPreferredSize().getWidth(), 100 + 53 * this.rowNumber));
        } else {
            this.mainFrame.setSize(this.mainFrame.getPreferredSize());
        }
        this.addDialog();
        this.mainFrame.setLocationRelativeTo(null);
    }

    public void removeAllMaterialData() {
        Component[] compArrayCenter = this.centerPanel.getComponents();
        int i = 3;
        while (i < compArrayCenter.length) {
            this.centerPanel.remove(compArrayCenter[i]);
            ++i;
        }
        Component[] compArrayEast = this.eastPanel.getComponents();
        int i2 = 1;
        while (i2 < compArrayEast.length) {
            this.eastPanel.remove(compArrayEast[i2]);
            --this.rowNumber;
            ++i2;
        }
        ++this.rowNumber;
    }

    private void addDialog() {
        this.centerPanel.add(this.newMaterial);
        this.centerPanel.add(this.factorNR);
        this.centerPanel.add(this.factorEPDM);
        this.comment.setHorizontalAlignment(2);
        this.eastPanel.add(this.comment);
    }

    public PCButton getAddButton() {
        return this.addButton;
    }

    public PCButton getModifyButton() {
        return this.modifyButton;
    }

    public PCTextField getMaterialField() {
        return this.newMaterial;
    }

    public FloatPCTextField getFactorNRField() {
        return this.factorNR;
    }

    public FloatPCTextField getFactorEPDMField() {
        return this.factorEPDM;
    }

    public PCTextField getCommentField() {
        return this.comment;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setStatusMessage(String messageText, Color color) {
        this.statusMessage.setForeground(color);
        this.statusMessage.setText(messageText);
    }
}

