/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class FloatPCTextField
extends JTextField {
    Font font = new Font("Tahoma", 0, 22);
    Color textColor = new Color(39, 64, 139);

    public FloatPCTextField() {
        this.setFont(this.font);
        this.setForeground(this.textColor);
        this.setHorizontalAlignment(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FloatPCTextField.this.setText("");
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                if (!(FloatPCTextField.this.isNumber(ch) || FloatPCTextField.this.isValidSignal(ch) || FloatPCTextField.this.validatePoint(ch) || ch == '\b')) {
                    e.consume();
                }
            }
        });
    }

    private boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isValidSignal(char ch) {
        return (this.getText() == null || "".equals(this.getText().trim())) && ch == '-';
    }

    private boolean validatePoint(char ch) {
        if (ch != '.' || this.getText().contains(".")) {
            return false;
        }
        if (this.getText() == null || "".equals(this.getText().trim())) {
            this.setText("0.");
            return false;
        }
        if ("-".equals(this.getText())) {
            this.setText("-0.");
        }
        return true;
    }
}

