/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Serializable;
import model.Material;
import model.Polymer;

public class Filler
implements Material,
Serializable {
    private String name;
    private float factorNR;
    private float factorEPDM;
    private String comment;

    public Filler(String name, float factorNR, float factorEPDM, String comment) {
        this.name = name;
        this.factorNR = factorNR;
        this.factorEPDM = factorEPDM;
        this.comment = comment;
        System.out.println(String.valueOf(name) + " als Filler angelegt.");
    }

    @Override
    public Material getMaterial() {
        return this;
    }

    @Override
    public String getMaterialName() {
        return this.name;
    }

    @Override
    public float getFactorNR() {
        return this.factorNR;
    }

    @Override
    public float getFactorEPDM() {
        return this.factorEPDM;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public float phrToSha(float phr, Polymer polymer) {
        float sha = 0.0f;
        if (polymer == Polymer.NR) {
            sha = phr * this.factorNR;
        } else if (polymer == Polymer.EPDM) {
            sha = phr * this.factorEPDM;
        }
        return sha;
    }

    @Override
    public float shaToPhr(float sha, Polymer polymer) {
        float phr = 0.0f;
        if (polymer == Polymer.NR) {
            phr = sha / this.factorNR;
        } else if (polymer == Polymer.EPDM) {
            phr = sha / this.factorEPDM;
        }
        return phr;
    }

    @Override
    public void setMaterialName(String newName) {
        this.name = newName;
    }

    @Override
    public void setFacorNR(float newFactorNR) {
        this.factorNR = newFactorNR;
    }

    @Override
    public void setFactorEPDM(float newFactorEPDM) {
        this.factorEPDM = newFactorEPDM;
    }

    @Override
    public void setComment(String newComment) {
        this.comment = newComment;
    }
}

