/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import model.Material;
import model.Polymer;

public class MaterialList
implements Serializable {
    protected LinkedList<Material> materialList = new LinkedList();

    public void addMaterial(Material material) {
        this.materialList.add(material);
        this.materialList.sort(Comparator.comparing(Material::getFactorNR).reversed());
        System.out.println(String.valueOf(material.getMaterialName()) + " in MaterialList hinzugef\u00fcgt");
    }

    public void removeMaterial(Material material) {
        this.materialList.remove(material);
    }

    public ListIterator<Material> materialIterator() {
        return this.materialList.listIterator();
    }

    public Material findMaterial(String materialName) {
        ListIterator<Material> it = this.materialIterator();
        while (it.hasNext()) {
            Material currentMaterial = it.next();
            if (!currentMaterial.getMaterialName().equals(materialName)) continue;
            return currentMaterial;
        }
        throw new NoSuchElementException();
    }

    public float phrToSha(String materialName, Polymer polymer, float phr) {
        Material material = this.findMaterial(materialName);
        float sha = material.phrToSha(phr, polymer);
        return sha;
    }

    public float shaToPhr(String materialName, Polymer polymer, float sha) {
        Material material = this.findMaterial(materialName);
        float phr = material.shaToPhr(sha, polymer);
        return phr;
    }
}

