/*
 * Decompiled with CFR 0.152.
 */
package persistence;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import model.MaterialList;
import persistence.MaterialListException;

public class MaterialPersistence {
    private String materialListPath;

    public MaterialPersistence(String materialListPath) {
        this.materialListPath = materialListPath;
    }

    public MaterialList loadList() throws MaterialListException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.materialListPath));
            MaterialList materialList = (MaterialList)ois.readObject();
            return materialList;
        }
        catch (IOException e) {
            throw new MaterialListException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MaterialListException(e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void storeList(MaterialList list) throws MaterialListException {
        ObjectOutputStream oos = null;
        try {
            try {
                oos = new ObjectOutputStream(new FileOutputStream(this.materialListPath));
                oos.writeObject(list);
            }
            catch (IOException e) {
                throw new MaterialListException(e);
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

