/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ProjectTimeTrackerDto;

public class MainOrderDto
extends ProjectTimeTrackerDto
implements Comparable<MainOrderDto> {
    private String mainOrderNumber;
    private String orderCategory;
    private boolean visible;

    public MainOrderDto() {
    }

    public MainOrderDto(Builder builder) {
        this.id = builder.id;
        this.mainOrderNumber = builder.mainOrderNumber;
        this.name = builder.name;
        this.orderCategory = builder.orderCategory;
        this.visible = builder.visible;
    }

    public String getMainOrderNumber() {
        return this.mainOrderNumber;
    }

    public void setMainOrderNumber(String mainOrderNumber) {
        this.mainOrderNumber = mainOrderNumber;
    }

    public String getOrderCategory() {
        return this.orderCategory;
    }

    public void setOrderCategory(String orderCategory) {
        this.orderCategory = orderCategory;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int compareTo(MainOrderDto mainOrderDto) {
        int result = this.mainOrderNumber.compareTo(mainOrderDto.getMainOrderNumber());
        if (result == 0) {
            result = this.name.compareTo(mainOrderDto.getName());
        }
        return result;
    }

    @Override
    public String toString() {
        String dtoToString = String.valueOf(this.mainOrderNumber) + " | " + this.name;
        if (!this.visible) {
            dtoToString = String.valueOf(dtoToString) + " | " + "NOT VISIBLE";
        }
        return dtoToString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MainOrderDto)) {
            return false;
        }
        return this.id == ((MainOrderDto)object).getId();
    }

    public static class Builder {
        private Integer id;
        private String mainOrderNumber;
        private String name;
        private String orderCategory;
        private boolean visible;

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withMainOrderNumber(String mainOrderNumber) {
            this.mainOrderNumber = mainOrderNumber;
            return this;
        }

        public Builder withMainOrderName(String mainOrderName) {
            this.name = mainOrderName;
            return this;
        }

        public Builder withOrderCategery(String orderCategory) {
            this.orderCategory = orderCategory;
            return this;
        }

        public Builder withVisible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public MainOrderDto build() {
            return new MainOrderDto(this);
        }
    }
}

