/*
 * Decompiled with CFR 0.152.
 */
package controller;

import common.EffortDto;
import common.GroupedEffortDto;
import common.MainOrderDto;
import common.OrderCategoryDto;
import common.OrderStatusDto;
import common.ProjectTimeTrackerDto;
import common.SubOrderDto;
import controller.ApplicationControllerInf;
import controller.EntityDtoMapper;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collectors;
import persistance.EntityDao;
import persistance.entities.Effort;
import persistance.entities.MainOrder;
import persistance.entities.OrderCategory;
import persistance.entities.OrderStatus;
import persistance.entities.ProjectTimeTrackerEntityInf;
import persistance.entities.SubOrder;
import persistance.queryresults.GroupedEffort;

public class ApplicationController
implements ApplicationControllerInf {
    private EntityDao entityDao = new EntityDao();
    private EntityDtoMapper mapper = new EntityDtoMapper();

    @Override
    public List<MainOrderDto> getAllMainOrders(boolean onlyVisible) {
        List<MainOrder> allMainOrders = this.entityDao.getMainOrders(onlyVisible);
        return allMainOrders.stream().map(m -> this.mapper.mainOrderEntityToDto((MainOrder)m)).collect(Collectors.toList());
    }

    @Override
    public List<OrderCategoryDto> getAllCategories() {
        List<OrderCategory> allCategories = this.entityDao.getCategories();
        return allCategories.stream().map(m -> this.mapper.categoryEntityToDto((OrderCategory)m)).collect(Collectors.toList());
    }

    @Override
    public List<OrderStatusDto> getAllStatuses() {
        List<OrderStatus> allStatuses = this.entityDao.getStatuses();
        return allStatuses.stream().map(m -> this.mapper.statusEntityToDto((OrderStatus)m)).collect(Collectors.toList());
    }

    @Override
    public List<SubOrderDto> getSubOrders(MainOrderDto mainOrderDto, boolean onlyVisible) {
        List<SubOrder> subOrders = this.entityDao.getSubOrders(mainOrderDto, onlyVisible);
        return subOrders.stream().map(m -> this.mapper.subOrderEntityToDto((SubOrder)m)).collect(Collectors.toList());
    }

    @Override
    public List<MainOrderDto> getMainOrdersByName(String namePattern, boolean onlyVisible) {
        List<MainOrder> mainOrders = this.entityDao.getMainOrdersByName(namePattern, onlyVisible);
        return mainOrders.stream().map(m -> this.mapper.mainOrderEntityToDto((MainOrder)m)).collect(Collectors.toList());
    }

    @Override
    public List<EffortDto> getEffortByDay(LocalDate localDate) {
        List<Effort> efforts = this.entityDao.getEffortByDay(localDate);
        return efforts.stream().map(e -> this.mapper.effortEntityToDto((Effort)e)).collect(Collectors.toList());
    }

    @Override
    public EffortDto getEffortById(Integer id) {
        Effort effort = this.entityDao.getEffortById(id);
        return this.mapper.effortEntityToDto(effort);
    }

    @Override
    public void createMainOrder(MainOrderDto newMainOrderDto) {
        OrderCategory category = this.entityDao.getCategory(newMainOrderDto.getOrderCategory());
        MainOrder newMainOrder = this.mapper.mainOrderDtoToEntity(newMainOrderDto, category);
        ProjectTimeTrackerEntityInf persistedMainOrder = this.entityDao.insertEntity(newMainOrder);
        newMainOrderDto.setId(persistedMainOrder.getId());
    }

    @Override
    public void createSubOrder(SubOrderDto newSubOrderDto) {
        MainOrder mainOrder = this.entityDao.getMainOrderById(newSubOrderDto.getMainOrderId());
        SubOrder newSubOrder = this.mapper.subOrderDtoToEntity(newSubOrderDto, mainOrder);
        this.entityDao.insertEntity(newSubOrder);
    }

    @Override
    public void createCategory(String newCategory) {
        OrderCategory category = new OrderCategory(newCategory);
        this.entityDao.insertEntity(category);
    }

    @Override
    public void createOrderStatus(String newOrderStatus) {
        OrderStatus status = new OrderStatus(newOrderStatus);
        this.entityDao.insertEntity(status);
    }

    @Override
    public void createEffort(EffortDto effortDto) {
        OrderStatus status = this.entityDao.getStatusByName(effortDto.getOrderStatus().getName());
        MainOrder mainOrder = this.entityDao.getMainOrderById(effortDto.getMainOrder().getId());
        SubOrderDto subOrderDto = effortDto.getSubOrder();
        SubOrder subOrder = null;
        if (subOrderDto != null) {
            subOrder = this.entityDao.getSubOrderById(subOrderDto.getId());
        }
        Effort newEffort = this.mapper.effortDtoToEntity(effortDto, mainOrder, subOrder, status);
        ProjectTimeTrackerEntityInf persistedMainOrder = this.entityDao.insertEntity(newEffort);
        effortDto.setId(persistedMainOrder.getId());
    }

    @Override
    public void modifyMainOrder(MainOrderDto mainOrderDto) {
        OrderCategory category = this.entityDao.getCategory(mainOrderDto.getOrderCategory());
        MainOrder mainOrder = this.mapper.mainOrderDtoToEntity(mainOrderDto, category);
        this.entityDao.updateEntity(mainOrder);
    }

    @Override
    public void modifySubOrder(SubOrderDto subOrderDto) {
        MainOrder mainOrder = this.entityDao.getMainOrderById(subOrderDto.getMainOrderId());
        SubOrder subOrder = this.mapper.subOrderDtoToEntity(subOrderDto, mainOrder);
        this.entityDao.updateEntity(subOrder);
    }

    @Override
    public void modifyCategory(OrderCategoryDto categoryDto) {
        OrderCategory category = this.mapper.categoryDtoToEntity(categoryDto);
        this.entityDao.updateEntity(category);
    }

    @Override
    public void modifyOrderStatus(OrderStatusDto orderStatusDto) {
        OrderStatus status = this.mapper.statusDtoToEntity(orderStatusDto);
        this.entityDao.updateEntity(status);
    }

    @Override
    public void modifyEffort(EffortDto effortDto) {
        MainOrder mainOrder = this.entityDao.getMainOrderById(effortDto.getMainOrder().getId());
        SubOrderDto subOrderDto = effortDto.getSubOrder();
        SubOrder subOrder = null;
        if (subOrderDto != null) {
            subOrder = this.entityDao.getSubOrderById(subOrderDto.getId());
        }
        OrderStatus status = this.entityDao.getStatusByName(effortDto.getOrderStatus().getName());
        Effort effort = this.mapper.effortDtoToEntity(effortDto, mainOrder, subOrder, status);
        this.entityDao.updateEntity(effort);
    }

    @Override
    public void deleteEntity(ProjectTimeTrackerDto aDto) {
        this.entityDao.deleteEntity(this.mapper.getEntityClass(aDto), aDto.getId());
    }

    @Override
    public LocalTime getTotalTime(LocalDate date) {
        return this.entityDao.getTotalTime(date);
    }

    @Override
    public List<GroupedEffortDto> getGroupedEffortByDate(LocalDate startDate, LocalDate endDate, OrderCategoryDto category, OrderStatusDto status) {
        String categoryName = category != null ? category.getName() : null;
        String statusName = status != null ? status.getName() : null;
        List<GroupedEffort> groupedEfforts = this.entityDao.getGroupedEffortByDate(startDate, endDate, categoryName, statusName);
        return groupedEfforts.stream().map(g -> this.mapper.groupedEffortToDto((GroupedEffort)g)).collect(Collectors.toList());
    }

    @Override
    public List<EffortDto> getEfforts(GroupedEffortDto groupedEffortDto) {
        OrderCategory category = this.entityDao.getCategory(groupedEffortDto.getMainOrder().getOrderCategory());
        MainOrder mainOrder = this.mapper.mainOrderDtoToEntity(groupedEffortDto.getMainOrder(), category);
        SubOrderDto subOrderDto = groupedEffortDto.getSubOrder();
        SubOrder subOrder = null;
        if (subOrderDto != null) {
            subOrder = this.mapper.subOrderDtoToEntity(subOrderDto, mainOrder);
        }
        OrderStatus status = this.mapper.statusDtoToEntity(groupedEffortDto.getStatus());
        GroupedEffort groupedEffort = new GroupedEffort(groupedEffortDto.getStartDate(), groupedEffortDto.getEndDate(), groupedEffortDto.getSummedTime(), mainOrder, subOrder, status);
        List<Effort> efforts = this.entityDao.getEfforts(groupedEffort);
        return efforts.stream().map(e -> this.mapper.effortEntityToDto((Effort)e)).collect(Collectors.toList());
    }
}

