/*
 * Decompiled with CFR 0.152.
 */
package gui.overview;

import common.EffortDto;
import gui.overview.AbstractOverviewTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import util.DateAndTimeHelper;

public class LowerDetailTable
extends AbstractOverviewTable<EffortDto> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_LABELS_IDENTIFIERS = new String[]{"Date", "Start", "Stop", "Pause", "\u03a3 [hh:mm]", "Status", "Comment"};
    public static final int DATE_INDEX = 0;
    public static final int START_INDEX = 1;
    public static final int STOP_INDEX = 2;
    public static final int PAUSE_INDEX = 3;
    public static final int SUM_INDEX = 4;
    public static final int STATUS_INDEX = 5;
    public static final int COMMENT_INDEX = 6;

    @Override
    public void setColumnWidth() {
        TableColumn column = null;
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        tableRenderer.setHorizontalAlignment(0);
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            column.setCellRenderer(tableRenderer);
            if (i == 6) {
                column.setPreferredWidth(100);
            } else {
                column.setPreferredWidth(25);
            }
            ++i;
        }
    }

    @Override
    protected Object[] getRowArray(EffortDto effort) {
        Object[] array = new Object[this.getColumnCount()];
        array[0] = effort.getEffortDate().toString();
        array[1] = effort.getStartTime().toString();
        array[2] = effort.getEndTime().toString();
        array[3] = effort.getPauseTime().toString();
        array[4] = DateAndTimeHelper.getDurationStringMMtoHHMM(effort.getDuration());
        array[5] = effort.getOrderStatus();
        array[6] = effort.getComment();
        return array;
    }

    @Override
    protected String[] getColumnIdentifiers() {
        return COLUMN_LABELS_IDENTIFIERS;
    }
}

