/*
 * Decompiled with CFR 0.152.
 */
package gui.overview;

import common.EffortDto;
import common.GroupedEffortDto;
import common.MainOrderDto;
import common.OrderCategoryDto;
import common.OrderStatusDto;
import common.SubOrderDto;
import controller.ApplicationControllerInf;
import gui.overview.LowerDetailTable;
import gui.overview.UpperOverviewTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.jdatepicker.impl.JDatePickerImpl;
import util.DateAndTimeHelper;
import util.PttJDatePickerPanel;

public class OverviewGui {
    private ApplicationControllerInf controller;
    private StatusChangeTableModelListener tableListener = new StatusChangeTableModelListener();
    private JComboBox<Object> statusComboBox = new JComboBox();
    private JFrame mainFrame = new JFrame("Time Overview");
    private JPanel northPanel = new JPanel(new GridLayout(0, 3, 5, 5));
    private PttJDatePickerPanel datePickerPanelStart;
    private PttJDatePickerPanel datePickerPanelEnd;
    private JButton searchButton;
    private JList<Object> catList;
    private JList<Object> statList;
    private JPanel centerPanel = new JPanel(new GridLayout(0, 1));
    private JPanel centerUpperPanel = new JPanel(new BorderLayout());
    private JPanel centerLowerPanel = new JPanel(new BorderLayout());
    private UpperOverviewTable upperTable = new UpperOverviewTable();
    private LowerDetailTable lowerTable = new LowerDetailTable();
    private JPanel southPanel = new JPanel(new FlowLayout(2));

    public OverviewGui(ApplicationControllerInf controller) {
        this.controller = controller;
        this.initMainFrame();
        this.initNorthPanel();
        this.initCenterPanel();
        this.initSouthPanel();
        this.initCategories();
        this.initStatus();
        this.initSearch();
        this.initUpperTable();
    }

    private void initCategories() {
        DefaultListModel catListModel = (DefaultListModel)this.catList.getModel();
        catListModel.removeAllElements();
        List<OrderCategoryDto> categoryList = this.controller.getAllCategories();
        catListModel.addElement("*all*");
        catListModel.addAll(categoryList);
        this.catList.setSelectedIndex(0);
    }

    private void initStatus() {
        DefaultListModel statListModel = (DefaultListModel)this.statList.getModel();
        statListModel.removeAllElements();
        List<OrderStatusDto> statusList = this.controller.getAllStatuses();
        statListModel.addElement("*all*");
        statListModel.addAll(statusList);
        this.statList.setSelectedIndex(0);
    }

    private void initSearch() {
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewGui.this.fillUpperTable();
            }
        });
    }

    private void fillUpperTable() {
        DefaultTableModel upperTableModel = (DefaultTableModel)this.upperTable.getModel();
        upperTableModel.setRowCount(0);
        List<GroupedEffortDto> groupedEffortList = this.getGroupedEffortsByDatesAndCategoryAndStatus();
        this.upperTable.getModel().removeTableModelListener(this.tableListener);
        this.upperTable.addContent(groupedEffortList);
        this.upperTable.getModel().addTableModelListener(this.tableListener);
        this.setBorderLabel("Group by Order/Suborder | Total time " + this.getTotalTime(groupedEffortList));
    }

    private List<GroupedEffortDto> getGroupedEffortsByDatesAndCategoryAndStatus() {
        LocalDate startDate = DateAndTimeHelper.getLocalDateFromDatePicker(this.getDatePickerStart());
        LocalDate endDate = DateAndTimeHelper.getLocalDateFromDatePicker(this.getDatePickerEnd());
        OrderCategoryDto category = this.catList.getSelectedValue().equals("*all*") ? null : (OrderCategoryDto)this.catList.getSelectedValue();
        OrderStatusDto status = this.statList.getSelectedValue().equals("*all*") ? null : (OrderStatusDto)this.statList.getSelectedValue();
        return this.controller.getGroupedEffortByDate(startDate, endDate, category, status);
    }

    private String getTotalTime(List<GroupedEffortDto> groupedEffortList) {
        int totalTime = 0;
        for (GroupedEffortDto effort : groupedEffortList) {
            totalTime += effort.getSummedTime();
        }
        return DateAndTimeHelper.getDurationStringMMtoHHMM(totalTime);
    }

    private void initUpperTable() {
        this.addStatusComboBox();
        this.addMouseListenerForLowerTableCreation();
    }

    private void addMouseListenerForLowerTableCreation() {
        this.upperTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultTableModel lowerTableModel = (DefaultTableModel)OverviewGui.this.lowerTable.getModel();
                lowerTableModel.setRowCount(0);
                int selectedRow = OverviewGui.this.upperTable.getSelectedRow();
                int selectedRowInModel = OverviewGui.this.upperTable.convertRowIndexToModel(selectedRow);
                GroupedEffortDto groupedEffort = (GroupedEffortDto)OverviewGui.this.upperTable.getModel().getValueAt(selectedRowInModel, 7);
                List<EffortDto> effortList = OverviewGui.this.controller.getEfforts(groupedEffort);
                OverviewGui.this.lowerTable.addContent(effortList);
                this.addBorderWithEffortInformation(groupedEffort);
            }

            private void addBorderWithEffortInformation(GroupedEffortDto groupedEffort) {
                MainOrderDto mainOrder = groupedEffort.getMainOrder();
                SubOrderDto subOrder = groupedEffort.getSubOrder();
                OrderStatusDto status = groupedEffort.getStatus();
                String title = String.format("Details (%s   ;   %s   ;   %s)", mainOrder, subOrder, status);
                OverviewGui.this.centerLowerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(title)));
            }
        });
    }

    private void addStatusComboBox() {
        int i = 1;
        while (i < this.statList.getModel().getSize()) {
            this.statusComboBox.addItem(this.statList.getModel().getElementAt(i));
            ++i;
        }
        DefaultCellEditor statusEditor = new DefaultCellEditor(this.statusComboBox);
        this.upperTable.getColumnModel().getColumn(6).setCellEditor(statusEditor);
    }

    private void initMainFrame() {
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setLayout(new BorderLayout());
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icon.png"));
            this.mainFrame.setIconImage(image);
        }
        catch (IOException e) {
            System.out.println("Can't find logo.");
            e.printStackTrace();
        }
        this.mainFrame.add((Component)this.northPanel, "North");
        this.mainFrame.add((Component)this.centerPanel, "Center");
        this.mainFrame.add((Component)this.southPanel, "South");
        this.mainFrame.setSize(740, 600);
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setVisible(true);
    }

    private void initNorthPanel() {
        this.northPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel northLeftPanel = new JPanel(new GridLayout(3, 0, 5, 5));
        this.northPanel.add(northLeftPanel);
        this.datePickerPanelStart = new PttJDatePickerPanel();
        this.datePickerPanelStart.getPickerPanel().setBorder(BorderFactory.createTitledBorder("Start"));
        northLeftPanel.add(this.datePickerPanelStart.getPickerPanel());
        this.datePickerPanelEnd = new PttJDatePickerPanel();
        this.datePickerPanelEnd.getPickerPanel().setBorder(BorderFactory.createTitledBorder("END"));
        northLeftPanel.add(this.datePickerPanelEnd.getPickerPanel());
        JPanel searchButtonPanel = new JPanel(new BorderLayout());
        searchButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        this.searchButton = new JButton("Search");
        this.searchButton.setFont(new Font(this.searchButton.getFont().getFontName(), 0, 20));
        searchButtonPanel.add(this.searchButton);
        northLeftPanel.add(searchButtonPanel);
        JPanel northCenterPanel = new JPanel(new BorderLayout());
        northCenterPanel.setBorder(BorderFactory.createTitledBorder("Select Categories"));
        DefaultListModel catListModel = new DefaultListModel();
        this.catList = new JList(catListModel);
        this.catList.setSelectionMode(0);
        JScrollPane catScrollPane = new JScrollPane(this.catList);
        northCenterPanel.add((Component)catScrollPane, "Center");
        this.northPanel.add(northCenterPanel);
        JPanel northRightPanel = new JPanel(new BorderLayout());
        northRightPanel.setBorder(BorderFactory.createTitledBorder("Select Status"));
        DefaultListModel statListModel = new DefaultListModel();
        this.statList = new JList(statListModel);
        this.statList.setSelectionMode(0);
        JScrollPane statScrollPane = new JScrollPane(this.statList);
        northRightPanel.add((Component)statScrollPane, "Center");
        this.northPanel.add(northRightPanel);
    }

    private void initCenterPanel() {
        this.centerUpperPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Group by Order/Suborder")));
        this.centerPanel.add(this.centerUpperPanel);
        this.centerLowerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Details")));
        this.centerPanel.add(this.centerLowerPanel);
        JScrollPane upperScrollPane = new JScrollPane(this.upperTable);
        upperScrollPane.setLayout(new ScrollPaneLayout());
        this.centerUpperPanel.add((Component)upperScrollPane, "Center");
        JScrollPane lowerScrollPane = new JScrollPane(this.lowerTable);
        lowerScrollPane.setLayout(new ScrollPaneLayout());
        this.centerLowerPanel.add((Component)lowerScrollPane, "Center");
    }

    private void initSouthPanel() {
        JButton closeButton = new JButton("Close");
        this.southPanel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewGui.this.mainFrame.dispose();
            }
        });
    }

    public void setBorderLabel(String label) {
        this.centerUpperPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(label)));
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public JDatePickerImpl getDatePickerStart() {
        return this.datePickerPanelStart.getDatePicker();
    }

    public JDatePickerImpl getDatePickerEnd() {
        return this.datePickerPanelEnd.getDatePicker();
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }

    public JList<Object> getCatList() {
        return this.catList;
    }

    public JList<Object> getStatList() {
        return this.statList;
    }

    public UpperOverviewTable getUpperTable() {
        return this.upperTable;
    }

    public LowerDetailTable getLowerTable() {
        return this.lowerTable;
    }

    public JPanel getCenterLowerPanel() {
        return this.centerLowerPanel;
    }

    private class StatusChangeTableModelListener
    implements TableModelListener {
        private StatusChangeTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() != 6) {
                return;
            }
            DefaultTableModel model = (DefaultTableModel)e.getSource();
            GroupedEffortDto groupedEffort = (GroupedEffortDto)model.getValueAt(e.getFirstRow(), 7);
            List<EffortDto> effortList = OverviewGui.this.controller.getEfforts(groupedEffort);
            OrderStatusDto statusNew = (OrderStatusDto)OverviewGui.this.statusComboBox.getSelectedItem();
            for (EffortDto effort : effortList) {
                effort.setOrderStatus(statusNew);
                OverviewGui.this.controller.modifyEffort(effort);
                OverviewGui.this.fillUpperTable();
            }
        }
    }
}

