/*
 * Decompiled with CFR 0.152.
 */
package gui.overview;

import common.GroupedEffortDto;
import gui.overview.AbstractOverviewTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import util.DateAndTimeHelper;

public class UpperOverviewTable
extends AbstractOverviewTable<GroupedEffortDto> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_LABELS_IDENTIFIERS = new String[]{"\u03a3 [hh:mm]", "OrderNr", "Project", "Category", "SubOrder", "SubProject", "Status", "ReferenceToGroupedEffort"};
    public static final int SUMMED_TIME_INDEX = 0;
    public static final int ORDER_NR_INDEX = 1;
    public static final int ORDER_NAME_INDEX = 2;
    public static final int CATEGORY_INDEX = 3;
    public static final int SUBORDER_NR_INDEX = 4;
    public static final int SUBORDER_NAME_INDEX = 5;
    public static final int STATUS_INDEX = 6;
    public static final int GROUPED_EFFORT_INDEX = 7;

    @Override
    public void setColumnWidth() {
        TableColumn column = null;
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        tableRenderer.setHorizontalAlignment(0);
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            column.setCellRenderer(tableRenderer);
            if (i == 2 || i == 5) {
                column.setPreferredWidth(100);
            } else if (i == 0 || i == 1) {
                column.setPreferredWidth(25);
            } else if (i == 7) {
                column.setMinWidth(0);
                column.setMaxWidth(0);
            } else {
                column.setPreferredWidth(50);
            }
            ++i;
        }
    }

    @Override
    protected Object[] getRowArray(GroupedEffortDto groupedEffort) {
        Object[] array = new Object[this.getColumnCount()];
        array[0] = DateAndTimeHelper.getDurationStringMMtoHHMM(groupedEffort.getSummedTime());
        array[1] = groupedEffort.getMainOrder().getMainOrderNumber();
        array[2] = groupedEffort.getMainOrder().getName();
        array[7] = groupedEffort;
        if (groupedEffort.getMainOrder().getOrderCategory() != null) {
            array[3] = groupedEffort.getMainOrder().getOrderCategory();
        }
        if (groupedEffort.getSubOrder() != null) {
            array[4] = groupedEffort.getSubOrder().getSubOrderNumber();
            array[5] = groupedEffort.getSubOrder().getName();
        }
        if (groupedEffort.getStatus() != null) {
            array[6] = groupedEffort.getStatus().getName();
        }
        return array;
    }

    @Override
    protected String[] getColumnIdentifiers() {
        return COLUMN_LABELS_IDENTIFIERS;
    }
}

