/*
 * Decompiled with CFR 0.152.
 */
package gui.projects;

import common.OrderCategoryDto;
import common.OrderStatusDto;
import common.ProjectTimeTrackerDto;
import controller.ApplicationControllerInf;
import gui.projects.elementgroups.AbstractChangeableElementGroup;
import gui.projects.elementgroups.OrderCategoryElementGroup;
import gui.projects.elementgroups.OrderStatusElementGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoryAndStatusPanel {
    private ApplicationControllerInf controller;
    private JFrame mainFrame;
    private JPanel mainPanel = new JPanel();
    private JPanel categoriesPanel = new JPanel();
    private JPanel statusPanel = new JPanel();
    private JPanel closeButtonPanel = new JPanel();
    private OrderCategoryElementGroup categoryGroup;
    private OrderStatusElementGroup statusGroup;

    public CategoryAndStatusPanel(JFrame mainFrame, ApplicationControllerInf controller) {
        this.mainFrame = mainFrame;
        this.controller = controller;
        this.categoryGroup = new OrderCategoryElementGroup(controller);
        this.statusGroup = new OrderStatusElementGroup(controller);
        this.init();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void init() {
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.categoriesPanel, "North");
        this.mainPanel.add((Component)this.statusPanel, "Center");
        this.mainPanel.add((Component)this.closeButtonPanel, "South");
        this.initCategoryPanel();
        this.initStatusPanel();
        this.initCloseButtonPanel();
        this.fillCategoryList();
        this.fillStatusList();
        this.initElementGroupListener(this.categoryGroup, this.categoryGroup.getCatNameTextField());
        this.initElementGroupListener(this.statusGroup, this.statusGroup.getStatusNameTextField());
    }

    private <T extends ProjectTimeTrackerDto> void initElementGroupListener(final AbstractChangeableElementGroup<T> elementGroup, final JTextField aTextField) {
        elementGroup.getEntityListBox().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                aTextField.setText(((ProjectTimeTrackerDto)elementGroup.getEntityListBox().getSelectedValue()).getName());
            }
        });
    }

    private void fillStatusList() {
        List<OrderStatusDto> statusList = this.controller.getAllStatuses();
        this.statusGroup.getListModel().removeAllElements();
        this.statusGroup.getListModel().addAll(statusList);
    }

    private void fillCategoryList() {
        List<OrderCategoryDto> categoryList = this.controller.getAllCategories();
        this.categoryGroup.getListModel().removeAllElements();
        this.categoryGroup.getListModel().addAll(categoryList);
    }

    private void initCategoryPanel() {
        this.categoriesPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.categoriesPanel.setBorder(BorderFactory.createTitledBorder("Categories"));
        JPanel categoriesLeftSidePanel = new JPanel();
        categoriesLeftSidePanel.setLayout(new BorderLayout());
        this.categoriesPanel.add(categoriesLeftSidePanel);
        JPanel categoriesInputPanel = new JPanel();
        categoriesInputPanel.setLayout(new FlowLayout(0));
        categoriesLeftSidePanel.add((Component)categoriesInputPanel, "North");
        categoriesInputPanel.add(new JLabel("Name:   "));
        categoriesInputPanel.add(this.categoryGroup.getCatNameTextField());
        JPanel categoriesButtonGroupPanel = new JPanel();
        categoriesButtonGroupPanel.setLayout(new FlowLayout(0));
        categoriesLeftSidePanel.add((Component)categoriesButtonGroupPanel, "Center");
        categoriesButtonGroupPanel.add(this.categoryGroup.getNewButton());
        categoriesButtonGroupPanel.add(this.categoryGroup.getModifyButton());
        categoriesButtonGroupPanel.add(this.categoryGroup.getDeleteButton());
        JPanel categoriesListPanel = new JPanel();
        categoriesListPanel.setLayout(new BorderLayout());
        this.categoriesPanel.add(categoriesListPanel);
        this.categoryGroup.getEntityListBox().setSelectionMode(0);
        JScrollPane orderScrollPane = new JScrollPane(this.categoryGroup.getEntityListBox());
        categoriesListPanel.add((Component)orderScrollPane, "Center");
    }

    private void initStatusPanel() {
        this.statusPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        JPanel statPanelLinks = new JPanel();
        statPanelLinks.setLayout(new BorderLayout());
        this.statusPanel.add(statPanelLinks);
        JPanel statPanelInputField = new JPanel();
        statPanelLinks.add((Component)statPanelInputField, "North");
        statPanelInputField.add(new JLabel("Name:   "));
        statPanelInputField.add(this.statusGroup.getStatusNameTextField());
        JPanel statPanelObenButtonField = new JPanel();
        statPanelObenButtonField.setLayout(new FlowLayout(0));
        statPanelLinks.add((Component)statPanelObenButtonField, "Center");
        statPanelObenButtonField.add(this.statusGroup.getNewButton());
        statPanelObenButtonField.add(this.statusGroup.getModifyButton());
        statPanelObenButtonField.add(this.statusGroup.getDeleteButton());
        JTextArea hintStatus = new JTextArea("Hint: Top entry is \nthe default setting!", 2, 1);
        hintStatus.setBackground(null);
        hintStatus.setFont(new Font(hintStatus.getFont().getFontName(), 1, 13));
        hintStatus.setLineWrap(true);
        statPanelLinks.add((Component)hintStatus, "South");
        JPanel statPanelRechts = new JPanel();
        statPanelRechts.setLayout(new BorderLayout());
        this.statusPanel.add(statPanelRechts);
        this.statusGroup.getEntityListBox().setSelectionMode(0);
        JScrollPane statScrollPane = new JScrollPane(this.statusGroup.getEntityListBox());
        statPanelRechts.add((Component)statScrollPane, "Center");
    }

    private void initCloseButtonPanel() {
        this.closeButtonPanel.setLayout(new FlowLayout(2));
        this.closeButtonPanel.setBorder(BorderFactory.createEmptyBorder(50, 0, 0, 1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoryAndStatusPanel.this.mainFrame.dispose();
            }
        });
        this.closeButtonPanel.add(closeButton);
    }
}

