/*
 * Decompiled with CFR 0.152.
 */
package gui.projects;

import common.MainOrderDto;
import common.SubOrderDto;
import controller.ApplicationControllerInf;
import gui.projects.elementgroups.MainOrderElementGroup;
import gui.projects.elementgroups.SubOrderElementGroup;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectAdministrationPanel {
    private JFrame mainFrame;
    private JPanel projectPanel = new JPanel();
    private JPanel northPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel southPanel = new JPanel();
    private JTextField searchProjectTextField;
    private JCheckBox visibleBox = new JCheckBox("Show only visible?", true);
    private MainOrderElementGroup mainOrderGroup;
    private SubOrderElementGroup subOrderGroup;
    private ApplicationControllerInf controller;

    public ProjectAdministrationPanel(JFrame mainFrame, ApplicationControllerInf controller) {
        this.mainFrame = mainFrame;
        this.controller = controller;
        this.mainOrderGroup = new MainOrderElementGroup(controller);
        this.subOrderGroup = new SubOrderElementGroup(this.mainOrderGroup, controller);
        this.init();
    }

    private void init() {
        this.projectPanel.setLayout(new BorderLayout());
        this.projectPanel.add((Component)this.northPanel, "North");
        this.projectPanel.add((Component)this.centerPanel, "Center");
        this.projectPanel.add((Component)this.southPanel, "South");
        this.initNorthPanel();
        this.initCenterPanel();
        this.initSouthPanel();
        this.addSearchTextKeyListener();
        this.addVisibleBoxItemListener();
        this.addMainOrderListListener();
        this.addSubOrderListListener();
    }

    private void initSouthPanel() {
        this.southPanel.setLayout(new GridLayout(0, 2));
        JPanel lowerLeftPanel = new JPanel();
        this.southPanel.add(lowerLeftPanel);
        lowerLeftPanel.setLayout(new FlowLayout(0));
        JPanel lowerRightPanel = new JPanel();
        this.southPanel.add(lowerRightPanel);
        lowerRightPanel.setLayout(new FlowLayout(2));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectAdministrationPanel.this.mainFrame.dispose();
            }
        });
        lowerRightPanel.add(closeButton);
    }

    private void initCenterPanel() {
        this.centerPanel.setLayout(new BorderLayout());
        JPanel middleLowerPanel = new JPanel();
        this.centerPanel.add((Component)middleLowerPanel, "South");
        middleLowerPanel.setLayout(new FlowLayout(3));
        middleLowerPanel.add(this.visibleBox);
        JPanel middleCenterPanel = new JPanel();
        this.centerPanel.add((Component)middleCenterPanel, "Center");
        middleCenterPanel.setLayout(new GridLayout(0, 2, 5, 5));
        JList orderList = this.mainOrderGroup.getEntityListBox();
        orderList.setSelectionMode(0);
        JScrollPane orderScrollPane = new JScrollPane(orderList);
        middleCenterPanel.add(orderScrollPane);
        JList subOrderList = this.subOrderGroup.getEntityListBox();
        subOrderList.setSelectionMode(0);
        JScrollPane subOrderScrollPane = new JScrollPane(subOrderList);
        middleCenterPanel.add(subOrderScrollPane);
    }

    private void initNorthPanel() {
        this.northPanel.setLayout(new BorderLayout());
        this.northPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel upperPanel = new JPanel();
        upperPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.northPanel.add((Component)upperPanel, "North");
        upperPanel.setLayout(new FlowLayout(3));
        JLabel searchProjectLabel = new JLabel("Search Order: ");
        upperPanel.add(searchProjectLabel);
        this.searchProjectTextField = new JTextField("", 15);
        upperPanel.add(this.searchProjectTextField);
        JPanel upperCenterPanel = new JPanel();
        upperCenterPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.northPanel.add((Component)upperCenterPanel, "Center");
        JPanel upperCenterWestPanel = new JPanel();
        upperCenterPanel.add(upperCenterWestPanel);
        upperCenterWestPanel.setBorder(BorderFactory.createTitledBorder("Order"));
        upperCenterWestPanel.setLayout(new BorderLayout());
        JPanel upperCenterWestNorthPanel = new JPanel();
        upperCenterWestNorthPanel.setLayout(new GridLayout(0, 2));
        upperCenterWestPanel.add((Component)upperCenterWestNorthPanel, "North");
        upperCenterWestNorthPanel.add(new JLabel("No.:"));
        upperCenterWestNorthPanel.add(this.mainOrderGroup.getOrderNrTextField());
        upperCenterWestNorthPanel.add(new JLabel("Description:            "));
        upperCenterWestNorthPanel.add(this.mainOrderGroup.getOrderNameTextField());
        upperCenterWestNorthPanel.add(new JLabel("Category"));
        upperCenterWestNorthPanel.add(this.mainOrderGroup.getCategoryComboBox());
        upperCenterWestNorthPanel.add(new JLabel(""));
        upperCenterWestNorthPanel.add(this.mainOrderGroup.getOrderVisible());
        JPanel upperCenterWestLowerPanel = new JPanel();
        upperCenterWestLowerPanel.setLayout(new FlowLayout(0));
        upperCenterWestPanel.add((Component)upperCenterWestLowerPanel, "South");
        upperCenterWestLowerPanel.add(this.mainOrderGroup.getNewButton());
        upperCenterWestLowerPanel.add(this.mainOrderGroup.getModifyButton());
        upperCenterWestLowerPanel.add(this.mainOrderGroup.getDeleteButton());
        JPanel upperCenterEastPanel = new JPanel();
        upperCenterPanel.add(upperCenterEastPanel);
        upperCenterEastPanel.setBorder(BorderFactory.createTitledBorder("Suborder"));
        upperCenterEastPanel.setLayout(new BorderLayout());
        JPanel upperCenterEastUpperPanel = new JPanel();
        upperCenterEastUpperPanel.setLayout(new GridLayout(0, 2));
        upperCenterEastPanel.add((Component)upperCenterEastUpperPanel, "North");
        upperCenterEastUpperPanel.add(new JLabel("No. "));
        upperCenterEastUpperPanel.add(this.subOrderGroup.getSubOrderNrTextField());
        upperCenterEastUpperPanel.add(new JLabel("Description:            "));
        upperCenterEastUpperPanel.add(this.subOrderGroup.getSubOrderNameTextField());
        upperCenterEastUpperPanel.add(new JLabel(""));
        upperCenterEastUpperPanel.add(new JLabel(""));
        upperCenterEastUpperPanel.add(new JLabel(""));
        upperCenterEastUpperPanel.add(this.subOrderGroup.getSubOrderVisible());
        JPanel upperCenterEastLowerPanel = new JPanel();
        upperCenterEastLowerPanel.setLayout(new FlowLayout(0));
        upperCenterEastPanel.add((Component)upperCenterEastLowerPanel, "South");
        upperCenterEastLowerPanel.add(this.subOrderGroup.getNewButton());
        upperCenterEastLowerPanel.add(this.subOrderGroup.getModifyButton());
        upperCenterEastLowerPanel.add(this.subOrderGroup.getDeleteButton());
    }

    private void addMainOrderListListener() {
        final JList orderListBox = this.mainOrderGroup.getEntityListBox();
        orderListBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                MainOrderDto selectedOrder = (MainOrderDto)orderListBox.getSelectedValue();
                ProjectAdministrationPanel.this.mainOrderGroup.getOrderNameTextField().setText(selectedOrder.getName());
                ProjectAdministrationPanel.this.mainOrderGroup.getOrderNrTextField().setText(selectedOrder.getMainOrderNumber());
                ProjectAdministrationPanel.this.mainOrderGroup.getOrderVisible().setSelected(selectedOrder.isVisible());
                ProjectAdministrationPanel.this.mainOrderGroup.getCategoryComboBox().setSelectedItem(selectedOrder.getOrderCategory());
                ProjectAdministrationPanel.this.subOrderGroup.getListModel().removeAllElements();
                List<SubOrderDto> subOrderList = ProjectAdministrationPanel.this.controller.getSubOrders(selectedOrder, ProjectAdministrationPanel.this.subOrderGroup.getSubOrderVisible().isSelected());
                subOrderList.sort(Comparator.comparing(SubOrderDto::getSubOrderNumber));
                ProjectAdministrationPanel.this.subOrderGroup.getListModel().addAll(subOrderList);
            }
        });
    }

    private void addSubOrderListListener() {
        final JList subOrderListBox = this.subOrderGroup.getEntityListBox();
        this.subOrderGroup.getEntityListBox().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                SubOrderDto selectedSubOrder = (SubOrderDto)subOrderListBox.getSelectedValue();
                ProjectAdministrationPanel.this.subOrderGroup.getSubOrderNameTextField().setText(selectedSubOrder.getName());
                ProjectAdministrationPanel.this.subOrderGroup.getSubOrderNrTextField().setText(selectedSubOrder.getSubOrderNumber());
                ProjectAdministrationPanel.this.subOrderGroup.getSubOrderVisible().setSelected(selectedSubOrder.isVisible());
            }
        });
    }

    private void addVisibleBoxItemListener() {
        this.visibleBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    Robot keyTrigger = new Robot();
                    ProjectAdministrationPanel.this.searchProjectTextField.requestFocus();
                    keyTrigger.keyRelease(17);
                }
                catch (AWTException e1) {
                    e1.printStackTrace();
                }
                ProjectAdministrationPanel.this.subOrderGroup.getListModel().removeAllElements();
            }
        });
    }

    private void addSearchTextKeyListener() {
        this.searchProjectTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ProjectAdministrationPanel.this.mainOrderGroup.getListModelOrder().removeAllElements();
                ProjectAdministrationPanel.this.mainOrderGroup.fillEntityList(ProjectAdministrationPanel.this.controller.getMainOrdersByName(ProjectAdministrationPanel.this.searchProjectTextField.getText(), ProjectAdministrationPanel.this.visibleBox.isSelected()));
            }
        });
    }

    public JPanel getMainPanel() {
        return this.projectPanel;
    }

    public void fillCategories() {
        this.mainOrderGroup.fillCategories();
    }
}

