/*
 * Decompiled with CFR 0.152.
 */
package gui.projects;

import controller.ApplicationControllerInf;
import gui.projects.CategoryAndStatusPanel;
import gui.projects.ProjectAdministrationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProjectsGui {
    private JFrame mainFrame = new JFrame("Projects/Categories/Status");
    private JTabbedPane centerPane = new JTabbedPane();
    private CategoryAndStatusPanel categoryAndStatusPanel;
    private ProjectAdministrationPanel projectPanel;

    public ProjectsGui(ApplicationControllerInf controller) {
        this.categoryAndStatusPanel = new CategoryAndStatusPanel(this.mainFrame, controller);
        this.projectPanel = new ProjectAdministrationPanel(this.mainFrame, controller);
        this.initMainFrame();
        this.addTabActionListener();
    }

    private void initMainFrame() {
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setLayout(new BorderLayout());
        this.mainFrame.add((Component)this.centerPane, "Center");
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icon.png"));
            this.mainFrame.setIconImage(image);
        }
        catch (IOException e) {
            System.out.println("Can't find logo.");
            e.printStackTrace();
        }
        this.centerPane.addTab("Projects", this.projectPanel.getMainPanel());
        this.centerPane.addTab("Categories/Status", this.categoryAndStatusPanel.getMainPanel());
        this.mainFrame.setSize(500, 500);
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setVisible(true);
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    private void addTabActionListener() {
        this.centerPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProjectsGui.this.projectPanel.fillCategories();
            }
        });
    }
}

