/*
 * Decompiled with CFR 0.152.
 */
package gui.projects.elementgroups;

import common.ProjectTimeTrackerDto;
import controller.ApplicationControllerInf;
import jakarta.persistence.PersistenceException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.hibernate.exception.ConstraintViolationException;

public abstract class AbstractChangeableElementGroup<T extends ProjectTimeTrackerDto> {
    protected ApplicationControllerInf controller;
    protected JButton newButton = new JButton("New");
    protected JButton modifyButton = new JButton("Modify");
    protected JButton deleteButton = new JButton("Delete");
    protected DefaultListModel<T> listModel = new DefaultListModel();
    protected JList<T> entityListBox = new JList<T>(this.listModel);

    public AbstractChangeableElementGroup(ApplicationControllerInf controller) {
        this.controller = controller;
        this.addButtonActionListener();
    }

    public abstract T getNewEntity();

    public abstract T getSelectedEntity();

    protected abstract void resetFields();

    public JButton getNewButton() {
        return this.newButton;
    }

    public JButton getModifyButton() {
        return this.modifyButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JList<T> getEntityListBox() {
        return this.entityListBox;
    }

    public void fillEntityList(List<T> entityList) {
        this.listModel.removeAllElements();
        entityList.sort(Comparator.naturalOrder());
        this.listModel.addAll(entityList);
    }

    public DefaultListModel<T> getListModel() {
        return this.listModel;
    }

    private void addToEntityList(Object newEntity) {
        ProjectTimeTrackerDto castedNewEntity = (ProjectTimeTrackerDto)newEntity;
        this.listModel.add(0, castedNewEntity);
    }

    private boolean isUnique(Object entity) {
        int i = 0;
        while (i < this.listModel.size()) {
            T currentObject = this.listModel.get(i);
            if (currentObject.toString().equals(entity.toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasChanged(Object entity) {
        ProjectTimeTrackerDto castedentity = (ProjectTimeTrackerDto)entity;
        T newEntity = this.getNewEntity();
        return !newEntity.equals(castedentity);
    }

    private void addButtonActionListener() {
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object newEntity = AbstractChangeableElementGroup.this.getNewEntity();
                if (!AbstractChangeableElementGroup.this.isUnique(newEntity)) {
                    JOptionPane.showMessageDialog(AbstractChangeableElementGroup.this.newButton, "Entry already exists!");
                    return;
                }
                AbstractChangeableElementGroup.this.persistEntity(newEntity);
                AbstractChangeableElementGroup.this.addToEntityList(newEntity);
            }
        });
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedEntity = AbstractChangeableElementGroup.this.getSelectedEntity();
                if (selectedEntity == null) {
                    JOptionPane.showMessageDialog(AbstractChangeableElementGroup.this.modifyButton, "Select element!");
                    return;
                }
                if (!AbstractChangeableElementGroup.this.hasChanged(selectedEntity)) {
                    JOptionPane.showMessageDialog(AbstractChangeableElementGroup.this.modifyButton, "There are no changes!");
                    return;
                }
                Object modifiedEntity = AbstractChangeableElementGroup.this.getNewEntity();
                ((ProjectTimeTrackerDto)modifiedEntity).setId(((ProjectTimeTrackerDto)selectedEntity).getId());
                AbstractChangeableElementGroup.this.modifyEntity(modifiedEntity);
                int selectedIndex = AbstractChangeableElementGroup.this.entityListBox.getSelectedIndex();
                AbstractChangeableElementGroup.this.listModel.removeElementAt(selectedIndex);
                AbstractChangeableElementGroup.this.listModel.add(selectedIndex, modifiedEntity);
                AbstractChangeableElementGroup.this.entityListBox.setModel(AbstractChangeableElementGroup.this.listModel);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = JOptionPane.showConfirmDialog(AbstractChangeableElementGroup.this.deleteButton, "Delete '" + AbstractChangeableElementGroup.this.getSelectedEntity() + "'?", "Delete", 0, 2);
                if (i == 1) {
                    return;
                }
                try {
                    AbstractChangeableElementGroup.this.controller.deleteEntity((ProjectTimeTrackerDto)AbstractChangeableElementGroup.this.getSelectedEntity());
                    AbstractChangeableElementGroup.this.listModel.removeElement(AbstractChangeableElementGroup.this.getSelectedEntity());
                }
                catch (PersistenceException f) {
                    this.handleDeleteException(f);
                }
            }

            private void handleDeleteException(PersistenceException f) {
                if (f.getCause() instanceof ConstraintViolationException) {
                    JOptionPane.showMessageDialog(AbstractChangeableElementGroup.this.deleteButton, "Entry cannot be deleted: Subordinate record(s) found! These must be deleted first.");
                    return;
                }
                f.printStackTrace();
            }
        });
    }

    protected abstract void modifyEntity(T var1);

    protected abstract void persistEntity(T var1);
}

