/*
 * Decompiled with CFR 0.152.
 */
package gui.projects.elementgroups;

import common.MainOrderDto;
import controller.ApplicationControllerInf;
import gui.projects.elementgroups.AbstractChangeableElementGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MainOrderElementGroup
extends AbstractChangeableElementGroup<MainOrderDto> {
    private JTextField orderNrTextField = new JTextField("");
    private JTextField orderNameTextField = new JTextField("");
    private JComboBox<String> categoryComboBox = new JComboBox();
    private JCheckBox orderVisible = new JCheckBox("visible?", true);

    public MainOrderElementGroup(ApplicationControllerInf controller) {
        super(controller);
        this.fillCategories();
        this.fillMainOrders();
        this.addVisibleBoxListener();
    }

    private void addVisibleBoxListener() {
        this.orderVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainOrderElementGroup.this.getSelectedEntity().setVisible(MainOrderElementGroup.this.orderVisible.isSelected());
            }
        });
    }

    private void fillMainOrders() {
        this.fillEntityList(this.controller.getAllMainOrders(this.orderVisible.isSelected()));
    }

    public void fillCategories() {
        this.categoryComboBox.removeAllItems();
        this.controller.getAllCategories().stream().forEach(c -> this.categoryComboBox.addItem(c.getName()));
    }

    @Override
    public MainOrderDto getNewEntity() {
        String orderNr = this.orderNrTextField.getText();
        String description = this.orderNameTextField.getText();
        String category = (String)this.categoryComboBox.getSelectedItem();
        boolean visible = this.orderVisible.isSelected();
        return new MainOrderDto.Builder().withMainOrderName(description).withMainOrderNumber(orderNr).withOrderCategery(category).withVisible(visible).build();
    }

    @Override
    public MainOrderDto getSelectedEntity() {
        return (MainOrderDto)this.entityListBox.getSelectedValue();
    }

    @Override
    protected void resetFields() {
        this.orderNameTextField.setText("");
        this.orderNrTextField.setText("");
        this.categoryComboBox.setSelectedIndex(-1);
    }

    public JTextField getOrderNrTextField() {
        return this.orderNrTextField;
    }

    public JTextField getOrderNameTextField() {
        return this.orderNameTextField;
    }

    public JComboBox<String> getCategoryComboBox() {
        return this.categoryComboBox;
    }

    public JCheckBox getOrderVisible() {
        return this.orderVisible;
    }

    public DefaultListModel<MainOrderDto> getListModelOrder() {
        return this.listModel;
    }

    @Override
    protected void persistEntity(MainOrderDto newEntity) {
        this.controller.createMainOrder(newEntity);
    }

    @Override
    protected void modifyEntity(MainOrderDto selectedEntity) {
        this.controller.modifyMainOrder(selectedEntity);
    }
}

