/*
 * Decompiled with CFR 0.152.
 */
package gui.projects.elementgroups;

import common.OrderStatusDto;
import controller.ApplicationControllerInf;
import gui.projects.elementgroups.AbstractChangeableElementGroup;
import javax.swing.JTextField;

public class OrderStatusElementGroup
extends AbstractChangeableElementGroup<OrderStatusDto> {
    private JTextField statusNameTextField = new JTextField("", 10);

    public OrderStatusElementGroup(ApplicationControllerInf controller) {
        super(controller);
    }

    @Override
    public OrderStatusDto getNewEntity() {
        OrderStatusDto statusDto = new OrderStatusDto();
        statusDto.setName(this.statusNameTextField.getText());
        return statusDto;
    }

    @Override
    public OrderStatusDto getSelectedEntity() {
        return (OrderStatusDto)this.entityListBox.getSelectedValue();
    }

    @Override
    protected void resetFields() {
        this.statusNameTextField.setText("");
    }

    public JTextField getStatusNameTextField() {
        return this.statusNameTextField;
    }

    @Override
    protected void persistEntity(OrderStatusDto newEntity) {
        this.controller.createOrderStatus(newEntity.getName());
    }

    @Override
    protected void modifyEntity(OrderStatusDto selectedEntity) {
        this.controller.modifyOrderStatus(selectedEntity);
    }
}

