/*
 * Decompiled with CFR 0.152.
 */
package gui.projects.elementgroups;

import common.SubOrderDto;
import controller.ApplicationControllerInf;
import gui.projects.elementgroups.AbstractChangeableElementGroup;
import gui.projects.elementgroups.MainOrderElementGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class SubOrderElementGroup
extends AbstractChangeableElementGroup<SubOrderDto> {
    private JTextField subOrderNrTextField = new JTextField("");
    private JTextField subOrderNameTextField = new JTextField("");
    private JCheckBox subOrderVisible = new JCheckBox("visible?", true);
    private MainOrderElementGroup mainOrderGroup;

    public SubOrderElementGroup(MainOrderElementGroup mainOrderGroup, ApplicationControllerInf controller) {
        super(controller);
        this.mainOrderGroup = mainOrderGroup;
        this.addVisibleBoxListener();
    }

    private void addVisibleBoxListener() {
        this.subOrderVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubOrderElementGroup.this.getSelectedEntity().setVisible(SubOrderElementGroup.this.subOrderVisible.isSelected());
            }
        });
    }

    @Override
    public SubOrderDto getNewEntity() {
        String subDescription = this.subOrderNameTextField.getText();
        String subOrderNr = this.subOrderNrTextField.getText();
        boolean visible = this.subOrderVisible.isSelected();
        return new SubOrderDto.Builder().withMainOrderId(this.mainOrderGroup.getSelectedEntity().getId()).withSubOrderName(subDescription).withSubOrderNumber(subOrderNr).withVisible(visible).build();
    }

    @Override
    public SubOrderDto getSelectedEntity() {
        return (SubOrderDto)this.entityListBox.getSelectedValue();
    }

    @Override
    protected void resetFields() {
        this.subOrderNameTextField.setText("");
        this.subOrderNrTextField.setText("");
    }

    public JTextField getSubOrderNrTextField() {
        return this.subOrderNrTextField;
    }

    public JTextField getSubOrderNameTextField() {
        return this.subOrderNameTextField;
    }

    public JCheckBox getSubOrderVisible() {
        return this.subOrderVisible;
    }

    public void setMainOrderGroup(MainOrderElementGroup mainOrderGroup) {
        this.mainOrderGroup = mainOrderGroup;
    }

    @Override
    protected void persistEntity(SubOrderDto newEntity) {
        this.controller.createSubOrder(newEntity);
    }

    @Override
    protected void modifyEntity(SubOrderDto selectedEntity) {
        this.controller.modifySubOrder(selectedEntity);
    }
}

