/*
 * Decompiled with CFR 0.152.
 */
package gui.recorder;

import common.MainOrderDto;
import common.SubOrderDto;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import util.SteppedComboBox;

public class EffortTable
extends JTable {
    DefaultTableModel tableModel = new DefaultTableModel();
    DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
    private SteppedComboBox<MainOrderDto> editOrderBox = new SteppedComboBox();
    private SteppedComboBox<SubOrderDto> editSubOrderBox = new SteppedComboBox();
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_LABELS_OVERVIEW_STATE = new String[]{"ID", "Start", "Stop", "Pause", "\u03a3 [min]", "OrderNr", "Project", "Category", "SubOrder", "SubProject", "Status", "Comment"};
    private static final String[] REMOVED_COLUMNS_IN_MODIFY_STATE = new String[]{"\u03a3 [min]", "Project", "Category", "SubProject", "Status"};

    public EffortTable() {
        this.setModel(this.tableModel);
        this.setColumnModel(new DefaultTableColumnModel());
        this.setColumnLabels();
        this.setColumnWidth();
    }

    public void addTableOrderComboBox(List<MainOrderDto> orderList, CellEditorListener editOrderBoxListener) {
        this.editOrderBox.removeAllItems();
        this.editOrderBox.setModel(new DefaultComboBoxModel<MainOrderDto>(orderList.toArray(new MainOrderDto[0])));
        this.editOrderBox.setPopupWidth(250);
        DefaultCellEditor orderEditor = new DefaultCellEditor(this.editOrderBox);
        this.getColumnModel().getColumn(4).setCellEditor(orderEditor);
        orderEditor.addCellEditorListener(editOrderBoxListener);
    }

    public void addTableSubOrderComboBox() {
        this.editSubOrderBox.setPopupWidth(250);
        DefaultCellEditor subOrderEditor = new DefaultCellEditor(this.editSubOrderBox);
        this.getColumnModel().getColumn(5).setCellEditor(subOrderEditor);
    }

    public void removeNotSelectedLines() {
        int selectedRow = this.getSelectedRow();
        int rowCount = this.getModel().getRowCount();
        DefaultTableModel tableModel = (DefaultTableModel)this.getModel();
        int i = rowCount - 1;
        while (i >= 0) {
            if (i != selectedRow) {
                tableModel.removeRow(i);
            }
            --i;
        }
    }

    public void removeColumnsForModification() {
        String[] stringArray = REMOVED_COLUMNS_IN_MODIFY_STATE;
        int n = REMOVED_COLUMNS_IN_MODIFY_STATE.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.removeColumn(this.getColumn(s));
            ++n2;
        }
    }

    public void setColumnLabels() {
        this.tableModel.setColumnIdentifiers(COLUMN_LABELS_OVERVIEW_STATE);
    }

    public void setColumnWidth() {
        TableColumn column = null;
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        tableRenderer.setHorizontalAlignment(0);
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            column.setCellRenderer(tableRenderer);
            if (i == 0) {
                column.setPreferredWidth(1);
            } else if (i > 0 && i < 5) {
                column.setPreferredWidth(50);
            } else {
                column.setPreferredWidth(100);
            }
            ++i;
        }
    }

    public void setColumnWidthForModification() {
        TableColumn column = null;
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        tableRenderer.setHorizontalAlignment(0);
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            column.setCellRenderer(tableRenderer);
            if (i == 0) {
                column.setPreferredWidth(column.getPreferredWidth());
            } else {
                column.setPreferredWidth(100);
            }
            ++i;
        }
    }

    public MainOrderDto getSelectedMainOrder() {
        return (MainOrderDto)this.editOrderBox.getSelectedItem();
    }

    public SubOrderDto getSelectedSubOrder() {
        return (SubOrderDto)this.editSubOrderBox.getSelectedItem();
    }

    public SteppedComboBox<MainOrderDto> getEditOrderBox() {
        return this.editOrderBox;
    }

    public SteppedComboBox<SubOrderDto> getEditSubOrderBox() {
        return this.editSubOrderBox;
    }
}

