/*
 * Decompiled with CFR 0.152.
 */
package gui.recorder;

import common.EffortDto;
import common.MainOrderDto;
import common.OrderStatusDto;
import common.SubOrderDto;
import controller.ApplicationControllerInf;
import gui.overview.OverviewGui;
import gui.projects.ProjectsGui;
import gui.recorder.DigitalClock;
import gui.recorder.EffortTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.jdatepicker.impl.JDatePickerImpl;
import util.DateAndTimeHelper;
import util.PttJDatePickerPanel;
import util.SteppedComboBox;

public class RecorderGui {
    private ApplicationControllerInf controller;
    private JFrame mainFrame = new JFrame("ProjectTimeTracker V2.1");
    SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm");
    private JPanel upperPanel = new JPanel();
    private PttJDatePickerPanel datePickerPanel;
    private JButton startButton = new JButton("START");
    private JButton stopButton = new JButton("STOP / Pause");
    private JButton projectsButton = new JButton("Projects");
    private JButton overviewButton = new JButton("Overview");
    private JPanel recordPanel = new JPanel(new BorderLayout());
    private JTextField startTimeField = new JTextField("", 3);
    private JTextField stopTimeField = new JTextField("", 3);
    private JTextField pauseTimeField = new JTextField("", 2);
    private JTextField searchField = new JTextField("", 9);
    private SteppedComboBox<MainOrderDto> orderComboBox = new SteppedComboBox();
    private JTextField catLabel = new JTextField("", 7);
    private JButton saveButton = new JButton("save");
    private SteppedComboBox<SubOrderDto> subOrderComboBox = new SteppedComboBox();
    private SteppedComboBox<OrderStatusDto> statusComboBox = new SteppedComboBox();
    private JTextField commentTextField = new JTextField("", 10);
    private JPanel overviewPanel = new JPanel(new BorderLayout());
    private EffortTable overviewTable = new EffortTable();
    private JScrollPane scrollPane = new JScrollPane(this.overviewTable);
    private JButton modifyButton = new JButton("modify");
    private JButton deleteButton = new JButton("delete");
    private JButton cancelButton = new JButton("cancel");
    private JButton closeButton = new JButton("EXIT");
    private boolean itemEventTrigger = true;
    private TableMouseAdapter tableMouseListener = new TableMouseAdapter();
    private CellEditorListener editOrderBoxListener = new EditOrderBoxListener();

    public RecorderGui(ApplicationControllerInf controller) {
        this.controller = controller;
        this.initUpperPanel();
        this.initRecordPanel();
        this.initOverviewPanel();
        this.initMainFrame();
        this.mainFrame.setVisible(true);
        this.initData();
        this.initActionListener();
        this.fillOverviewTable();
    }

    private void initActionListener() {
        this.addMainOrderSearchKeyListener();
        this.addProjectsButtonActionListener();
        this.addOverviewButtonActionListener();
        this.orderComboBox.addItemListener(new ComboBoxListener());
        this.addSaveButtonActionListener();
        this.addModifyButtonActionListener();
        this.addDeleteButtonActionListener();
        this.addCancelButtonActionListener();
        this.addExitButtonActionListener();
        this.addMainFrameWindowListener();
        this.addDatePickerActionListener();
        this.overviewTable.addMouseListener(this.tableMouseListener);
    }

    private void initData() {
        this.fillOrderComboBox();
        this.fillStatusComboBox();
    }

    private void fillOrderComboBox() {
        this.itemEventTrigger = false;
        this.orderComboBox.removeAllItems();
        List<MainOrderDto> orderList = this.controller.getMainOrdersByName(this.searchField.getText(), true);
        this.orderComboBox.setModel(new DefaultComboBoxModel<MainOrderDto>(orderList.toArray(new MainOrderDto[0])));
        this.itemEventTrigger = true;
        this.orderComboBox.setSelectedIndex(-1);
    }

    private void addMainOrderSearchKeyListener() {
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RecorderGui.this.fillOrderComboBox();
                RecorderGui.this.orderComboBox.setSelectedIndex(-1);
                if (RecorderGui.this.orderComboBox.getItemCount() > 0) {
                    RecorderGui.this.orderComboBox.setSelectedIndex(0);
                }
            }
        });
    }

    private void addProjectsButtonActionListener() {
        this.projectsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectsGui projectsGui = new ProjectsGui(RecorderGui.this.controller);
                projectsGui.getMainFrame().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent f) {
                        (this).RecorderGui.this.subOrderComboBox.setSelectedIndex(-1);
                        RecorderGui.this.fillOverviewTable();
                        RecorderGui.this.fillOrderComboBox();
                    }
                });
            }
        });
    }

    private void fillOverviewTable() {
        DefaultTableModel overviewTableModel = (DefaultTableModel)this.overviewTable.getModel();
        overviewTableModel.setRowCount(0);
        LocalDate localDate = DateAndTimeHelper.getLocalDateFromDatePicker(this.datePickerPanel.getDatePicker());
        List<EffortDto> effortList = this.controller.getEffortByDay(localDate);
        for (EffortDto effort : effortList) {
            overviewTableModel.addRow(effort.getTableRow());
        }
        this.setBorderLabel("Overview | Total time " + this.controller.getTotalTime(localDate));
    }

    private void addOverviewButtonActionListener() {
        this.overviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewGui overviewGui = new OverviewGui(RecorderGui.this.controller);
                overviewGui.getMainFrame().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent f) {
                        (this).RecorderGui.this.subOrderComboBox.setSelectedIndex(-1);
                        RecorderGui.this.fillOrderComboBox();
                    }
                });
            }
        });
    }

    private void fillStatusComboBox() {
        List<OrderStatusDto> statusList = this.controller.getAllStatuses();
        this.statusComboBox.setModel(new DefaultComboBoxModel<OrderStatusDto>(statusList.toArray(new OrderStatusDto[0])));
    }

    private void addSaveButtonActionListener() {
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RecorderGui.this.selectedProjectIsValid()) {
                    return;
                }
                try {
                    String startTime = RecorderGui.this.startTimeField.getText();
                    String stopTime = RecorderGui.this.stopTimeField.getText();
                    if (!RecorderGui.this.timeInputsAreValid(startTime, stopTime)) {
                        return;
                    }
                    String pauseTime = RecorderGui.this.pauseTimeField.getText();
                    if (!RecorderGui.this.pauseInputIsValid(pauseTime)) {
                        return;
                    }
                    EffortDto newEffort = RecorderGui.this.createNewEffortDto();
                    RecorderGui.this.controller.createEffort(newEffort);
                    RecorderGui.this.fillOverviewTable();
                    RecorderGui.this.startTimeField.setText(RecorderGui.this.stopTimeField.getText());
                    RecorderGui.this.stopTimeField.setText("");
                    RecorderGui.this.commentTextField.setText("");
                    RecorderGui.this.pauseTimeField.setText("");
                }
                catch (Exception f) {
                    JOptionPane.showMessageDialog(RecorderGui.this.mainFrame, f.getMessage(), "Error", 0);
                }
            }
        });
    }

    protected EffortDto createNewEffortDto() {
        EffortDto effortDto = new EffortDto();
        effortDto.setEffortDate(DateAndTimeHelper.getLocalDateFromDatePicker(this.datePickerPanel.getDatePicker()));
        effortDto.setStartTime(DateAndTimeHelper.getLocalTimeHHMM(this.startTimeField.getText()));
        effortDto.setEndTime(DateAndTimeHelper.getLocalTimeHHMM(this.stopTimeField.getText()));
        effortDto.setPauseTime(DateAndTimeHelper.getLocalTimeMM(this.pauseTimeField.getText()));
        effortDto.setMainOrder((MainOrderDto)this.orderComboBox.getSelectedItem());
        effortDto.setSubOrder(this.subOrderComboBox.getSelectedIndex() == -1 ? null : (SubOrderDto)this.subOrderComboBox.getSelectedItem());
        effortDto.setComment(this.commentTextField.getText());
        effortDto.setOrderStatus((OrderStatusDto)this.statusComboBox.getSelectedItem());
        return effortDto;
    }

    private boolean selectedProjectIsValid() {
        if (this.orderComboBox.getSelectedIndex() == -1) {
            String message = "Select valid project!";
            JOptionPane.showMessageDialog(this.mainFrame, message, "Invalid Project", 1);
            return false;
        }
        return true;
    }

    private boolean timeInputsAreValid(String ... dateStrings) {
        String[] stringArray = dateStrings;
        int n = dateStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String dateString = stringArray[n2];
            if (!DateAndTimeHelper.isTimeValidHHMM(dateString)) {
                String message = "Invalid input in Start/Stop fields. Use format hh:mm.";
                JOptionPane.showMessageDialog(this.mainFrame, message, "Error", 1);
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean pauseInputIsValid(String pauseString) {
        if (!DateAndTimeHelper.isTimeValidMM(pauseString)) {
            String message = "Invalid input in pause field. Use format mm.";
            JOptionPane.showMessageDialog(this.mainFrame, message, "Error", 1);
            return false;
        }
        return true;
    }

    private void addModifyButtonActionListener() {
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderGui.this.overviewTable.getDefaultEditor(this.getClass()).stopCellEditing();
                int effortId = Integer.valueOf((String)RecorderGui.this.overviewTable.getValueAt(0, 0));
                EffortDto effort = RecorderGui.this.controller.getEffortById(effortId);
                String startTime = (String)RecorderGui.this.overviewTable.getValueAt(0, 1);
                String stopTime = (String)RecorderGui.this.overviewTable.getValueAt(0, 2);
                if (!RecorderGui.this.timeInputsAreValid(startTime, stopTime)) {
                    return;
                }
                String pauseTime = (String)RecorderGui.this.overviewTable.getValueAt(0, 3);
                if (!RecorderGui.this.pauseInputIsValid(pauseTime)) {
                    return;
                }
                MainOrderDto selectedMainOrder = RecorderGui.this.overviewTable.getSelectedMainOrder();
                SubOrderDto selectedSubOrder = RecorderGui.this.overviewTable.getSelectedSubOrder();
                String comment = (String)RecorderGui.this.overviewTable.getValueAt(0, 6);
                this.modifyEffort(effort, startTime, stopTime, pauseTime, selectedMainOrder, selectedSubOrder, comment);
                RecorderGui.this.controller.modifyEffort(effort);
                RecorderGui.this.fillOverviewTable();
                RecorderGui.this.resetOverviewTable();
            }

            private void modifyEffort(EffortDto effort, String startTime, String stopTime, String pauseTime, MainOrderDto selectedMainOrder, SubOrderDto selectedSubOrder, String comment) {
                effort.setStartTime(DateAndTimeHelper.getLocalTimeHHMM(startTime));
                effort.setEndTime(DateAndTimeHelper.getLocalTimeHHMM(stopTime));
                effort.setPauseTime(DateAndTimeHelper.getLocalTimeMM(pauseTime));
                effort.setMainOrder(selectedMainOrder);
                effort.setSubOrder(selectedSubOrder);
                effort.setComment(comment);
            }
        });
    }

    public void resetOverviewTable() {
        this.overviewTable.getColumnModel().getColumn(4).getCellEditor().removeCellEditorListener(this.editOrderBoxListener);
        this.overviewTable.setColumnLabels();
        this.modifyButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.overviewTable.addMouseListener(this.tableMouseListener);
        this.overviewTable.setColumnWidth();
    }

    private void addDeleteButtonActionListener() {
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int effortId = Integer.valueOf(RecorderGui.this.overviewTable.getValueAt(0, 0).toString());
                EffortDto effort = RecorderGui.this.controller.getEffortById(effortId);
                int i = JOptionPane.showConfirmDialog(RecorderGui.this.mainFrame, "Delete selected effort?", "Delete", 0, 2);
                if (i == 1) {
                    return;
                }
                RecorderGui.this.controller.deleteEntity(effort);
                RecorderGui.this.fillOverviewTable();
                RecorderGui.this.resetOverviewTable();
            }
        });
    }

    private void addCancelButtonActionListener() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderGui.this.fillOverviewTable();
                RecorderGui.this.resetOverviewTable();
            }
        });
    }

    private void addExitButtonActionListener() {
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    private void addMainFrameWindowListener() {
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void addDatePickerActionListener() {
        this.datePickerPanel.getDatePicker().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RecorderGui.this.fillOverviewTable();
                RecorderGui.this.changeDatePickerColorIfNotToday(RecorderGui.this.datePickerPanel.getDatePicker());
            }
        });
    }

    protected void changeDatePickerColorIfNotToday(JDatePickerImpl jDatePickerImpl) {
        LocalDate selectedDate = DateAndTimeHelper.getLocalDateFromDatePicker(jDatePickerImpl);
        if (selectedDate.isEqual(LocalDate.now())) {
            jDatePickerImpl.getJFormattedTextField().setBackground(Color.WHITE);
        } else {
            jDatePickerImpl.getJFormattedTextField().setBackground(Color.YELLOW);
        }
    }

    private void initUpperPanel() {
        this.upperPanel.setLayout(new BorderLayout());
        JPanel upperWestPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        upperWestPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.datePickerPanel = new PttJDatePickerPanel();
        this.datePickerPanel.getPickerPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Date"), BorderFactory.createBevelBorder(1)));
        upperWestPanel.add(this.datePickerPanel.getPickerPanel());
        final JLabel clockLabel = new DigitalClock().getDigitalClock();
        upperWestPanel.add(clockLabel);
        this.upperPanel.add((Component)upperWestPanel, "West");
        JPanel upperCenterPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        upperCenterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 5, 100), BorderFactory.createTitledBorder("Record")));
        this.startButton.setBackground(Color.GREEN);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RecorderGui.this.stopTimeField.getText().equals("")) {
                    RecorderGui.this.startTimeField.setText(clockLabel.getText());
                    RecorderGui.this.stopButton.setBackground(Color.RED);
                    RecorderGui.this.startButton.setBackground(Color.LIGHT_GRAY);
                } else {
                    try {
                        Date restartDate = RecorderGui.this.timeFormatter.parse(clockLabel.getText());
                        Date stopDate = RecorderGui.this.timeFormatter.parse(RecorderGui.this.stopTimeField.getText());
                        long pauseLong = restartDate.getTime() - stopDate.getTime() + (RecorderGui.this.pauseTimeField.getText().equals("") ? 0L : Long.parseLong(RecorderGui.this.pauseTimeField.getText()));
                        long pauseMinutes = pauseLong / 60000L;
                        RecorderGui.this.pauseTimeField.setText(String.valueOf(pauseMinutes));
                        RecorderGui.this.stopTimeField.setText("");
                        RecorderGui.this.stopButton.setBackground(Color.RED);
                        RecorderGui.this.startButton.setBackground(Color.LIGHT_GRAY);
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.stopButton.setBackground(Color.GRAY);
        this.stopButton.setForeground(Color.WHITE);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderGui.this.stopTimeField.setText(clockLabel.getText());
                RecorderGui.this.stopButton.setBackground(Color.GRAY);
                RecorderGui.this.startButton.setBackground(Color.GREEN);
            }
        });
        upperCenterPanel.add(this.startButton);
        upperCenterPanel.add(this.stopButton);
        this.upperPanel.add((Component)upperCenterPanel, "Center");
        JPanel upperEastPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        upperEastPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 100), BorderFactory.createTitledBorder("Tools")));
        upperEastPanel.add(this.projectsButton);
        upperEastPanel.add(this.overviewButton);
        this.upperPanel.add((Component)upperEastPanel, "East");
    }

    private void initRecordPanel() {
        JPanel recordLeftPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        recordLeftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Time")));
        JPanel recordLeftNorthPanel = new JPanel(new GridLayout(0, 2));
        JPanel recordLeftSouthPanel = new JPanel(new GridLayout(0, 2));
        recordLeftNorthPanel.add(new JLabel("Start: "));
        recordLeftNorthPanel.add(this.startTimeField);
        recordLeftPanel.add(recordLeftNorthPanel);
        recordLeftSouthPanel.add(new JLabel("Stop: "));
        recordLeftSouthPanel.add(this.stopTimeField);
        recordLeftPanel.add(recordLeftSouthPanel);
        this.recordPanel.add((Component)recordLeftPanel, "West");
        JPanel recordCenterPanel = new JPanel(new BorderLayout());
        JPanel recordCenterLeftPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        recordCenterLeftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Project")));
        JPanel recordCenterLeftObenPanel = new JPanel(new BorderLayout());
        recordCenterLeftObenPanel.add((Component)new JLabel("Search: "), "West");
        recordCenterLeftObenPanel.add((Component)this.searchField, "Center");
        recordCenterLeftPanel.add(recordCenterLeftObenPanel);
        JPanel recordCenterLeftUntenPanel = new JPanel(new BorderLayout());
        this.orderComboBox.setPopupWidth(300);
        this.orderComboBox.setPreferredSize(new Dimension(150, 1));
        recordCenterLeftUntenPanel.add(this.orderComboBox, "West");
        recordCenterLeftUntenPanel.add((Component)new JLabel(""), "Center");
        recordCenterLeftPanel.add(recordCenterLeftUntenPanel);
        recordCenterPanel.add((Component)recordCenterLeftPanel, "West");
        this.recordPanel.add((Component)recordCenterPanel, "Center");
        JPanel recordCenterWestPanel = new JPanel(new BorderLayout());
        recordCenterWestPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        recordCenterWestPanel.add((Component)this.saveButton, "Center");
        recordCenterPanel.add((Component)recordCenterWestPanel, "Center");
        JPanel recordCenterEastPanel = new JPanel(new FlowLayout(0));
        recordCenterEastPanel.add(new JLabel("Pause: "));
        recordCenterEastPanel.add(this.pauseTimeField);
        recordCenterEastPanel.add(new JLabel("min"));
        recordCenterWestPanel.add((Component)recordCenterEastPanel, "South");
        JPanel recordRightPanel = new JPanel(new BorderLayout());
        recordRightPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Additonal")));
        JPanel recordRightWestPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        JPanel recordRightWestObenPanel = new JPanel(new BorderLayout());
        recordRightWestObenPanel.add((Component)new JLabel("Sub/Status: "), "Center");
        this.subOrderComboBox.setPreferredSize(new Dimension(100, 1));
        this.subOrderComboBox.setPopupWidth(250);
        recordRightWestObenPanel.add(this.subOrderComboBox, "East");
        recordRightWestPanel.add(recordRightWestObenPanel);
        JPanel recordRightWestUntenPanel = new JPanel(new BorderLayout());
        recordRightWestUntenPanel.add((Component)new JLabel("Comment: "), "West");
        recordRightWestUntenPanel.add((Component)this.commentTextField, "Center");
        recordRightWestPanel.add(recordRightWestUntenPanel);
        recordRightPanel.add((Component)recordRightWestPanel, "West");
        JPanel recordRightCenterPanel = new JPanel(new GridLayout(2, 0, 5, 5));
        recordRightCenterPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.statusComboBox.setPreferredSize(new Dimension(70, 1));
        this.statusComboBox.setPopupWidth(120);
        recordRightCenterPanel.add(this.statusComboBox);
        this.catLabel.setEditable(false);
        recordRightCenterPanel.add(this.catLabel);
        recordRightPanel.add((Component)recordRightCenterPanel, "Center");
        this.recordPanel.add((Component)recordRightPanel, "East");
        this.recordPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 127, 80), 2), "Record")));
        this.upperPanel.add((Component)this.recordPanel, "South");
    }

    private void initOverviewPanel() {
        this.scrollPane.setLayout(new ScrollPaneLayout());
        this.overviewPanel.add((Component)this.scrollPane, "Center");
        this.overviewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), BorderFactory.createTitledBorder("Overview")));
        JPanel overviewSouthPanel = new JPanel(new GridLayout(0, 8, 5, 5));
        this.overviewPanel.add((Component)overviewSouthPanel, "South");
        overviewSouthPanel.add(this.modifyButton);
        this.modifyButton.setVisible(false);
        overviewSouthPanel.add(this.deleteButton);
        this.deleteButton.setVisible(false);
        overviewSouthPanel.add(this.cancelButton);
        this.cancelButton.setVisible(false);
        overviewSouthPanel.add(new JLabel(""));
        overviewSouthPanel.add(new JLabel(""));
        overviewSouthPanel.add(new JLabel(""));
        overviewSouthPanel.add(new JLabel(""));
        overviewSouthPanel.add(this.closeButton);
    }

    private void initMainFrame() {
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setLayout(new BorderLayout());
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icon.png"));
            this.mainFrame.setIconImage(image);
        }
        catch (IOException e) {
            System.out.println("Can't find logo!");
            e.printStackTrace();
        }
        this.mainFrame.add((Component)this.upperPanel, "North");
        this.mainFrame.add((Component)this.overviewPanel, "Center");
        this.mainFrame.setSize(730, 500);
        this.mainFrame.setLocationRelativeTo(null);
    }

    public void setBorderLabel(String label) {
        this.overviewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5), BorderFactory.createTitledBorder(label)));
    }

    private class ComboBoxListener
    implements ItemListener {
        private ComboBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (!RecorderGui.this.itemEventTrigger) {
                    return;
                }
                RecorderGui.this.subOrderComboBox.removeAllItems();
                int index = RecorderGui.this.orderComboBox.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                MainOrderDto mainOrder = (MainOrderDto)RecorderGui.this.orderComboBox.getSelectedItem();
                List<SubOrderDto> subOrderList = RecorderGui.this.controller.getSubOrders(mainOrder, true);
                RecorderGui.this.subOrderComboBox.setModel(new DefaultComboBoxModel<SubOrderDto>(subOrderList.toArray(new SubOrderDto[0])));
                RecorderGui.this.catLabel.setText(mainOrder.getOrderCategory() == null ? "" : mainOrder.getOrderCategory());
            }
        }
    }

    private class EditOrderBoxListener
    implements CellEditorListener {
        private EditOrderBoxListener() {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            RecorderGui.this.overviewTable.getEditSubOrderBox().removeAllItems();
            MainOrderDto mainOrder = (MainOrderDto)RecorderGui.this.overviewTable.getEditOrderBox().getSelectedItem();
            List<SubOrderDto> subOrderList = RecorderGui.this.controller.getSubOrders(mainOrder, true);
            RecorderGui.this.overviewTable.getEditSubOrderBox().setModel(new DefaultComboBoxModel<SubOrderDto>(subOrderList.toArray(new SubOrderDto[0])));
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }
    }

    private class TableMouseAdapter
    extends MouseAdapter {
        private TableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            RecorderGui.this.overviewTable.removeMouseListener(RecorderGui.this.tableMouseListener);
            RecorderGui.this.overviewTable.removeNotSelectedLines();
            RecorderGui.this.overviewTable.removeColumnsForModification();
            RecorderGui.this.overviewTable.setColumnWidthForModification();
            RecorderGui.this.modifyButton.setVisible(true);
            RecorderGui.this.deleteButton.setVisible(true);
            RecorderGui.this.cancelButton.setVisible(true);
            RecorderGui.this.overviewTable.addTableOrderComboBox(RecorderGui.this.controller.getAllMainOrders(true), RecorderGui.this.editOrderBoxListener);
            RecorderGui.this.overviewTable.addTableSubOrderComboBox();
            EffortDto effort = this.getSelectedEffort();
            RecorderGui.this.overviewTable.getEditOrderBox().setSelectedItem(effort.getMainOrder());
            if (effort.getSubOrder() != null) {
                RecorderGui.this.overviewTable.getEditSubOrderBox().setSelectedItem(effort.getSubOrder());
            }
        }

        private EffortDto getSelectedEffort() {
            int effortId = Integer.valueOf(RecorderGui.this.overviewTable.getValueAt(0, 0).toString());
            return RecorderGui.this.controller.getEffortById(effortId);
        }
    }
}

