/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderFactory;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderService;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.hql.spi.NamedHqlQueryMemento;
import org.hibernate.query.internal.NamedObjectRepositoryImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class MetadataImpl
implements MetadataImplementor,
Serializable {
    private static final Pattern LISTENER_SEPARATION_PATTERN = Pattern.compile(" ,");
    private final UUID uuid;
    private final MetadataBuildingOptions metadataBuildingOptions;
    private final BootstrapContext bootstrapContext;
    private final Map<String, PersistentClass> entityBindingMap;
    private final List<Component> composites;
    private final Map<Class, MappedSuperclass> mappedSuperclassMap;
    private final Map<String, org.hibernate.mapping.Collection> collectionBindingMap;
    private final Map<String, TypeDefinition> typeDefinitionMap;
    private final Map<String, FilterDefinition> filterDefinitionMap;
    private final Map<String, FetchProfile> fetchProfileMap;
    private final Map<String, String> imports;
    private final Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap;
    private final Map<String, NamedHqlQueryDefinition> namedQueryMap;
    private final Map<String, NamedNativeQueryDefinition> namedNativeQueryMap;
    private final Map<String, NamedProcedureCallDefinition> namedProcedureCallMap;
    private final Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappingMap;
    private final Map<String, NamedEntityGraphDefinition> namedEntityGraphMap;
    private final Map<String, SqmFunctionDescriptor> sqlFunctionMap;
    private final Database database;

    public MetadataImpl(UUID uuid, MetadataBuildingOptions metadataBuildingOptions, Map<String, PersistentClass> entityBindingMap, List<Component> composites, Map<Class, MappedSuperclass> mappedSuperclassMap, Map<String, org.hibernate.mapping.Collection> collectionBindingMap, Map<String, TypeDefinition> typeDefinitionMap, Map<String, FilterDefinition> filterDefinitionMap, Map<String, FetchProfile> fetchProfileMap, Map<String, String> imports, Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap, Map<String, NamedHqlQueryDefinition> namedQueryMap, Map<String, NamedNativeQueryDefinition> namedNativeQueryMap, Map<String, NamedProcedureCallDefinition> namedProcedureCallMap, Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappingMap, Map<String, NamedEntityGraphDefinition> namedEntityGraphMap, Map<String, SqmFunctionDescriptor> sqlFunctionMap, Database database, BootstrapContext bootstrapContext) {
        this.uuid = uuid;
        this.metadataBuildingOptions = metadataBuildingOptions;
        this.entityBindingMap = entityBindingMap;
        this.composites = composites;
        this.mappedSuperclassMap = mappedSuperclassMap;
        this.collectionBindingMap = collectionBindingMap;
        this.typeDefinitionMap = typeDefinitionMap;
        this.filterDefinitionMap = filterDefinitionMap;
        this.fetchProfileMap = fetchProfileMap;
        this.imports = imports;
        this.idGeneratorDefinitionMap = idGeneratorDefinitionMap;
        this.namedQueryMap = namedQueryMap;
        this.namedNativeQueryMap = namedNativeQueryMap;
        this.namedProcedureCallMap = namedProcedureCallMap;
        this.sqlResultSetMappingMap = sqlResultSetMappingMap;
        this.namedEntityGraphMap = namedEntityGraphMap;
        this.sqlFunctionMap = sqlFunctionMap;
        this.database = database;
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.metadataBuildingOptions;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bootstrapContext.getTypeConfiguration();
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        SessionFactoryBuilderService factoryBuilderService = this.metadataBuildingOptions.getServiceRegistry().getService(SessionFactoryBuilderService.class);
        SessionFactoryBuilderImplementor defaultBuilder = factoryBuilderService.createSessionFactoryBuilder(this, this.bootstrapContext);
        ClassLoaderService cls = this.metadataBuildingOptions.getServiceRegistry().getService(ClassLoaderService.class);
        Collection<SessionFactoryBuilderFactory> discoveredBuilderFactories = cls.loadJavaServices(SessionFactoryBuilderFactory.class);
        SessionFactoryBuilder builder = null;
        ArrayList<String> activeFactoryNames = null;
        for (SessionFactoryBuilderFactory discoveredBuilderFactory : discoveredBuilderFactories) {
            SessionFactoryBuilder returnedBuilder = discoveredBuilderFactory.getSessionFactoryBuilder(this, defaultBuilder);
            if (returnedBuilder == null) continue;
            if (activeFactoryNames == null) {
                activeFactoryNames = new ArrayList<String>();
            }
            activeFactoryNames.add(discoveredBuilderFactory.getClass().getName());
            builder = returnedBuilder;
        }
        if (activeFactoryNames != null && activeFactoryNames.size() > 1) {
            throw new HibernateException("Multiple active SessionFactoryBuilderFactory definitions were discovered : " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)activeFactoryNames));
        }
        if (builder != null) {
            return builder;
        }
        return defaultBuilder;
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return this.getSessionFactoryBuilder().build();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Collection<PersistentClass> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public PersistentClass getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public org.hibernate.mapping.Collection getCollectionBinding(String role) {
        return this.collectionBindingMap.get(role);
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public NamedHqlQueryDefinition getNamedHqlQueryMapping(String name) {
        return this.namedQueryMap.get(name);
    }

    @Override
    public void visitNamedHqlQueryDefinitions(Consumer<NamedHqlQueryDefinition> definitionConsumer) {
        this.namedQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedNativeQueryDefinition getNamedNativeQueryMapping(String name) {
        return this.namedNativeQueryMap.get(name);
    }

    @Override
    public void visitNamedNativeQueryDefinitions(Consumer<NamedNativeQueryDefinition> definitionConsumer) {
        this.namedNativeQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedProcedureCallDefinition getNamedProcedureCallMapping(String name) {
        return this.namedProcedureCallMap.get(name);
    }

    @Override
    public void visitNamedProcedureCallDefinition(Consumer<NamedProcedureCallDefinition> definitionConsumer) {
        this.namedProcedureCallMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedResultSetMappingDescriptor getResultSetMapping(String name) {
        return this.sqlResultSetMappingMap.get(name);
    }

    @Override
    public void visitNamedResultSetMappingDefinition(Consumer<NamedResultSetMappingDescriptor> definitionConsumer) {
        this.sqlResultSetMappingMap.values().forEach(definitionConsumer);
    }

    @Override
    public TypeDefinition getTypeDefinition(String typeName) {
        return this.typeDefinitionMap.get(typeName);
    }

    @Override
    public Map<String, FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitionMap;
    }

    @Override
    public FilterDefinition getFilterDefinition(String name) {
        return this.filterDefinitionMap.get(name);
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfileMap.get(name);
    }

    @Override
    public Collection<FetchProfile> getFetchProfiles() {
        return this.fetchProfileMap.values();
    }

    @Override
    public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
        return this.namedEntityGraphMap.get(name);
    }

    @Override
    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap;
    }

    @Override
    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        return this.idGeneratorDefinitionMap.get(name);
    }

    @Override
    public Map<String, SqmFunctionDescriptor> getSqlFunctionMap() {
        return this.sqlFunctionMap;
    }

    @Override
    public Set<String> getContributors() {
        HashSet<String> contributors = new HashSet<String>();
        this.entityBindingMap.forEach((s, persistentClass) -> contributors.add(persistentClass.getContributor()));
        for (Namespace namespace : this.database.getNamespaces()) {
            for (Table table : namespace.getTables()) {
                contributors.add(table.getContributor());
            }
            for (Sequence sequence : namespace.getSequences()) {
                contributors.add(sequence.getContributor());
            }
        }
        return contributors;
    }

    @Override
    public Collection<Table> collectTableMappings() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Namespace namespace : this.database.getNamespaces()) {
            tables.addAll(namespace.getTables());
        }
        return tables;
    }

    @Override
    public NamedObjectRepository buildNamedQueryRepository(SessionFactoryImplementor sessionFactory) {
        return new NamedObjectRepositoryImpl(CollectionHelper.mapOfSize(this.namedQueryMap.size()), CollectionHelper.mapOfSize(this.namedNativeQueryMap.size()), CollectionHelper.mapOfSize(this.namedProcedureCallMap.size()), CollectionHelper.mapOfSize(this.sqlResultSetMappingMap.size()));
    }

    private Map<String, NamedHqlQueryMemento> buildNamedHqlMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedHqlQueryMemento> map = new HashMap<String, NamedHqlQueryMemento>();
        if (this.namedQueryMap != null) {
            this.namedQueryMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    private Map<String, NamedNativeQueryMemento> buildNamedNativeMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedNativeQueryMemento> map = new HashMap<String, NamedNativeQueryMemento>();
        if (this.namedNativeQueryMap != null) {
            this.namedNativeQueryMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    private Map<String, NamedCallableQueryMemento> buildProcedureCallMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedCallableQueryMemento> map = new HashMap<String, NamedCallableQueryMemento>();
        if (this.namedProcedureCallMap != null) {
            this.namedProcedureCallMap.forEach((key, value) -> map.put((String)key, value.resolve(sessionFactory)));
        }
        return map;
    }

    @Override
    public void validate() throws MappingException {
        for (PersistentClass entityBinding : this.getEntityBindings()) {
            entityBinding.validate(this);
        }
        for (org.hibernate.mapping.Collection collectionBinding : this.getCollectionBindings()) {
            collectionBinding.validate(this);
        }
    }

    @Override
    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return this.mappedSuperclassMap == null ? Collections.emptySet() : new HashSet<MappedSuperclass>(this.mappedSuperclassMap.values());
    }

    @Override
    public void initSessionFactory(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor sessionFactoryServiceRegistry = sessionFactory.getServiceRegistry();
        assert (sessionFactoryServiceRegistry != null);
        EventListenerRegistry eventListenerRegistry = sessionFactoryServiceRegistry.getService(EventListenerRegistry.class);
        ConfigurationService cfgService = sessionFactoryServiceRegistry.getService(ConfigurationService.class);
        ClassLoaderService classLoaderService = sessionFactoryServiceRegistry.getService(ClassLoaderService.class);
        for (Map.Entry<String, Object> entry : cfgService.getSettings().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = entry.getKey()).startsWith("hibernate.event.listener")) continue;
            String eventTypeName = propertyName.substring("hibernate.event.listener".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName(eventTypeName);
            EventListenerGroup<Object> eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : LISTENER_SEPARATION_PATTERN.split((String)entry.getValue())) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, classLoaderService));
            }
        }
    }

    private Object instantiate(String listenerImpl, ClassLoaderService classLoaderService) {
        try {
            return classLoaderService.classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate requested listener [" + listenerImpl + "]", e);
        }
    }

    @Override
    public void visitRegisteredComponents(Consumer<Component> consumer) {
        this.composites.forEach(consumer);
    }

    @Override
    public Type getIdentifierType(String entityName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("persistent class not known: " + entityName);
        }
        return pc.getIdentifier().getType();
    }

    @Override
    public String getIdentifierPropertyName(String entityName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("persistent class not known: " + entityName);
        }
        if (!pc.hasIdentifierProperty()) {
            return null;
        }
        return pc.getIdentifierProperty().getName();
    }

    @Override
    public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("persistent class not known: " + entityName);
        }
        Property prop = pc.getReferencedProperty(propertyName);
        if (prop == null) {
            throw new MappingException("property not known: " + entityName + "." + propertyName);
        }
        return prop.getType();
    }

    public Map<String, PersistentClass> getEntityBindingMap() {
        return this.entityBindingMap;
    }

    public Map<String, org.hibernate.mapping.Collection> getCollectionBindingMap() {
        return this.collectionBindingMap;
    }

    public Map<String, TypeDefinition> getTypeDefinitionMap() {
        return this.typeDefinitionMap;
    }

    public Map<String, FetchProfile> getFetchProfileMap() {
        return this.fetchProfileMap;
    }

    public Map<Class, MappedSuperclass> getMappedSuperclassMap() {
        return this.mappedSuperclassMap;
    }

    public Map<String, IdentifierGeneratorDefinition> getIdGeneratorDefinitionMap() {
        return this.idGeneratorDefinitionMap;
    }

    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphMap() {
        return this.namedEntityGraphMap;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }
}

