/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.SharedCacheMode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.internal.InstanceBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.XmlMappingBinderAccess;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.UserType;

public class Configuration {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Configuration.class);
    public static final String ARTEFACT_PROCESSING_ORDER = "hibernate.mapping.precedence";
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private final MetadataSources metadataSources;
    private final ClassmateContext classmateContext;
    private ImplicitNamingStrategy implicitNamingStrategy;
    private PhysicalNamingStrategy physicalNamingStrategy;
    private List<BasicType> basicTypes = new ArrayList<BasicType>();
    private List<UserTypeRegistration> userTypeRegistrations;
    private List<TypeContributor> typeContributorRegistrations = new ArrayList<TypeContributor>();
    private Map<String, NamedHqlQueryDefinition> namedQueries;
    private Map<String, NamedNativeQueryDefinition> namedSqlQueries;
    private Map<String, NamedProcedureCallDefinition> namedProcedureCallMap;
    private Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappings;
    private Map<String, NamedEntityGraphDefinition> namedEntityGraphMap;
    private Map<String, SqmFunctionDescriptor> customFunctionDescriptors;
    private List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjectList;
    private HashMap<Class, ConverterDescriptor> attributeConverterDescriptorsByClass;
    private StandardServiceRegistryBuilder standardServiceRegistryBuilder;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    private Interceptor interceptor;
    private SessionFactoryObserver sessionFactoryObserver;
    private CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private Properties properties;
    private SharedCacheMode sharedCacheMode;

    public Configuration() {
        this(new BootstrapServiceRegistryBuilder().build());
    }

    public Configuration(BootstrapServiceRegistry serviceRegistry) {
        this.bootstrapServiceRegistry = serviceRegistry;
        this.metadataSources = new MetadataSources(serviceRegistry);
        this.classmateContext = new ClassmateContext();
        this.reset();
    }

    public Configuration(MetadataSources metadataSources) {
        this.bootstrapServiceRegistry = Configuration.getBootstrapRegistry(metadataSources.getServiceRegistry());
        this.metadataSources = metadataSources;
        this.classmateContext = new ClassmateContext();
        this.reset();
    }

    private static BootstrapServiceRegistry getBootstrapRegistry(ServiceRegistry serviceRegistry) {
        if (serviceRegistry instanceof BootstrapServiceRegistry) {
            return (BootstrapServiceRegistry)serviceRegistry;
        }
        if (serviceRegistry instanceof StandardServiceRegistry) {
            StandardServiceRegistry ssr = (StandardServiceRegistry)serviceRegistry;
            return (BootstrapServiceRegistry)ssr.getParentServiceRegistry();
        }
        throw new HibernateException("No ServiceRegistry was passed to Configuration#buildSessionFactory and could not determine how to locate BootstrapServiceRegistry from Configuration instantiation");
    }

    protected void reset() {
        this.implicitNamingStrategy = ImplicitNamingStrategyJpaCompliantImpl.INSTANCE;
        this.physicalNamingStrategy = PhysicalNamingStrategyStandardImpl.INSTANCE;
        this.namedQueries = new HashMap<String, NamedHqlQueryDefinition>();
        this.namedSqlQueries = new HashMap<String, NamedNativeQueryDefinition>();
        this.sqlResultSetMappings = new HashMap<String, NamedResultSetMappingDescriptor>();
        this.namedEntityGraphMap = new HashMap<String, NamedEntityGraphDefinition>();
        this.namedProcedureCallMap = new HashMap<String, NamedProcedureCallDefinition>();
        this.standardServiceRegistryBuilder = new StandardServiceRegistryBuilder(this.bootstrapServiceRegistry);
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = new Properties();
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getProperty(String propertyName) {
        Object o = this.properties.get(propertyName);
        return o instanceof String ? (String)o : null;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public Configuration addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public void setImplicitNamingStrategy(ImplicitNamingStrategy implicitNamingStrategy) {
        this.implicitNamingStrategy = implicitNamingStrategy;
    }

    public void setPhysicalNamingStrategy(PhysicalNamingStrategy physicalNamingStrategy) {
        this.physicalNamingStrategy = physicalNamingStrategy;
    }

    public Configuration configure() throws HibernateException {
        return this.configure("hibernate.cfg.xml");
    }

    public Configuration configure(String resource) throws HibernateException {
        this.standardServiceRegistryBuilder.configure(resource);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
        return this;
    }

    public StandardServiceRegistryBuilder getStandardServiceRegistryBuilder() {
        return this.standardServiceRegistryBuilder;
    }

    public Configuration configure(URL url) throws HibernateException {
        this.standardServiceRegistryBuilder.configure(url);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
        return this;
    }

    public Configuration configure(File configFile) throws HibernateException {
        this.standardServiceRegistryBuilder.configure(configFile);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
        return this;
    }

    public Configuration registerTypeContributor(TypeContributor typeContributor) {
        this.typeContributorRegistrations.add(typeContributor);
        return this;
    }

    public Configuration registerTypeOverride(BasicType<?> type) {
        this.basicTypes.add(type);
        return this;
    }

    public Configuration registerTypeOverride(UserType type, String[] keys) {
        if (this.userTypeRegistrations == null) {
            this.userTypeRegistrations = new ArrayList<UserTypeRegistration>();
        }
        this.userTypeRegistrations.add(metadataBuilder -> metadataBuilder.applyBasicType(type, keys));
        return this;
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        this.metadataSources.addFile(xmlFile);
        return this;
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        this.metadataSources.addFile(xmlFile);
        return this;
    }

    public XmlMappingBinderAccess getXmlMappingBinderAccess() {
        return this.metadataSources.getXmlMappingBinderAccess();
    }

    public Configuration addXmlMapping(Binding<?> binding) {
        this.metadataSources.addXmlBinding(binding);
        return this;
    }

    public Configuration addCacheableFile(File xmlFile) throws MappingException {
        this.metadataSources.addCacheableFile(xmlFile);
        return this;
    }

    public Configuration addCacheableFileStrictly(File xmlFile) throws SerializationException, FileNotFoundException {
        this.metadataSources.addCacheableFileStrictly(xmlFile);
        return this;
    }

    public Configuration addCacheableFile(String xmlFile) throws MappingException {
        this.metadataSources.addCacheableFile(xmlFile);
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        this.metadataSources.addURL(url);
        return this;
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        this.metadataSources.addInputStream(xmlInputStream);
        return this;
    }

    public Configuration addResource(String resourceName) throws MappingException {
        this.metadataSources.addResource(resourceName);
        return this;
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        this.metadataSources.addClass(persistentClass);
        return this;
    }

    public Configuration addAnnotatedClass(Class annotatedClass) {
        this.metadataSources.addAnnotatedClass(annotatedClass);
        return this;
    }

    public Configuration addPackage(String packageName) throws MappingException {
        this.metadataSources.addPackage(packageName);
        return this;
    }

    public Configuration addJar(File jar) throws MappingException {
        this.metadataSources.addJar(jar);
        return this;
    }

    public Configuration addDirectory(File dir) throws MappingException {
        this.metadataSources.addDirectory(dir);
        return this;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public void setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    public void setCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
        this.currentTenantIdentifierResolver = currentTenantIdentifierResolver;
    }

    public SessionFactory buildSessionFactory(ServiceRegistry serviceRegistry) throws HibernateException {
        log.debug("Building session factory using provided StandardServiceRegistry");
        MetadataBuilder metadataBuilder = this.metadataSources.getMetadataBuilder((StandardServiceRegistry)serviceRegistry);
        if (this.implicitNamingStrategy != null) {
            metadataBuilder.applyImplicitNamingStrategy(this.implicitNamingStrategy);
        }
        if (this.physicalNamingStrategy != null) {
            metadataBuilder.applyPhysicalNamingStrategy(this.physicalNamingStrategy);
        }
        if (this.sharedCacheMode != null) {
            metadataBuilder.applySharedCacheMode(this.sharedCacheMode);
        }
        if (!this.typeContributorRegistrations.isEmpty()) {
            for (TypeContributor typeContributor : this.typeContributorRegistrations) {
                metadataBuilder.applyTypes(typeContributor);
            }
        }
        if (this.userTypeRegistrations != null) {
            this.userTypeRegistrations.forEach(registration -> registration.registerType(metadataBuilder));
        }
        if (!this.basicTypes.isEmpty()) {
            for (BasicType basicType : this.basicTypes) {
                metadataBuilder.applyBasicType(basicType);
            }
        }
        if (this.customFunctionDescriptors != null) {
            for (Map.Entry entry : this.customFunctionDescriptors.entrySet()) {
                metadataBuilder.applySqlFunction((String)entry.getKey(), (SqmFunctionDescriptor)entry.getValue());
            }
        }
        if (this.auxiliaryDatabaseObjectList != null) {
            for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjectList) {
                metadataBuilder.applyAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
            }
        }
        if (this.attributeConverterDescriptorsByClass != null) {
            this.attributeConverterDescriptorsByClass.values().forEach(metadataBuilder::applyAttributeConverter);
        }
        Metadata metadata = metadataBuilder.build();
        SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        if (this.interceptor != null && this.interceptor != EmptyInterceptor.INSTANCE) {
            sessionFactoryBuilder.applyInterceptor(this.interceptor);
        }
        if (this.getSessionFactoryObserver() != null) {
            sessionFactoryBuilder.addSessionFactoryObservers(this.getSessionFactoryObserver());
        }
        if (this.getEntityNotFoundDelegate() != null) {
            sessionFactoryBuilder.applyEntityNotFoundDelegate(this.getEntityNotFoundDelegate());
        }
        if (this.getCurrentTenantIdentifierResolver() != null) {
            sessionFactoryBuilder.applyCurrentTenantIdentifierResolver(this.getCurrentTenantIdentifierResolver());
        }
        return sessionFactoryBuilder.build();
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug("Building session factory using internal StandardServiceRegistryBuilder");
        this.standardServiceRegistryBuilder.applySettings(this.properties);
        StandardServiceRegistry serviceRegistry = this.standardServiceRegistryBuilder.build();
        try {
            return this.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable t) {
            serviceRegistry.close();
            throw t;
        }
    }

    public Map<String, SqmFunctionDescriptor> getSqlFunctions() {
        return this.customFunctionDescriptors;
    }

    public void addSqlFunction(String functionName, SqmFunctionDescriptor function) {
        if (this.customFunctionDescriptors == null) {
            this.customFunctionDescriptors = new HashMap<String, SqmFunctionDescriptor>();
        }
        this.customFunctionDescriptors.put(functionName, function);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        if (this.auxiliaryDatabaseObjectList == null) {
            this.auxiliaryDatabaseObjectList = new ArrayList<AuxiliaryDatabaseObject>();
        }
        this.auxiliaryDatabaseObjectList.add(object);
    }

    public void addAttributeConverter(Class<? extends AttributeConverter> attributeConverterClass, boolean autoApply) {
        this.addAttributeConverter(new ClassBasedConverterDescriptor(attributeConverterClass, autoApply, this.classmateContext));
    }

    public void addAttributeConverter(Class<? extends AttributeConverter<?, ?>> attributeConverterClass) {
        this.addAttributeConverter(new ClassBasedConverterDescriptor(attributeConverterClass, this.classmateContext));
    }

    public void addAttributeConverter(AttributeConverter<?, ?> attributeConverter) {
        this.addAttributeConverter(new InstanceBasedConverterDescriptor(attributeConverter, this.classmateContext));
    }

    public void addAttributeConverter(AttributeConverter<?, ?> attributeConverter, boolean autoApply) {
        this.addAttributeConverter(new InstanceBasedConverterDescriptor(attributeConverter, (Boolean)autoApply, this.classmateContext));
    }

    public void addAttributeConverter(ConverterDescriptor converterDescriptor) {
        if (this.attributeConverterDescriptorsByClass == null) {
            this.attributeConverterDescriptorsByClass = new HashMap();
        }
        this.attributeConverterDescriptorsByClass.put(converterDescriptor.getAttributeConverterClass(), converterDescriptor);
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public Collection<NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap == null ? Collections.emptyList() : this.namedEntityGraphMap.values();
    }

    public Map<String, NamedHqlQueryDefinition> getNamedQueries() {
        return this.namedQueries;
    }

    public Map<String, NamedProcedureCallDefinition> getNamedProcedureCallMap() {
        return this.namedProcedureCallMap;
    }

    public Configuration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private static interface UserTypeRegistration {
        public void registerType(MetadataBuilder var1);
    }
}

