/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.Column;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.IdGeneratorResolverSecondPass;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.WrappedInferredData;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.BasicValueBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.UserCollectionType;

public class IdBagBinder
extends BagBinder {
    public IdBagBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, buildingContext);
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new IdentifierBag(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    protected boolean bindStarToManySecondPass(Map persistentClasses, XClass collType, AnnotatedJoinColumn[] fkJoinColumns, AnnotatedJoinColumn[] keyColumns, AnnotatedJoinColumn[] inverseColumns, AnnotatedColumn[] elementColumns, boolean isEmbedded, XProperty property, boolean unique, TableBinder associationTableBinder, boolean ignoreNotFound, MetadataBuildingContext buildingContext) {
        String generatorName;
        String generatorType;
        AnnotatedColumn[] idColumns;
        boolean result = super.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, associationTableBinder, ignoreNotFound, this.getBuildingContext());
        CollectionId collectionIdAnn = property.getAnnotation(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing @CollectionId");
        }
        WrappedInferredData propertyData = new WrappedInferredData(new PropertyInferredData(null, property, null, buildingContext.getBootstrapContext().getReflectionManager()), "id");
        for (AnnotatedColumn idColumn : idColumns = AnnotatedColumn.buildColumnFromAnnotation(new Column[]{collectionIdAnn.column()}, null, null, Nullability.FORCED_NOT_NULL, this.propertyHolder, propertyData, Collections.emptyMap(), buildingContext)) {
            idColumn.setNullable(false);
        }
        BasicValueBinder valueBinder = new BasicValueBinder(BasicValueBinder.Kind.COLLECTION_ID, buildingContext);
        Table table = this.collection.getCollectionTable();
        valueBinder.setTable(table);
        valueBinder.setColumns(idColumns);
        valueBinder.setType(property, collType, null, null);
        BasicValue id = valueBinder.make();
        ((IdentifierCollection)this.collection).setIdentifier(id);
        String namedGenerator = collectionIdAnn.generator();
        if ("identity".equals(namedGenerator)) {
            throw new MappingException("IDENTITY generation not supported for CollectionId");
        }
        if ("assigned".equals(namedGenerator)) {
            throw new MappingException("Assigned generation not supported for CollectionId");
        }
        if ("native".equals(namedGenerator)) {
            throw new MappingException("Native generation not supported for CollectionId");
        }
        if ("sequence".equals(namedGenerator)) {
            generatorType = namedGenerator;
            generatorName = "";
        } else if ("increment".equals(namedGenerator)) {
            generatorType = namedGenerator;
            generatorName = "";
        } else {
            generatorType = namedGenerator;
            generatorName = namedGenerator;
        }
        id.setIdentifierGeneratorStrategy(generatorType);
        if (buildingContext.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            IdGeneratorResolverSecondPass secondPass = new IdGeneratorResolverSecondPass(id, property, generatorType, generatorName, this.getBuildingContext());
            buildingContext.getMetadataCollector().addSecondPass(secondPass);
        } else {
            BinderHelper.makeIdGenerator((SimpleValue)id, property, generatorType, generatorName, this.getBuildingContext(), this.localGenerators);
        }
        return result;
    }
}

