/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.CollectionPropertyHolder;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.BasicValueBinder;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.List;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.UserCollectionType;
import org.jboss.logging.Logger;

public class ListBinder
extends CollectionBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ListBinder.class.getName());

    public ListBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, false, buildingContext);
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new List(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    @Override
    public void setSqlOrderBy(OrderBy orderByAnn) {
        if (orderByAnn != null) {
            LOG.orderByAnnotationIndexedCollection();
        }
    }

    @Override
    public SecondPass getSecondPass(final AnnotatedJoinColumn[] fkJoinColumns, final AnnotatedJoinColumn[] keyColumns, final AnnotatedJoinColumn[] inverseColumns, final AnnotatedColumn[] elementColumns, AnnotatedColumn[] mapKeyColumns, AnnotatedJoinColumn[] mapKeyManyToManyColumns, final boolean isEmbedded, final XProperty property, final XClass collType, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final MetadataBuildingContext buildingContext) {
        return new CollectionSecondPass(this.getBuildingContext(), this.collection){

            @Override
            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                ListBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, assocTableBinder, ignoreNotFound, buildingContext);
                ListBinder.this.bindIndex(property, collType, buildingContext);
            }
        };
    }

    private void bindIndex(XProperty property, XClass collType, MetadataBuildingContext buildingContext) {
        CollectionPropertyHolder valueHolder = PropertyHolderBuilder.buildPropertyHolder(this.collection, StringHelper.qualify(this.collection.getRole(), "key"), null, null, this.propertyHolder, this.getBuildingContext());
        List listValueMapping = (List)this.collection;
        if (this.indexColumn.isImplicit()) {
            // empty if block
        }
        if (!listValueMapping.isOneToMany()) {
            this.indexColumn.forceNotNull();
        }
        this.indexColumn.setPropertyHolder(valueHolder);
        BasicValueBinder valueBinder = new BasicValueBinder(BasicValueBinder.Kind.LIST_INDEX, buildingContext);
        valueBinder.setColumns(new AnnotatedColumn[]{this.indexColumn});
        valueBinder.setReturnedClassName(Integer.class.getName());
        valueBinder.setType(property, collType, null, null);
        BasicValue indexValue = valueBinder.make();
        this.indexColumn.linkWithValue(indexValue);
        listValueMapping.setIndex(indexValue);
        listValueMapping.setBaseIndex(this.indexColumn.getBase());
        if (listValueMapping.isOneToMany() && !listValueMapping.getKey().isNullable() && !listValueMapping.isInverse()) {
            String entityName = ((OneToMany)listValueMapping.getElement()).getReferencedEntityName();
            PersistentClass referenced = buildingContext.getMetadataCollector().getEntityBinding(entityName);
            IndexBackref ib = new IndexBackref();
            ib.setName("_" + this.propertyName + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            ib.setCollectionRole(listValueMapping.getRole());
            ib.setEntityName(listValueMapping.getOwner().getEntityName());
            ib.setValue(listValueMapping.getIndex());
            referenced.addProperty(ib);
        }
    }
}

