/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.MapKeyJoinColumns;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionPropertyHolder;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.BasicValueBinder;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantBasicValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.UserCollectionType;

public class MapBinder
extends CollectionBinder {
    public MapBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, boolean sorted, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, sorted, buildingContext);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new Map(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    @Override
    public SecondPass getSecondPass(final AnnotatedJoinColumn[] fkJoinColumns, final AnnotatedJoinColumn[] keyColumns, final AnnotatedJoinColumn[] inverseColumns, final AnnotatedColumn[] elementColumns, final AnnotatedColumn[] mapKeyColumns, final AnnotatedJoinColumn[] mapKeyManyToManyColumns, final boolean isEmbedded, final XProperty property, final XClass collType, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final MetadataBuildingContext buildingContext) {
        return new CollectionSecondPass(buildingContext, this.collection){

            @Override
            public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
                MapBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, assocTableBinder, ignoreNotFound, buildingContext);
                MapBinder.this.bindKeyFromAssociationTable(collType, persistentClasses, MapBinder.this.mapKeyPropertyName, property, isEmbedded, buildingContext, mapKeyColumns, mapKeyManyToManyColumns, inverseColumns != null ? inverseColumns[0].getPropertyName() : null);
                MapBinder.this.makeOneToManyMapKeyColumnNullableIfNotInProperty(property);
            }
        };
    }

    private void makeOneToManyMapKeyColumnNullableIfNotInProperty(XProperty property) {
        Map map = (Map)this.collection;
        if (map.isOneToMany() && property.isAnnotationPresent(MapKeyColumn.class)) {
            PersistentClass persistentClass;
            Value indexValue = map.getIndex();
            if (indexValue.getColumnSpan() != 1) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn does not have 1 column");
            }
            Selectable selectable = indexValue.getSelectables().get(0);
            if (selectable.isFormula()) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn is a Formula");
            }
            Column column = (Column)selectable;
            if (!column.isNullable() && !this.propertiesContainColumn((persistentClass = ((OneToMany)map.getElement()).getAssociatedClass()).getUnjoinedProperties(), column)) {
                column.setNullable(true);
            }
        }
    }

    private boolean propertiesContainColumn(List<Property> properties, Column column) {
        for (Property property : properties) {
            for (Selectable selectable : property.getSelectables()) {
                if (!column.equals(selectable)) continue;
                Column iteratedColumn = (Column)selectable;
                if (!column.getValue().getTable().equals(iteratedColumn.getValue().getTable())) continue;
                return true;
            }
        }
        return false;
    }

    private void bindKeyFromAssociationTable(XClass collType, java.util.Map persistentClasses, String mapKeyPropertyName, XProperty property, boolean isEmbedded, MetadataBuildingContext buildingContext, AnnotatedColumn[] mapKeyColumns, AnnotatedJoinColumn[] mapKeyManyToManyColumns, String targetPropertyName) {
        if (mapKeyPropertyName != null) {
            PersistentClass associatedClass = (PersistentClass)persistentClasses.get(collType.getName());
            if (associatedClass == null) {
                throw new AnnotationException("Associated class not found: " + collType);
            }
            Property mapProperty = BinderHelper.findPropertyByName(associatedClass, mapKeyPropertyName);
            if (mapProperty == null) {
                throw new AnnotationException("Map key property not found: " + collType + "." + mapKeyPropertyName);
            }
            Map map = (Map)this.collection;
            InheritanceState inheritanceState = (InheritanceState)this.inheritanceStatePerClass.get(collType);
            PersistentClass targetPropertyPersistentClass = InheritanceType.JOINED.equals((Object)inheritanceState.getType()) ? mapProperty.getPersistentClass() : associatedClass;
            Value indexValue = this.createFormulatedValue(mapProperty.getValue(), map, targetPropertyName, associatedClass, targetPropertyPersistentClass, buildingContext);
            map.setIndex(indexValue);
            map.setMapKeyPropertyName(mapKeyPropertyName);
        } else {
            ForeignKey foreignKey;
            Class target = Void.TYPE;
            if (property.isAnnotationPresent(MapKeyClass.class)) {
                target = property.getAnnotation(MapKeyClass.class).value();
            }
            String mapKeyType = !Void.TYPE.equals(target) ? target.getName() : property.getMapKey().getName();
            PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(mapKeyType);
            boolean isIndexOfEntities = collectionEntity != null;
            ManyToOne element = null;
            Map mapValue = (Map)this.collection;
            if (isIndexOfEntities) {
                element = new ManyToOne(buildingContext, mapValue.getCollectionTable());
                mapValue.setIndex(element);
                element.setReferencedEntityName(mapKeyType);
                element.setFetchMode(FetchMode.JOIN);
                element.setLazy(false);
            } else {
                AccessType accessType;
                AnnotatedJoinColumn[] keyXClass;
                AnnotatedClassType classType;
                if (BinderHelper.PRIMITIVE_NAMES.contains(mapKeyType)) {
                    classType = AnnotatedClassType.NONE;
                    keyXClass = null;
                } else {
                    BootstrapContext bootstrapContext = buildingContext.getBootstrapContext();
                    Class mapKeyClass = bootstrapContext.getClassLoaderAccess().classForName(mapKeyType);
                    keyXClass = bootstrapContext.getReflectionManager().toXClass(mapKeyClass);
                    classType = buildingContext.getMetadataCollector().getClassType((XClass)keyXClass);
                    if (isEmbedded || this.mappingDefinedAttributeOverrideOnMapKey(property)) {
                        classType = AnnotatedClassType.EMBEDDABLE;
                    }
                }
                CollectionPropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(mapValue, StringHelper.qualify(mapValue.getRole(), "mapkey"), (XClass)keyXClass, property, this.propertyHolder, buildingContext);
                this.propertyHolder.startingProperty(property);
                holder.prepare(property);
                PersistentClass owner = mapValue.getOwner();
                if (owner.getIdentifierProperty() != null) {
                    accessType = owner.getIdentifierProperty().getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
                } else if (owner.getIdentifierMapper() != null && owner.getIdentifierMapper().getPropertySpan() > 0) {
                    Property prop = owner.getIdentifierMapper().getProperties().get(0);
                    accessType = prop.getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
                } else {
                    throw new AssertionFailure("Unable to guess collection property accessor name");
                }
                if (AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
                    EntityBinder entityBinder = new EntityBinder();
                    PropertyPreloadedData inferredData = this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "index", (XClass)keyXClass) : new PropertyPreloadedData(AccessType.PROPERTY, "key", (XClass)keyXClass);
                    Component component = AnnotationBinder.fillComponent(holder, inferredData, accessType, true, entityBinder, false, false, true, null, buildingContext, this.inheritanceStatePerClass);
                    mapValue.setIndex(component);
                } else {
                    BasicValueBinder elementBinder = new BasicValueBinder(BasicValueBinder.Kind.MAP_KEY, buildingContext);
                    elementBinder.setReturnedClassName(mapKeyType);
                    AnnotatedColumn[] elementColumns = mapKeyColumns;
                    if (elementColumns == null || elementColumns.length == 0) {
                        elementColumns = new AnnotatedColumn[1];
                        AnnotatedColumn column = new AnnotatedColumn();
                        column.setImplicit(false);
                        column.setNullable(true);
                        column.setLength(255L);
                        column.setLogicalColumnName("id");
                        column.setJoins(new HashMap<String, Join>());
                        column.setBuildingContext(buildingContext);
                        column.bind();
                        elementColumns[0] = column;
                    }
                    for (AnnotatedColumn column : elementColumns) {
                        column.setTable(mapValue.getCollectionTable());
                    }
                    elementBinder.setColumns(elementColumns);
                    elementBinder.setType(property, (XClass)keyXClass, this.collection.getOwnerEntityName(), holder.mapKeyAttributeConverterDescriptor(property, (XClass)keyXClass));
                    elementBinder.setPersistentClassName(this.propertyHolder.getEntityName());
                    elementBinder.setAccessType(accessType);
                    mapValue.setIndex(elementBinder.make());
                }
            }
            if (!this.collection.isOneToMany()) {
                for (AnnotatedJoinColumn col : mapKeyManyToManyColumns) {
                    col.forceNotNull();
                }
            }
            if (element != null && (foreignKey = this.getMapKeyForeignKey(property)) != null) {
                if (foreignKey.value() == ConstraintMode.NO_CONSTRAINT || foreignKey.value() == ConstraintMode.PROVIDER_DEFAULT && this.getBuildingContext().getBuildingOptions().isNoConstraintByDefault()) {
                    element.setForeignKeyName("none");
                } else {
                    element.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                    element.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                }
            }
            if (isIndexOfEntities) {
                MapBinder.bindManytoManyInverseFk(collectionEntity, mapKeyManyToManyColumns, element, false, buildingContext);
            }
        }
    }

    private ForeignKey getMapKeyForeignKey(XProperty property) {
        MapKeyJoinColumns mapKeyJoinColumns = property.getAnnotation(MapKeyJoinColumns.class);
        if (mapKeyJoinColumns != null) {
            return mapKeyJoinColumns.foreignKey();
        }
        MapKeyJoinColumn mapKeyJoinColumn = property.getAnnotation(MapKeyJoinColumn.class);
        if (mapKeyJoinColumn != null) {
            return mapKeyJoinColumn.foreignKey();
        }
        return null;
    }

    private boolean mappingDefinedAttributeOverrideOnMapKey(XProperty property) {
        if (property.isAnnotationPresent(AttributeOverride.class)) {
            return this.namedMapKey(property.getAnnotation(AttributeOverride.class));
        }
        if (property.isAnnotationPresent(AttributeOverrides.class)) {
            AttributeOverrides annotations = property.getAnnotation(AttributeOverrides.class);
            for (AttributeOverride attributeOverride : annotations.value()) {
                if (!this.namedMapKey(attributeOverride)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean namedMapKey(AttributeOverride annotation) {
        return annotation.name().startsWith("key.");
    }

    protected Value createFormulatedValue(Value value, Collection collection, String targetPropertyName, PersistentClass associatedClass, PersistentClass targetPropertyPersistentClass, MetadataBuildingContext buildingContext) {
        Table mapKeyTable = !associatedClass.equals(targetPropertyPersistentClass) ? targetPropertyPersistentClass.getTable() : associatedClass.getTable();
        if (value instanceof Component) {
            Component component = (Component)value;
            Component indexComponent = new Component(this.getBuildingContext(), collection);
            indexComponent.setComponentClassName(component.getComponentClassName());
            for (Property current : component.getProperties()) {
                Property newProperty = new Property();
                newProperty.setCascade(current.getCascade());
                newProperty.setValueGenerationStrategy(current.getValueGenerationStrategy());
                newProperty.setInsertable(false);
                newProperty.setUpdateable(false);
                newProperty.setMetaAttributes(current.getMetaAttributes());
                newProperty.setName(current.getName());
                newProperty.setNaturalIdentifier(false);
                newProperty.setOptional(false);
                newProperty.setPersistentClass(current.getPersistentClass());
                newProperty.setPropertyAccessorName(current.getPropertyAccessorName());
                newProperty.setSelectable(current.isSelectable());
                newProperty.setValue(this.createFormulatedValue(current.getValue(), collection, targetPropertyName, associatedClass, associatedClass, buildingContext));
                indexComponent.addProperty(newProperty);
            }
            return indexComponent;
        }
        if (value instanceof BasicValue) {
            BasicValue sourceValue = (BasicValue)value;
            DependantBasicValue dependantBasicValue = new DependantBasicValue(this.getBuildingContext(), mapKeyTable, sourceValue, false, false);
            Selectable sourceValueColumn = sourceValue.getColumn();
            if (sourceValueColumn instanceof Column) {
                dependantBasicValue.addColumn(((Column)sourceValueColumn).clone());
            } else if (sourceValueColumn instanceof Formula) {
                dependantBasicValue.addFormula(new Formula(((Formula)sourceValueColumn).getFormula()));
            } else {
                throw new AssertionFailure("Unknown element column type : " + sourceValueColumn.getClass());
            }
            return dependantBasicValue;
        }
        if (value instanceof SimpleValue) {
            SimpleValue targetValue;
            SimpleValue sourceValue = (SimpleValue)value;
            if (value instanceof ManyToOne) {
                ManyToOne sourceManyToOne = (ManyToOne)sourceValue;
                ManyToOne targetManyToOne = new ManyToOne(this.getBuildingContext(), mapKeyTable);
                targetManyToOne.setFetchMode(FetchMode.DEFAULT);
                targetManyToOne.setLazy(true);
                targetManyToOne.setReferencedEntityName(sourceManyToOne.getReferencedEntityName());
                targetValue = targetManyToOne;
            } else {
                targetValue = new BasicValue(this.getBuildingContext(), mapKeyTable);
                targetValue.copyTypeFrom(sourceValue);
            }
            for (Selectable current : sourceValue.getSelectables()) {
                if (current instanceof Column) {
                    targetValue.addColumn(((Column)current).clone());
                    continue;
                }
                if (current instanceof Formula) {
                    targetValue.addFormula(new Formula(((Formula)current).getFormula()));
                    continue;
                }
                throw new AssertionFailure("Unknown element in column iterator: " + current.getClass());
            }
            return targetValue;
        }
        throw new AssertionFailure("Unknown type encountered for map key: " + value.getClass());
    }
}

