/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.internal;

import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.internal.JpaAttributeConverterImpl;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.AttributeConverterJdbcTypeAdapter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class ConvertedJdbcMapping<T>
implements JdbcMapping {
    private final ManagedBean<AttributeConverter<?, ?>> converterBean;
    private final JavaType<T> domainJtd;
    private final JavaType<?> relationalJtd;
    private final JdbcType jdbcType;

    public ConvertedJdbcMapping(ManagedBean<AttributeConverter<?, ?>> converterBean, TypeConfiguration typeConfiguration) {
        this.converterBean = converterBean;
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        JavaType converterJtd = jtdRegistry.resolveDescriptor(converterBean.getBeanClass());
        ParameterizedType converterParameterizedType = GenericsHelper.extractParameterizedType(converterBean.getBeanClass());
        Class<?> domainJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[1]);
        this.domainJtd = jtdRegistry.resolveDescriptor(domainJavaClass);
        this.relationalJtd = jtdRegistry.resolveDescriptor(relationalJavaClass);
        JpaAttributeConverterImpl converterDescriptor = new JpaAttributeConverterImpl(converterBean, converterJtd, this.domainJtd, this.relationalJtd);
        this.jdbcType = new AttributeConverterJdbcTypeAdapter(converterDescriptor, this.relationalJtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators()), this.relationalJtd);
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.domainJtd;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public ValueExtractor<?> getJdbcValueExtractor() {
        return this.jdbcType.getExtractor(this.domainJtd);
    }

    @Override
    public ValueBinder<T> getJdbcValueBinder() {
        return this.jdbcType.getBinder(this.domainJtd);
    }
}

