/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class PostgreSQLIntervalSecondJdbcType
implements AdjustableJdbcType {
    public static final PostgreSQLIntervalSecondJdbcType INSTANCE;
    private static final Constructor<Object> PG_INTERVAL_CONSTRUCTOR;

    @Override
    public int getJdbcTypeCode() {
        return 1111;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3100;
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        if (indicators.getColumnScale() == -1 || indicators.getColumnScale() > 6) {
            return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(2);
        }
        return this;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> dialect.appendIntervalLiteral(appender, javaType.unwrap(value, Duration.class, wrapperOptions));
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Duration duration = this.getJavaType().unwrap(value, Duration.class, options);
                st.setObject(index, this.constructInterval(duration));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Duration duration = this.getJavaType().unwrap(value, Duration.class, options);
                st.setObject(name, this.constructInterval(duration));
            }

            private Object constructInterval(Duration d) {
                long secondsLong = d.getSeconds();
                long minutesLong = secondsLong / 60L;
                long hoursLong = minutesLong / 60L;
                long daysLong = hoursLong / 24L;
                int days = Math.toIntExact(daysLong);
                int hours = (int)(hoursLong - daysLong * 24L);
                int minutes = (int)(minutesLong - hoursLong * 60L);
                double seconds = (double)(secondsLong - minutesLong * 60L) + (double)d.getNano() / 1.0E9;
                try {
                    return PG_INTERVAL_CONSTRUCTOR.newInstance(0, 0, days, hours, minutes, seconds);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getString(name), options);
            }
        };
    }

    static {
        Constructor constructor;
        INSTANCE = new PostgreSQLIntervalSecondJdbcType();
        try {
            Class pgIntervalClass = ReflectHelper.classForName("org.postgresql.util.PGInterval", PostgreSQLIntervalSecondJdbcType.class);
            constructor = pgIntervalClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize PostgreSQLPGObjectJdbcType", e);
        }
        PG_INTERVAL_CONSTRUCTOR = constructor;
    }
}

