/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;

public class Replacer {
    private final String[] chunks;
    private final String quote;
    private final String delimiter;
    private final List<Replacement> replacements = new ArrayList<Replacement>();

    public Replacer(String format, String quote, String delimiter) {
        this.delimiter = delimiter;
        this.chunks = format.split(quote);
        this.quote = quote;
    }

    public Replacer replace(String placeholder, String replacement) {
        for (Replacement old : this.replacements) {
            if (!old.placeholder.equals(placeholder)) continue;
            old.replacement = replacement;
            return this;
        }
        this.replacements.add(new Replacement(placeholder, replacement));
        return this;
    }

    public String result() {
        int i;
        for (i = 0; i < this.chunks.length; i += 2) {
            StringBuilder chunk = new StringBuilder(this.chunks[i]);
            block1: for (int position = 0; position < chunk.length(); ++position) {
                for (Replacement replacement : this.replacements) {
                    int result = replacement.apply(chunk, position);
                    if (result < 0) continue;
                    position += result;
                    continue block1;
                }
            }
            this.chunks[i] = chunk.toString();
        }
        for (i = 1; i < this.chunks.length; i += 2) {
            if (this.chunks[i].isEmpty()) {
                if (this.delimiter.equals(this.quote)) {
                    this.chunks[i] = this.quote + this.quote;
                }
                if (this.delimiter.equals(this.quote + this.quote)) {
                    this.chunks[i] = this.quote + this.quote + this.quote + this.quote;
                    continue;
                }
                this.chunks[i] = this.quote;
                continue;
            }
            if (this.delimiter.isEmpty() || this.delimiter.equals(this.quote)) continue;
            this.chunks[i] = this.chunks[i].replace(this.delimiter, "\\" + this.delimiter);
        }
        return String.join((CharSequence)this.delimiter, this.chunks);
    }

    static class Replacement {
        String placeholder;
        String replacement;

        Replacement(String placeholder, String replacement) {
            this.placeholder = placeholder;
            this.replacement = replacement;
        }

        int apply(StringBuilder string, int position) {
            if (position + this.placeholder.length() > string.length()) {
                return -1;
            }
            for (int index = 0; index < this.placeholder.length(); ++index) {
                if (string.charAt(position + index) == this.placeholder.charAt(index)) continue;
                return -1;
            }
            string.replace(position, position + this.placeholder.length(), this.replacement);
            return this.replacement.length();
        }
    }
}

