/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.List;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerFormatEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final SQLServerDialect dialect;

    public SQLServerFormatEmulation(SQLServerDialect dialect, TypeConfiguration typeConfiguration) {
        super("format", CommonFunctionFactory.formatValidator(), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        Expression datetime = (Expression)arguments.get(0);
        boolean isTime = TypeConfiguration.getSqlTemporalType(datetime.getExpressionType()) == TemporalType.TIME;
        Format format = (Format)arguments.get(1);
        sqlAppender.appendSql("format(");
        if (isTime) {
            sqlAppender.appendSql("cast(");
            datetime.accept(walker);
            sqlAppender.appendSql(" as datetime)");
        } else {
            datetime.accept(walker);
        }
        sqlAppender.appendSql(",'");
        this.dialect.appendDatetimeFormat(sqlAppender, format.getFormat());
        sqlAppender.appendSql("')");
    }

    @Override
    public String getArgumentListSignature() {
        return "(TEMPORAL datetime as STRING pattern)";
    }
}

