/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.JavaObjectType;

public class SqlFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public SqlFunction() {
        super("sql", StandardArgumentsValidators.min(1), StandardFunctionReturnTypeResolvers.invariant(JavaObjectType.INSTANCE));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        QueryLiteral sqlFragmentLiteral = (QueryLiteral)arguments.get(0);
        String sqlFragment = (String)sqlFragmentLiteral.getLiteralValue();
        if (arguments.size() != 1) {
            int index = 0;
            for (int i = 1; i < arguments.size(); ++i) {
                SqlAstNode argument = arguments.get(i);
                int paramIndex = sqlFragment.indexOf(63, index);
                if (paramIndex == -1) {
                    throw new IllegalArgumentException("The SQL function passes an argument at index " + i + " but the fragment contains no placeholder for the argument: " + sqlFragment);
                }
                sqlAppender.append(sqlFragment, index, paramIndex);
                argument.accept(walker);
                index = paramIndex + 1;
            }
        } else {
            sqlAppender.appendSql(sqlFragment);
        }
    }

    @Override
    public String getArgumentListSignature() {
        return "";
    }
}

