/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class JdbcEnvironmentInitiator
implements StandardServiceInitiator<JdbcEnvironment> {
    private static final CoreMessageLogger log = Logger.getMessageLogger(CoreMessageLogger.class, JdbcEnvironmentInitiator.class.getName());
    public static final JdbcEnvironmentInitiator INSTANCE = new JdbcEnvironmentInitiator();

    @Override
    public Class<JdbcEnvironment> getServiceInitiated() {
        return JdbcEnvironment.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JdbcEnvironment initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        DialectFactory dialectFactory = registry.getService(DialectFactory.class);
        boolean useJdbcMetadata = ConfigurationHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", configurationValues, true);
        Object dbName = NullnessHelper.coalesceSuppliedValues(() -> configurationValues.get("jakarta.persistence.database-product-name"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-name");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-name", "jakarta.persistence.database-product-name");
            }
            return value;
        });
        if (dbName != null) {
            String dbVersion = (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-version"), () -> {
                Object value = configurationValues.get("javax.persistence.database-product-version");
                if (value != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-version", "jakarta.persistence.database-product-version");
                }
                return (String)value;
            }, () -> "0");
            int dbMajorVersion = (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-major-version", configurationValues), () -> {
                Integer value = ConfigurationHelper.getInteger("javax.persistence.database-major-version", configurationValues);
                if (value != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-major-version", "jakarta.persistence.database-major-version");
                }
                return value;
            }, () -> 0);
            int dbMinorVersion = (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-minor-version", configurationValues), () -> {
                Integer value = ConfigurationHelper.getInteger("javax.persistence.database-minor-version", configurationValues);
                if (value != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-minor-version", "jakarta.persistence.database-minor-version");
                }
                return value;
            }, () -> 0);
            return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, () -> new DialectResolutionInfo(){

                @Override
                public String getDatabaseName() {
                    return (String)dbName;
                }

                @Override
                public String getDatabaseVersion() {
                    return dbVersion;
                }

                @Override
                public int getDatabaseMajorVersion() {
                    return dbMajorVersion;
                }

                @Override
                public int getDatabaseMinorVersion() {
                    return dbMinorVersion;
                }

                @Override
                public String getDriverName() {
                    return "";
                }

                @Override
                public int getDriverMajorVersion() {
                    return 0;
                }

                @Override
                public int getDriverMinorVersion() {
                    return 0;
                }

                @Override
                public String getSQLKeywords() {
                    return "";
                }
            }));
        }
        if (!useJdbcMetadata) return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, null));
        JdbcConnectionAccess jdbcConnectionAccess = this.buildJdbcConnectionAccess(configurationValues, registry);
        try {
            Connection connection = jdbcConnectionAccess.obtainConnection();
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                if (log.isDebugEnabled()) {
                    log.debugf("Database ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", dbmd.getDatabaseProductName(), dbmd.getDatabaseProductVersion(), dbmd.getDatabaseMajorVersion(), dbmd.getDatabaseMinorVersion());
                    log.debugf("Driver ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", dbmd.getDriverName(), dbmd.getDriverVersion(), dbmd.getDriverMajorVersion(), dbmd.getDriverMinorVersion());
                    log.debugf("JDBC version : %s.%s", dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion());
                }
                Dialect dialect = dialectFactory.buildDialect(configurationValues, () -> {
                    try {
                        return new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
                    }
                    catch (SQLException sqlException) {
                        throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", sqlException);
                    }
                });
                JdbcEnvironmentImpl jdbcEnvironmentImpl = new JdbcEnvironmentImpl(registry, dialect, dbmd, jdbcConnectionAccess);
                return jdbcEnvironmentImpl;
            }
            catch (SQLException e) {
                log.unableToObtainConnectionMetadata(e);
                return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, null));
            }
            finally {
                try {
                    jdbcConnectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception e2) {
            log.unableToObtainConnectionToQueryMetadata(e2);
        }
        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, null));
    }

    private JdbcConnectionAccess buildJdbcConnectionAccess(Map<?, ?> configValues, ServiceRegistryImplementor registry) {
        if (!configValues.containsKey("hibernate.multi_tenant_connection_provider")) {
            ConnectionProvider connectionProvider = registry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(connectionProvider);
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    public static JdbcConnectionAccess buildBootstrapJdbcConnectionAccess(boolean multiTenancyEnabled, ServiceRegistryImplementor registry) {
        if (!multiTenancyEnabled) {
            ConnectionProvider connectionProvider = registry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(connectionProvider);
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    public static class MultiTenantConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final MultiTenantConnectionProvider connectionProvider;

        public MultiTenantConnectionProviderJdbcConnectionAccess(MultiTenantConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public MultiTenantConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getAnyConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.releaseAnyConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    public static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public ConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

