/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SubselectFetch {
    private final EntityValuedModelPart entityModelPart;
    private final QuerySpec loadingSqlAst;
    private final TableGroup ownerTableGroup;
    private final List<JdbcParameter> loadingJdbcParameters;
    private final JdbcParameterBindings loadingJdbcParameterBindings;
    private final Set<EntityKey> resultingEntityKeys;
    private static final RegistrationHandler NO_OP_REG_HANDLER = new RegistrationHandler(){

        @Override
        public void addKey(EntityKey key) {
        }
    };

    public SubselectFetch(EntityValuedModelPart entityModelPart, QuerySpec loadingSqlAst, TableGroup ownerTableGroup, List<JdbcParameter> loadingJdbcParameters, JdbcParameterBindings loadingJdbcParameterBindings, Set<EntityKey> resultingEntityKeys) {
        this.entityModelPart = entityModelPart;
        this.loadingSqlAst = loadingSqlAst;
        this.ownerTableGroup = ownerTableGroup;
        this.loadingJdbcParameters = loadingJdbcParameters;
        this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        this.resultingEntityKeys = resultingEntityKeys;
    }

    public EntityValuedModelPart getEntityModelPart() {
        return this.entityModelPart;
    }

    public List<JdbcParameter> getLoadingJdbcParameters() {
        return this.loadingJdbcParameters;
    }

    public QuerySpec getLoadingSqlAst() {
        return this.loadingSqlAst;
    }

    public TableGroup getOwnerTableGroup() {
        return this.ownerTableGroup;
    }

    public JdbcParameterBindings getLoadingJdbcParameterBindings() {
        return this.loadingJdbcParameterBindings;
    }

    public Set<EntityKey> getResultingEntityKeys() {
        return this.resultingEntityKeys;
    }

    public String toString() {
        return "SubselectFetch(" + this.entityModelPart.getEntityMappingType().getEntityName() + ")";
    }

    public static RegistrationHandler createRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement sqlAst, TableGroup tableGroup, List<JdbcParameter> jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        SubselectFetch subselectFetch = new SubselectFetch(null, sqlAst.getQuerySpec(), tableGroup, jdbcParameters, jdbcParameterBindings, new HashSet<EntityKey>());
        return new StandardRegistrationHandler(batchFetchQueue, subselectFetch);
    }

    public static RegistrationHandler createRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        List<TableGroup> roots = sqlAst.getQuerySpec().getFromClause().getRoots();
        if (roots.isEmpty()) {
            return NO_OP_REG_HANDLER;
        }
        return SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, roots.get(0), jdbcParameters, jdbcParameterBindings);
    }

    public static class StandardRegistrationHandler
    implements RegistrationHandler {
        private final BatchFetchQueue batchFetchQueue;
        private final SubselectFetch subselectFetch;

        private StandardRegistrationHandler(BatchFetchQueue batchFetchQueue, SubselectFetch subselectFetch) {
            this.batchFetchQueue = batchFetchQueue;
            this.subselectFetch = subselectFetch;
        }

        @Override
        public void addKey(EntityKey key) {
            this.subselectFetch.resultingEntityKeys.add(key);
            this.batchFetchQueue.addSubselect(key, this.subselectFetch);
        }
    }

    public static interface RegistrationHandler {
        public void addKey(EntityKey var1);
    }
}

