/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.io.Serializable;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.ParsingException;

public class ExceptionConverterImpl
implements ExceptionConverter {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(ExceptionConverterImpl.class);
    private final SharedSessionContractImplementor sharedSessionContract;
    private final boolean isJpaBootstrap;

    public ExceptionConverterImpl(SharedSessionContractImplementor sharedSessionContract) {
        this.sharedSessionContract = sharedSessionContract;
        this.isJpaBootstrap = sharedSessionContract.getFactory().getSessionFactoryOptions().isJpaBootstrap();
    }

    @Override
    public RuntimeException convertCommitException(RuntimeException e) {
        if (this.isJpaBootstrap) {
            RuntimeException wrappedException;
            if (e instanceof HibernateException) {
                wrappedException = this.convert((HibernateException)e);
            } else if (e instanceof PersistenceException) {
                Throwable cause;
                Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
                wrappedException = cause instanceof HibernateException ? this.convert((HibernateException)cause) : cause;
            } else {
                wrappedException = e;
            }
            try {
                this.sharedSessionContract.getTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new RollbackException("Error while committing the transaction", wrappedException);
        }
        return e;
    }

    @Override
    public RuntimeException convert(HibernateException exception, LockOptions lockOptions) {
        if (exception instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)exception);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof LockAcquisitionException) {
            PersistenceException converted = this.wrapLockException(exception, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof LockingStrategyException) {
            PersistenceException converted = this.wrapLockException(exception, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException(exception, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof QueryTimeoutException) {
            jakarta.persistence.QueryTimeoutException converted = new jakarta.persistence.QueryTimeoutException(exception.getMessage(), exception);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(exception.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof NonUniqueObjectException) {
            EntityExistsException converted = new EntityExistsException(exception.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof NonUniqueResultException) {
            jakarta.persistence.NonUniqueResultException converted = new jakarta.persistence.NonUniqueResultException(exception.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(exception.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (exception instanceof SemanticException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof QueryException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof InterpretationException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof ParsingException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof MultipleBagFetchException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof TransientObjectException) {
            try {
                this.sharedSessionContract.markForRollbackOnly();
            }
            catch (Exception ne) {
                log.unableToMarkForRollbackOnTransientObjectException(ne);
            }
            return new IllegalStateException(exception);
        }
        PersistenceException converted = new PersistenceException("Converting `" + exception.getClass().getName() + "` to JPA `PersistenceException` : " + exception.getMessage(), exception);
        this.handlePersistenceException(converted);
        return converted;
    }

    @Override
    public RuntimeException convert(HibernateException e) {
        return this.convert(e, null);
    }

    @Override
    public RuntimeException convert(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)e);
        } else {
            this.sharedSessionContract.markForRollbackOnly();
        }
        return result;
    }

    @Override
    public RuntimeException convert(RuntimeException e, LockOptions lockOptions) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)e, lockOptions);
        } else {
            this.sharedSessionContract.markForRollbackOnly();
        }
        return result;
    }

    @Override
    public JDBCException convert(SQLException e, String message) {
        return this.sharedSessionContract.getJdbcServices().getSqlExceptionHelper().convert(e, message);
    }

    protected PersistenceException wrapStaleStateException(StaleStateException e) {
        OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Object identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.sharedSessionContract.internalLoad(sose.getEntityName(), identifier, false, true);
                        if (entity instanceof Serializable) {
                            pe = new OptimisticLockException(e.getMessage(), e, entity);
                            break block7;
                        }
                        pe = new OptimisticLockException(e.getMessage(), e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new OptimisticLockException(e.getMessage(), e);
                    }
                } else {
                    pe = new OptimisticLockException(e.getMessage(), e);
                }
            } else {
                pe = new OptimisticLockException(e.getMessage(), e);
            }
        }
        return pe;
    }

    protected PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        PersistenceException pe;
        if (e instanceof OptimisticEntityLockException) {
            OptimisticEntityLockException lockException = (OptimisticEntityLockException)e;
            pe = new OptimisticLockException(lockException.getMessage(), lockException, lockException.getEntity());
        } else if (e instanceof LockTimeoutException) {
            pe = new jakarta.persistence.LockTimeoutException(e.getMessage(), e, null);
        } else if (e instanceof PessimisticEntityLockException) {
            PessimisticEntityLockException lockException = (PessimisticEntityLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new jakarta.persistence.LockTimeoutException(lockException.getMessage(), lockException, lockException.getEntity()) : new jakarta.persistence.PessimisticLockException(lockException.getMessage(), lockException, lockException.getEntity());
        } else if (e instanceof PessimisticLockException) {
            PessimisticLockException jdbcLockException = (PessimisticLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new jakarta.persistence.LockTimeoutException(jdbcLockException.getMessage(), jdbcLockException, null) : new jakarta.persistence.PessimisticLockException(jdbcLockException.getMessage(), jdbcLockException, null);
        } else {
            pe = new OptimisticLockException(e);
        }
        return pe;
    }

    private void handlePersistenceException(PersistenceException e) {
        if (e instanceof NoResultException) {
            return;
        }
        if (e instanceof jakarta.persistence.NonUniqueResultException) {
            return;
        }
        if (e instanceof jakarta.persistence.LockTimeoutException) {
            return;
        }
        if (e instanceof jakarta.persistence.QueryTimeoutException) {
            return;
        }
        try {
            this.sharedSessionContract.markForRollbackOnly();
        }
        catch (Exception ne) {
            log.unableToMarkForRollbackOnPersistenceException(ne);
        }
    }
}

