/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.transaction.SystemException;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.entity.EntityMetamodel;

public class StatelessSessionImpl
extends AbstractSharedSessionContract
implements StatelessSession {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StatelessSessionImpl.class);
    private static final LoadQueryInfluencers NO_INFLUENCERS = new LoadQueryInfluencers(null){

        @Override
        public String getInternalFetchProfile() {
            return null;
        }

        @Override
        public void setInternalFetchProfile(String internalFetchProfile) {
        }
    };
    private final PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);
    private final boolean connectionProvided;

    public StatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options) {
        super(factory, options);
        this.connectionProvided = options.getConnection() != null;
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return true;
    }

    @Override
    public Object insert(Object entity) {
        this.checkOpen();
        return this.insert(null, entity);
    }

    @Override
    public Object insert(String entityName, Object entity) {
        boolean substitute;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifierGenerator().generate(this, entity);
        Object[] state = persister.getPropertyValues(entity);
        if (persister.isVersioned() && (substitute = Versioning.seedVersion(state, persister.getVersionProperty(), persister.getVersionJavaType(), this))) {
            persister.setPropertyValues(entity, state);
        }
        if (id == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            id = persister.insert(state, entity, this);
        } else {
            persister.insert(id, state, entity, this);
        }
        persister.setIdentifier(entity, id, this);
        return id;
    }

    @Override
    public void delete(Object entity) {
        this.checkOpen();
        this.delete(null, entity);
    }

    @Override
    public void delete(String entityName, Object entity) {
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Object version = persister.getVersion(entity);
        persister.delete(id, version, entity, this);
    }

    @Override
    public void update(Object entity) {
        this.checkOpen();
        this.update(null, entity);
    }

    @Override
    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Object[] state = persister.getPropertyValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            Object newVersion = Versioning.increment(oldVersion, persister.getVersionJavaType(), this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setPropertyValues(entity, state);
        } else {
            oldVersion = null;
        }
        persister.update(id, state, null, false, null, oldVersion, entity, null, this);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) {
        return (T)this.get(entityClass.getName(), id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id, LockMode lockMode) {
        return (T)this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(String entityName, Object id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    @Override
    public Object get(String entityName, Object id, LockMode lockMode) {
        this.checkOpen();
        EntityPersister entityDescriptor = this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        Object result = entityDescriptor.load(id, null, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this);
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
        return result;
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(this.bestGuessEntityName(entity), entity, LockMode.NONE);
    }

    @Override
    public void refresh(String entityName, Object entity) {
        this.refresh(entityName, entity, LockMode.NONE);
    }

    @Override
    public void refresh(Object entity, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(entity), entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(String entityName, Object entity, LockMode lockMode) {
        Object result;
        EntityDataAccess cacheAccess;
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Refreshing transient {0}", (Object)MessageHelper.infoString(persister, id, this.getFactory()));
        }
        if (persister.canWriteToCache() && (cacheAccess = persister.getCacheAccessStrategy()) != null) {
            Object ck = cacheAccess.generateCacheKey(id, persister, this.getFactory(), this.getTenantIdentifier());
            cacheAccess.evict(ck);
        }
        String previousFetchProfile = this.getLoadQueryInfluencers().getInternalFetchProfile();
        try {
            this.getLoadQueryInfluencers().setInternalFetchProfile("refresh");
            result = persister.load(id, entity, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this);
        }
        finally {
            this.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile);
        }
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
    }

    @Override
    public Object immediateLoad(String entityName, Object id) throws HibernateException {
        if (this.getPersistenceContextInternal().isLoadFinished()) {
            throw new SessionException("proxies cannot be fetched by a stateless session");
        }
        return this.get(entityName, id);
    }

    @Override
    public void initializeCollection(PersistentCollection<?> collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    @Override
    public Object instantiate(String entityName, Object id) throws HibernateException {
        EntityPersister entityDescriptor = this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        return this.instantiate(entityDescriptor, id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Object id) throws HibernateException {
        this.checkOpen();
        return persister.instantiate(id, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object internalLoad(String entityName, Object id, boolean eager, boolean nullable) throws HibernateException {
        this.checkOpen();
        EntityPersister entityDescriptor = this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        EntityKey entityKey = this.generateEntityKey(id, entityDescriptor);
        PersistenceContext persistenceContext = this.getPersistenceContext();
        Object loaded = persistenceContext.getEntity(entityKey);
        if (loaded != null) {
            return loaded;
        }
        if (!eager) {
            EntityMetamodel entityMetamodel = entityDescriptor.getEntityMetamodel();
            BytecodeEnhancementMetadata bytecodeEnhancementMetadata = entityMetamodel.getBytecodeEnhancementMetadata();
            if (bytecodeEnhancementMetadata.isEnhancedForLazyLoading()) {
                if (entityDescriptor.getRepresentationStrategy().getProxyFactory() != null) {
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy != null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Entity proxy found in session cache");
                        }
                        if (LOG.isDebugEnabled() && ((HibernateProxy)proxy).getHibernateLazyInitializer().isUnwrap()) {
                            LOG.debug("Ignoring NO_PROXY to honor laziness");
                        }
                        return persistenceContext.narrowProxy(proxy, entityDescriptor, entityKey, null);
                    }
                    if (entityMetamodel.hasSubclasses()) {
                        LOG.debug("Creating a HibernateProxy for to-one association with subclasses to honor laziness");
                        return this.createProxy(entityKey);
                    }
                    return bytecodeEnhancementMetadata.createEnhancedProxy(entityKey, false, this);
                }
                if (!entityMetamodel.hasSubclasses()) {
                    return bytecodeEnhancementMetadata.createEnhancedProxy(entityKey, false, this);
                }
            } else if (entityDescriptor.hasProxy()) {
                Object existingProxy = persistenceContext.getProxy(entityKey);
                if (existingProxy != null) {
                    return persistenceContext.narrowProxy(existingProxy, entityDescriptor, entityKey, null);
                }
                return this.createProxy(entityKey);
            }
        }
        persistenceContext.beforeLoad();
        try {
            Object object = this.get(entityName, id);
            return object;
        }
        finally {
            persistenceContext.afterLoad();
        }
    }

    private Object createProxy(EntityKey entityKey) {
        Object proxy = entityKey.getPersister().createProxy(entityKey.getIdentifier(), this);
        this.getPersistenceContext().addProxy(entityKey, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(Object association) {
        PersistentCollection persistentCollection;
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        if (association instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)association).getHibernateLazyInitializer();
            if (initializer.isUninitialized()) {
                String entityName = initializer.getEntityName();
                Object id = initializer.getIdentifier();
                initializer.setSession(this);
                persistenceContext.beforeLoad();
                try {
                    Object entity = initializer.getImplementation();
                    if (entity == null) {
                        this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
                    }
                    initializer.setImplementation(entity);
                }
                finally {
                    initializer.unsetSession();
                    persistenceContext.afterLoad();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }
            }
        } else if (association instanceof PersistentAttributeInterceptable) {
            PersistentAttributeInterceptor interceptor = ((PersistentAttributeInterceptable)association).$$_hibernate_getInterceptor();
            if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                proxyInterceptor.setSession(this);
                try {
                    proxyInterceptor.forceInitialize(association, null);
                }
                finally {
                    proxyInterceptor.unsetSession();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }
            }
        } else if (association instanceof PersistentCollection && !(persistentCollection = (PersistentCollection)association).wasInitialized()) {
            CollectionPersister collectionDescriptor = this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(persistentCollection.getRole());
            Object key = persistentCollection.getKey();
            persistenceContext.addUninitializedCollection(collectionDescriptor, persistentCollection, key);
            persistentCollection.setCurrentSession(this);
            try {
                collectionDescriptor.initialize(key, this);
            }
            finally {
                persistentCollection.unsetSession(this);
                if (persistenceContext.isLoadFinished()) {
                    persistenceContext.clear();
                }
            }
        }
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.getFactory().getSessionFactoryOptions().isAutoCloseSessionEnabled();
    }

    @Override
    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    private boolean isFlushModeNever() {
        return false;
    }

    private void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed!");
        }
        this.close();
    }

    private void managedFlush() {
        this.checkOpen();
        this.getJdbcCoordinator().executeBatch();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    @Override
    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlushMode(FlushMode fm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getContextEntityIdentifier(Object object) {
        this.checkOpen();
        return null;
    }

    @Override
    public String guessEntityName(Object entity) throws HibernateException {
        this.checkOpen();
        return entity.getClass().getName();
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        this.checkOpen();
        if (entityName == null) {
            return this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(this.guessEntityName(object));
        }
        return this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName).getSubclassEntityPersister(object, this.getFactory());
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        Object result = persistenceContext.getEntity(key);
        if (result != null) {
            return result;
        }
        Object newObject = this.getInterceptor().getEntity(key.getEntityName(), key.getIdentifier());
        if (newObject != null) {
            persistenceContext.addEntity(key, newObject);
            return newObject;
        }
        return null;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object load(String entityName, Object identifier) {
        return null;
    }

    @Override
    public boolean isEventSource() {
        return false;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return false;
    }

    public void setDefaultReadOnly(boolean readOnly) throws HibernateException {
        if (readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void afterOperation(boolean success) {
        this.temporaryPersistenceContext.clear();
        if (!this.isTransactionInProgress()) {
            this.getJdbcCoordinator().afterTransaction();
        }
    }

    @Override
    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return NO_INFLUENCERS;
    }

    @Override
    public PersistenceContext getPersistenceContextInternal() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public boolean autoFlushIfRequired(Set<String> querySpaces) throws HibernateException {
        return false;
    }

    @Override
    public void afterTransactionBegin() {
    }

    @Override
    public void beforeTransactionCompletion() {
        this.flushBeforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        if (this.shouldAutoClose() && !this.isClosed()) {
            this.managedClose();
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.connectionProvided || super.isTransactionInProgress();
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        boolean flush;
        try {
            flush = !this.isClosed() && !this.isFlushModeNever() && !JtaStatusHelper.isRollback(this.getJtaPlatform().getCurrentStatus());
        }
        catch (SystemException se) {
            throw new HibernateException("could not determine transaction status in beforeCompletion()", se);
        }
        if (flush) {
            this.managedFlush();
        }
    }

    private JtaPlatform getJtaPlatform() {
        return this.getFactory().getServiceRegistry().getService(JtaPlatform.class);
    }

    private LockMode getNullSafeLockMode(LockMode lockMode) {
        return lockMode == null ? LockMode.NONE : lockMode;
    }
}

