/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.log;

import java.sql.SQLException;
import java.util.Properties;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HHH")
@ValidIdRange(min=10001001, max=10001500)
public interface ConnectionPoolingLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.connections.pooling";
    public static final Logger CONNECTIONS_LOGGER = Logger.getLogger("org.hibernate.orm.connections.pooling");
    public static final ConnectionPoolingLogger CONNECTIONS_MESSAGE_LOGGER = Logger.getMessageLogger(ConnectionPoolingLogger.class, "org.hibernate.orm.connections.pooling");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connection properties: %s", id=10001001)
    public void connectionProperties(Properties var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Using built-in connection pool (not intended for production use)", id=10001002)
    public void usingHibernateBuiltInConnectionPool();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Autocommit mode: %s", id=10001003)
    public void autoCommitMode(boolean var1);

    @Message(value="No JDBC URL specified by property %s", id=10001004)
    public String jdbcUrlNotSpecified(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded JDBC driver class: %s", id=10001005)
    public void loadedDriver(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="No JDBC driver class specified by %s", id=10001010)
    public void noDriver(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded JDBC drivers: %s", id=10001011)
    public void loadedDrivers(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connecting with JDBC URL [%s]", id=10001012)
    public void usingUrl(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No JDBC Driver class was specified by property %s", id=10001006)
    public void jdbcDriverNotSpecified(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="JDBC isolation level: %s", id=10001007)
    public void jdbcIsolationLevel(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cleaning up connection pool [%s]", id=10001008)
    public void cleaningUpConnectionPool(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem closing pooled connection", id=10001009)
    public void unableToClosePooledConnection(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connection pool size: %s (min=%s)", id=10001115)
    public void hibernateConnectionPoolSize(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error closing connection", id=10001284)
    public void unableToCloseConnection(@Cause Exception var1);
}

