/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.MappingException;
import org.hibernate.boot.model.CustomSql;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.internal.util.collections.SingletonIterator;
import org.hibernate.jpa.event.spi.CallbackDefinition;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Contributable;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.Alias;

public abstract class PersistentClass
implements AttributeContainer,
Serializable,
Filterable,
MetaAttributable,
Contributable {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    public static final String NULL_DISCRIMINATOR_MAPPING = "null";
    public static final String NOT_NULL_DISCRIMINATOR_MAPPING = "not null";
    private final MetadataBuildingContext metadataBuildingContext;
    private final String contributor;
    private String entityName;
    private String className;
    private transient Class<?> mappedClass;
    private String proxyInterfaceName;
    private transient Class<?> proxyInterface;
    private String jpaEntityName;
    private String discriminatorValue;
    private boolean lazy;
    private final List<Property> properties = new ArrayList<Property>();
    private final List<Property> declaredProperties = new ArrayList<Property>();
    private final List<Subclass> subclasses = new ArrayList<Subclass>();
    private final List<Property> subclassProperties = new ArrayList<Property>();
    private final List<Table> subclassTables = new ArrayList<Table>();
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private int batchSize = -1;
    private boolean selectBeforeUpdate;
    private Map metaAttributes;
    private final List<Join> joins = new ArrayList<Join>();
    private final List<Join> subclassJoins = new ArrayList<Join>();
    private final List<FilterConfiguration> filters = new ArrayList<FilterConfiguration>();
    protected final Set<String> synchronizedTables = new HashSet<String>();
    private String loaderName;
    private Boolean isAbstract;
    private boolean hasSubselectLoadableCollections;
    private Component identifierMapper;
    private List<CallbackDefinition> callbackDefinitions;
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private MappedSuperclass superMappedSuperclass;
    private Component declaredIdentifierMapper;
    private OptimisticLockStyle optimisticLockStyle;
    private boolean isCached;
    private Boolean hasNaturalId;

    public PersistentClass(MetadataBuildingContext metadataBuildingContext) {
        this.metadataBuildingContext = metadataBuildingContext;
        this.contributor = metadataBuildingContext.getCurrentContributorName();
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.metadataBuildingContext.getBuildingOptions().getServiceRegistry();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className == null ? null : className.intern();
        this.mappedClass = null;
    }

    public String getProxyInterfaceName() {
        return this.proxyInterfaceName;
    }

    public void setProxyInterfaceName(String proxyInterfaceName) {
        this.proxyInterfaceName = proxyInterfaceName;
        this.proxyInterface = null;
    }

    public Class<?> getMappedClass() throws MappingException {
        if (this.className == null) {
            return null;
        }
        try {
            if (this.mappedClass == null) {
                this.mappedClass = this.metadataBuildingContext.getBootstrapContext().getClassLoaderAccess().classForName(this.className);
            }
            return this.mappedClass;
        }
        catch (ClassLoadingException e) {
            throw new MappingException("entity class not found: " + this.className, e);
        }
    }

    public Class<?> getProxyInterface() {
        if (this.proxyInterfaceName == null) {
            return null;
        }
        try {
            if (this.proxyInterface == null) {
                this.proxyInterface = this.metadataBuildingContext.getBootstrapContext().getClassLoaderAccess().classForName(this.proxyInterfaceName);
            }
            return this.proxyInterface;
        }
        catch (ClassLoadingException e) {
            throw new MappingException("proxy class not found: " + this.proxyInterfaceName, e);
        }
    }

    public boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    abstract int nextSubclassId();

    public abstract int getSubclassId();

    public boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void addSubclass(Subclass subclass) throws MappingException {
        for (PersistentClass superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!subclass.getEntityName().equals(superclass.getEntityName())) continue;
            throw new MappingException("Circular inheritance mapping detected: " + subclass.getEntityName() + " will have itself as superclass when extending " + this.getEntityName());
        }
        this.subclasses.add(subclass);
    }

    public boolean hasSubclasses() {
        return this.subclasses.size() > 0;
    }

    public int getSubclassSpan() {
        int n = this.subclasses.size();
        for (Subclass subclass : this.subclasses) {
            n += subclass.getSubclassSpan();
        }
        return n;
    }

    public List<Subclass> getSubclasses() {
        List[] iters = new List[this.subclasses.size() + 1];
        int i = 0;
        for (Subclass subclass : this.subclasses) {
            iters[i++] = subclass.getSubclasses();
        }
        iters[i] = this.subclasses;
        return new JoinedList<Subclass>(iters);
    }

    @Deprecated(since="6.0")
    public Iterator<Subclass> getSubclassIterator() {
        Iterator[] iters = new Iterator[this.subclasses.size() + 1];
        Iterator<Subclass> iter = this.subclasses.iterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = iter.next().getSubclassIterator();
        }
        iters[i] = this.subclasses.iterator();
        return new JoinedIterator<Subclass>(iters);
    }

    public List<PersistentClass> getSubclassClosure() {
        ArrayList<List<List<PersistentClass>>> lists = new ArrayList<List<List<PersistentClass>>>();
        lists.add(List.of(this));
        for (Subclass subclass : this.getSubclasses()) {
            lists.add(subclass.getSubclassClosure());
        }
        return new JoinedList<PersistentClass>((List<List<PersistentClass>>)lists);
    }

    @Deprecated(since="6.0")
    public Iterator<PersistentClass> getSubclassClosureIterator() {
        ArrayList iters = new ArrayList();
        iters.add(new SingletonIterator<PersistentClass>(this));
        for (Subclass subclass : this.getSubclasses()) {
            iters.add(subclass.getSubclassClosureIterator());
        }
        return new JoinedIterator<PersistentClass>(iters);
    }

    public Table getIdentityTable() {
        return this.getRootTable();
    }

    public List<Subclass> getDirectSubclasses() {
        return this.subclasses;
    }

    @Override
    public void addProperty(Property p) {
        this.properties.add(p);
        this.declaredProperties.add(p);
        p.setPersistentClass(this);
    }

    public abstract Table getTable();

    public String getEntityName() {
        return this.entityName;
    }

    public abstract boolean isMutable();

    public abstract boolean hasIdentifierProperty();

    public abstract Property getIdentifierProperty();

    public abstract Property getDeclaredIdentifierProperty();

    public abstract KeyValue getIdentifier();

    public abstract Property getVersion();

    public abstract Property getDeclaredVersion();

    public abstract Value getDiscriminator();

    public abstract boolean isInherited();

    public abstract boolean isPolymorphic();

    public abstract boolean isVersioned();

    public boolean isCached() {
        return this.isCached;
    }

    public void setCached(boolean cached) {
        this.isCached = cached;
    }

    @Deprecated
    public boolean isCachingExplicitlyRequested() {
        return this.isCached();
    }

    @Deprecated
    public void setCachingExplicitlyRequested(boolean cached) {
        this.setCached(cached);
    }

    public abstract String getCacheConcurrencyStrategy();

    public abstract String getNaturalIdCacheRegionName();

    public abstract PersistentClass getSuperclass();

    public abstract boolean isExplicitPolymorphism();

    public abstract boolean isDiscriminatorInsertable();

    public abstract List<Property> getPropertyClosure();

    @Deprecated(since="6.0")
    public abstract Iterator<Property> getPropertyClosureIterator();

    public abstract List<Table> getTableClosure();

    @Deprecated(since="6.0")
    public abstract Iterator<Table> getTableClosureIterator();

    public abstract List<KeyValue> getKeyClosure();

    @Deprecated(since="6.0")
    public abstract Iterator<KeyValue> getKeyClosureIterator();

    protected void addSubclassProperty(Property prop) {
        this.subclassProperties.add(prop);
    }

    protected void addSubclassJoin(Join join) {
        this.subclassJoins.add(join);
    }

    protected void addSubclassTable(Table subclassTable) {
        this.subclassTables.add(subclassTable);
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getSubclassPropertyClosureIterator() {
        ArrayList iters = new ArrayList();
        iters.add(this.getPropertyClosureIterator());
        iters.add(this.subclassProperties.iterator());
        for (Join join : this.subclassJoins) {
            iters.add(join.getPropertyIterator());
        }
        return new JoinedIterator<Property>(iters);
    }

    public List<Property> getSubclassPropertyClosure() {
        ArrayList<List<List<Property>>> lists = new ArrayList<List<List<Property>>>();
        lists.add(this.getPropertyClosure());
        lists.add(this.subclassProperties);
        for (Join join : this.subclassJoins) {
            lists.add(join.getProperties());
        }
        return new JoinedList<Property>((List<List<Property>>)lists);
    }

    @Deprecated(since="6.0")
    public Iterator<Join> getSubclassJoinClosureIterator() {
        return new JoinedIterator<Join>(this.getJoinClosureIterator(), this.subclassJoins.iterator());
    }

    public List<Join> getSubclassJoinClosure() {
        return new JoinedList<Join>(this.getJoinClosure(), this.subclassJoins);
    }

    public List<Table> getSubclassTableClosure() {
        return new JoinedList<Table>(this.getTableClosure(), this.subclassTables);
    }

    @Deprecated(since="6.0")
    public Iterator<Table> getSubclassTableClosureIterator() {
        return new JoinedIterator<Table>(this.getTableClosureIterator(), this.subclassTables.iterator());
    }

    public boolean isClassOrSuperclassJoin(Join join) {
        return this.joins.contains(join);
    }

    public boolean isClassOrSuperclassTable(Table closureTable) {
        return this.getTable() == closureTable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public abstract boolean hasEmbeddedIdentifier();

    public abstract Class<? extends EntityPersister> getEntityPersisterClass();

    public abstract void setEntityPersisterClass(Class<? extends EntityPersister> var1);

    public abstract Table getRootTable();

    public abstract RootClass getRootClass();

    public abstract KeyValue getKey();

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName == null ? null : entityName.intern();
    }

    public void createPrimaryKey() {
        Table table = this.getTable();
        PrimaryKey pk = new PrimaryKey(table);
        pk.setName(PK_ALIAS.toAliasString(table.getName()));
        table.setPrimaryKey(pk);
        pk.addColumns(this.getKey());
    }

    public abstract String getWhere();

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean hasSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getReferenceablePropertyIterator() {
        return this.getPropertyClosureIterator();
    }

    public List<Property> getReferenceableProperties() {
        return this.getPropertyClosure();
    }

    public Property getReferencedProperty(String propertyPath) throws MappingException {
        try {
            return this.getRecursiveProperty(propertyPath, this.getReferenceableProperties());
        }
        catch (MappingException e) {
            throw new MappingException("property-ref [" + propertyPath + "] not found on entity [" + this.getEntityName() + "]", e);
        }
    }

    public Property getRecursiveProperty(String propertyPath) throws MappingException {
        try {
            return this.getRecursiveProperty(propertyPath, this.getPropertyClosure());
        }
        catch (MappingException e) {
            throw new MappingException("property [" + propertyPath + "] not found on entity [" + this.getEntityName() + "]", e);
        }
    }

    private Property getRecursiveProperty(String propertyPath, List<Property> iter) throws MappingException {
        Property property = null;
        StringTokenizer st = new StringTokenizer(propertyPath, ".", false);
        try {
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    Property identifierProperty = this.getIdentifierProperty();
                    if (identifierProperty != null && identifierProperty.getName().equals(element)) {
                        property = identifierProperty;
                    } else if (identifierProperty == null && this.getIdentifierMapper() != null) {
                        try {
                            property = identifierProperty = this.getProperty(element, this.getIdentifierMapper().getProperties());
                        }
                        catch (MappingException mappingException) {
                            // empty catch block
                        }
                    }
                    if (property != null) continue;
                    property = this.getProperty(element, iter);
                    continue;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            throw new MappingException("property [" + propertyPath + "] not found on entity [" + this.getEntityName() + "]");
        }
        return property;
    }

    private Property getProperty(String propertyName, List<Property> properties) throws MappingException {
        String root = StringHelper.root(propertyName);
        for (Property prop : properties) {
            if (!prop.getName().equals(root) && (!(prop instanceof Backref) && !(prop instanceof IndexBackref) || !prop.getName().equals(propertyName))) continue;
            return prop;
        }
        throw new MappingException("property [" + propertyName + "] not found on entity [" + this.getEntityName() + "]");
    }

    public Property getProperty(String propertyName) throws MappingException {
        Property identifierProperty = this.getIdentifierProperty();
        if (identifierProperty != null && identifierProperty.getName().equals(StringHelper.root(propertyName))) {
            return identifierProperty;
        }
        List<Property> closure = this.getPropertyClosure();
        Component identifierMapper = this.getIdentifierMapper();
        if (identifierMapper != null) {
            closure = new JoinedList<Property>(identifierMapper.getProperties(), closure);
        }
        return this.getProperty(propertyName, closure);
    }

    public Property getSubclassProperty(String propertyName) throws MappingException {
        Property identifierProperty = this.getIdentifierProperty();
        if (identifierProperty != null && identifierProperty.getName().equals(StringHelper.root(propertyName))) {
            return identifierProperty;
        }
        List<Property> closure = this.getSubclassPropertyClosure();
        Component identifierMapper = this.getIdentifierMapper();
        if (identifierMapper != null) {
            closure = new JoinedList<Property>(identifierMapper.getProperties(), closure);
        }
        return this.getProperty(propertyName, closure);
    }

    public boolean hasProperty(String name) {
        Property identifierProperty = this.getIdentifierProperty();
        if (identifierProperty != null && identifierProperty.getName().equals(name)) {
            return true;
        }
        Iterator<Property> itr = this.getPropertyClosureIterator();
        while (itr.hasNext()) {
            Property property = itr.next();
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.getSuperclass() != null && this.getSuperclass().isPropertyDefinedInHierarchy(name);
    }

    public boolean isPropertyDefinedInHierarchy(String name) {
        return this.hasProperty(name) || this.getSuperMappedSuperclass() != null && this.getSuperMappedSuperclass().isPropertyDefinedInHierarchy(name) || this.getSuperclass() != null && this.getSuperclass().isPropertyDefinedInHierarchy(name);
    }

    @Deprecated
    public int getOptimisticLockMode() {
        return this.getOptimisticLockStyle().getOldCode();
    }

    @Deprecated
    public void setOptimisticLockMode(int optimisticLockMode) {
        this.setOptimisticLockStyle(OptimisticLockStyle.interpretOldCode(optimisticLockMode));
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public void setOptimisticLockStyle(OptimisticLockStyle optimisticLockStyle) {
        this.optimisticLockStyle = optimisticLockStyle;
    }

    public void validate(Mapping mapping) throws MappingException {
        for (Property prop : this.getProperties()) {
            if (prop.isValid(mapping)) continue;
            throw new MappingException("property mapping has wrong number of columns: " + StringHelper.qualify(this.getEntityName(), prop.getName()) + " type: " + prop.getType().getName());
        }
        this.checkPropertyDuplication();
        this.checkColumnDuplication();
    }

    private void checkPropertyDuplication() throws MappingException {
        HashSet<String> names = new HashSet<String>();
        for (Property prop : this.getProperties()) {
            if (names.add(prop.getName())) continue;
            throw new MappingException("Duplicate property mapping of " + prop.getName() + " found in " + this.getEntityName());
        }
    }

    public boolean isDiscriminatorValueNotNull() {
        return NOT_NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    public boolean isDiscriminatorValueNull() {
        return NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    @Override
    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public void setMetaAttributes(Map metas) {
        this.metaAttributes = metas;
    }

    @Override
    public MetaAttribute getMetaAttribute(String name) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(name);
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getEntityName() + ")";
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<Join> getJoinClosure() {
        return this.joins;
    }

    @Deprecated(since="6.0")
    public Iterator<Join> getJoinIterator() {
        return this.joins.iterator();
    }

    @Deprecated(since="6.0")
    public Iterator<Join> getJoinClosureIterator() {
        return this.joins.iterator();
    }

    public void addJoin(Join join) {
        this.joins.add(join);
        join.setPersistentClass(this);
    }

    public int getJoinClosureSpan() {
        return this.joins.size();
    }

    public int getPropertyClosureSpan() {
        int span = this.properties.size();
        for (Join join : this.joins) {
            span += join.getPropertySpan();
        }
        return span;
    }

    public int getJoinNumber(Property prop) {
        int result = 1;
        for (Join join : this.getSubclassJoinClosure()) {
            if (join.containsProperty(prop)) {
                return result;
            }
            ++result;
        }
        return 0;
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getPropertyIterator() {
        ArrayList iterators = new ArrayList();
        iterators.add(this.properties.iterator());
        for (Join join : this.joins) {
            iterators.add(join.getPropertyIterator());
        }
        return new JoinedIterator<Property>(iterators);
    }

    public List<Property> getProperties() {
        ArrayList<List<List<Property>>> list = new ArrayList<List<List<Property>>>();
        list.add(this.properties);
        for (Join join : this.joins) {
            list.add(join.getProperties());
        }
        return new JoinedList<Property>((List<List<Property>>)list);
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getUnjoinedPropertyIterator() {
        return this.properties.iterator();
    }

    public List<Property> getUnjoinedProperties() {
        return this.properties;
    }

    public void setCustomSqlInsert(CustomSql customSql) {
        if (customSql != null) {
            this.setCustomSQLInsert(customSql.getSql(), customSql.isCallable(), customSql.getCheckStyle());
        }
    }

    public void setCustomSQLInsert(String customSQLInsert, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLInsert = customSQLInsert;
        this.customInsertCallable = callable;
        this.insertCheckStyle = checkStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSqlUpdate(CustomSql customSql) {
        if (customSql != null) {
            this.setCustomSQLUpdate(customSql.getSql(), customSql.isCallable(), customSql.getCheckStyle());
        }
    }

    public void setCustomSQLUpdate(String customSQLUpdate, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLUpdate = customSQLUpdate;
        this.customUpdateCallable = callable;
        this.updateCheckStyle = checkStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSqlDelete(CustomSql customSql) {
        if (customSql != null) {
            this.setCustomSQLDelete(customSql.getSql(), customSql.isCallable(), customSql.getCheckStyle());
        }
    }

    public void setCustomSQLDelete(String customSQLDelete, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLDelete = customSQLDelete;
        this.customDeleteCallable = callable;
        this.deleteCheckStyle = checkStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    @Override
    public void addFilter(String name, String condition, boolean autoAliasInjection, Map<String, String> aliasTableMap, Map<String, String> aliasEntityMap) {
        this.filters.add(new FilterConfiguration(name, condition, autoAliasInjection, aliasTableMap, aliasEntityMap, this));
    }

    @Override
    public List<FilterConfiguration> getFilters() {
        return this.filters;
    }

    public boolean isForceDiscriminator() {
        return false;
    }

    public abstract boolean isJoinedSubclass();

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName == null ? null : loaderName.intern();
    }

    public abstract Set<String> getSynchronizedTables();

    public void addSynchronizedTable(String table) {
        this.synchronizedTables.add(table);
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    protected void checkColumnDuplication(Set<String> distinctColumns, Value value) throws MappingException {
        if (value == null) {
            return;
        }
        for (Selectable columnOrFormula : value.getSelectables()) {
            Column col;
            if (columnOrFormula.isFormula() || distinctColumns.add((col = (Column)columnOrFormula).getName())) continue;
            throw new MappingException("Repeated column in mapping for entity: " + this.getEntityName() + " column: " + col.getName() + " (should be mapped with insert=\"false\" update=\"false\")");
        }
    }

    protected void checkPropertyColumnDuplication(Set<String> distinctColumns, List<Property> properties) throws MappingException {
        for (Property prop : properties) {
            if (prop.getValue() instanceof Component) {
                Component component = (Component)prop.getValue();
                this.checkPropertyColumnDuplication(distinctColumns, component.getProperties());
                continue;
            }
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            this.checkColumnDuplication(distinctColumns, prop.getValue());
        }
    }

    @Deprecated(since="6.0")
    protected Iterator<Property> getNonDuplicatedPropertyIterator() {
        return this.getUnjoinedPropertyIterator();
    }

    protected List<Property> getNonDuplicatedProperties() {
        return this.getUnjoinedProperties();
    }

    @Deprecated(since="6.0")
    protected Iterator<Selectable> getDiscriminatorColumnIterator() {
        return Collections.emptyIterator();
    }

    protected void checkColumnDuplication() {
        HashSet<String> cols = new HashSet<String>();
        if (this.getIdentifierMapper() == null) {
            this.checkColumnDuplication(cols, this.getKey());
        }
        this.checkColumnDuplication(cols, this.getDiscriminator());
        this.checkPropertyColumnDuplication(cols, this.getNonDuplicatedProperties());
        for (Join join : this.getJoins()) {
            cols.clear();
            this.checkColumnDuplication(cols, join.getKey());
            this.checkPropertyColumnDuplication(cols, join.getProperties());
        }
    }

    public abstract Object accept(PersistentClassVisitor var1);

    public String getJpaEntityName() {
        return this.jpaEntityName;
    }

    public void setJpaEntityName(String jpaEntityName) {
        this.jpaEntityName = jpaEntityName;
    }

    public boolean hasPojoRepresentation() {
        return this.getClassName() != null;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    public void setSubselectLoadableCollections(boolean hasSubselectCollections) {
        this.hasSubselectLoadableCollections = hasSubselectCollections;
    }

    public Component getIdentifierMapper() {
        return this.identifierMapper;
    }

    public Component getDeclaredIdentifierMapper() {
        return this.declaredIdentifierMapper;
    }

    public void setDeclaredIdentifierMapper(Component declaredIdentifierMapper) {
        this.declaredIdentifierMapper = declaredIdentifierMapper;
    }

    public boolean hasIdentifierMapper() {
        return this.identifierMapper != null;
    }

    public void addCallbackDefinitions(List<CallbackDefinition> callbackDefinitions) {
        if (callbackDefinitions == null || callbackDefinitions.isEmpty()) {
            return;
        }
        if (this.callbackDefinitions == null) {
            this.callbackDefinitions = new ArrayList<CallbackDefinition>();
        }
        this.callbackDefinitions.addAll(callbackDefinitions);
    }

    public List<CallbackDefinition> getCallbackDefinitions() {
        if (this.callbackDefinitions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.callbackDefinitions);
    }

    public void setIdentifierMapper(Component handle) {
        this.identifierMapper = handle;
    }

    public String getTuplizerImplClassName(RepresentationMode mode) {
        return null;
    }

    public Map getTuplizerMap() {
        return null;
    }

    public boolean hasNaturalId() {
        if (this.hasNaturalId == null) {
            this.hasNaturalId = this.determineIfNaturalIdDefined();
        }
        return this.hasNaturalId;
    }

    private boolean determineIfNaturalIdDefined() {
        Iterator<Property> props = this.getRootClass().getPropertyIterator();
        while (props.hasNext()) {
            if (!props.next().isNaturalIdentifier()) continue;
            return true;
        }
        return false;
    }

    public List<Property> getDeclaredProperties() {
        ArrayList<List<List<Property>>> lists = new ArrayList<List<List<Property>>>();
        lists.add(this.declaredProperties);
        for (Join join : this.joins) {
            lists.add(join.getDeclaredProperties());
        }
        return new JoinedList<Property>((List<List<Property>>)lists);
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getDeclaredPropertyIterator() {
        ArrayList iterators = new ArrayList();
        iterators.add(this.declaredProperties.iterator());
        for (Join join : this.joins) {
            iterators.add(join.getDeclaredPropertyIterator());
        }
        return new JoinedIterator<Property>(iterators);
    }

    public void addMappedsuperclassProperty(Property p) {
        this.properties.add(p);
        p.setPersistentClass(this);
    }

    public MappedSuperclass getSuperMappedSuperclass() {
        return this.superMappedSuperclass;
    }

    public void setSuperMappedSuperclass(MappedSuperclass superMappedSuperclass) {
        this.superMappedSuperclass = superMappedSuperclass;
    }

    public void prepareForMappingModel() {
        this.properties.sort(Comparator.comparing(Property::getName));
    }
}

