/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.function.Supplier;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;

public class EmbeddableInstantiatorProxied
implements StandardEmbeddableInstantiator {
    private final Supplier<EmbeddableMappingType> embeddableMappingAccess;
    private final Class<?> proxiedClass;
    private final BasicProxyFactory factory;

    public EmbeddableInstantiatorProxied(Class proxiedClass, Supplier<EmbeddableMappingType> embeddableMappingAccess, BasicProxyFactory factory) {
        this.proxiedClass = proxiedClass;
        this.embeddableMappingAccess = embeddableMappingAccess;
        this.factory = factory;
    }

    @Override
    public Object instantiate(Supplier<Object[]> valuesAccess, SessionFactoryImplementor sessionFactory) {
        Object proxy = this.factory.getProxy();
        if (valuesAccess != null) {
            EmbeddableMappingType embeddableMapping = this.embeddableMappingAccess.get();
            embeddableMapping.setValues(proxy, valuesAccess.get());
        }
        return proxy;
    }

    @Override
    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        return this.proxiedClass.isInstance(object);
    }

    @Override
    public boolean isSameClass(Object object, SessionFactoryImplementor sessionFactory) {
        return object.getClass() == this.proxiedClass;
    }
}

