/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class MappingModelHelper {
    public static Expression buildColumnReferenceExpression(ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        return MappingModelHelper.buildColumnReferenceExpression(null, modelPart, sqlExpressionResolver, sessionFactory);
    }

    public static Expression buildColumnReferenceExpression(TableGroup tableGroup, ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        if (modelPart instanceof EmbeddableValuedModelPart) {
            ArrayList columnReferences = new ArrayList(jdbcTypeCount);
            modelPart.forEachSelectable((columnIndex, selection) -> {
                String qualifier = tableGroup == null ? selection.getContainingTableExpression() : tableGroup.resolveTableReference(selection.getContainingTableExpression()).getIdentificationVariable();
                ColumnReference colRef = sqlExpressionResolver == null ? new ColumnReference(qualifier, selection, sessionFactory) : (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(qualifier, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(qualifier, selection, sessionFactory));
                columnReferences.add(colRef);
            });
            return new SqlTuple(columnReferences, modelPart);
        }
        assert (modelPart instanceof BasicValuedModelPart);
        BasicValuedModelPart basicPart = (BasicValuedModelPart)modelPart;
        String qualifier = tableGroup == null ? basicPart.getContainingTableExpression() : tableGroup.resolveTableReference(basicPart.getContainingTableExpression()).getIdentificationVariable();
        if (sqlExpressionResolver == null) {
            return new ColumnReference(qualifier, (SelectableMapping)basicPart, sessionFactory);
        }
        return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(qualifier, basicPart.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(qualifier, (SelectableMapping)basicPart, sessionFactory));
    }

    private MappingModelHelper() {
    }
}

