/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractDiscriminatorMapping
implements EntityDiscriminatorMapping {
    private final NavigableRole role;
    private final JdbcMapping jdbcMapping;
    private final EntityPersister entityDescriptor;
    private final DiscriminatorType<?> discriminatorType;
    private final SessionFactoryImplementor sessionFactory;
    private final DomainResultConverter<?> domainResultConverter;

    public AbstractDiscriminatorMapping(JdbcMapping jdbcMapping, EntityPersister entityDescriptor, DiscriminatorType<?> discriminatorType, MappingModelCreationProcess creationProcess) {
        this.jdbcMapping = jdbcMapping;
        this.entityDescriptor = entityDescriptor;
        this.discriminatorType = discriminatorType;
        this.role = entityDescriptor.getNavigableRole().append("{discriminator}");
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        this.domainResultConverter = DomainResultConverter.create(entityDescriptor, this::getConcreteEntityNameForDiscriminatorValue, discriminatorType.getUnderlyingType(), this.sessionFactory);
    }

    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public BasicType<?> getUnderlyingJdbcMappingType() {
        return this.discriminatorType.getUnderlyingType();
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.role;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public String getConcreteEntityNameForDiscriminatorValue(Object value) {
        return this.getEntityDescriptor().getSubclassForDiscriminatorValue(value);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.entityDescriptor;
    }

    @Override
    public MappingType getMappedType() {
        return this.getJdbcMapping();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, this.getUnderlyingJdbcMappingType(), tableGroup, creationState.getSqlAstCreationState());
        return new BasicResult<Object>(sqlSelection.getValuesArrayPosition(), resultVariable, this.domainResultConverter.getDomainJavaType(), this.domainResultConverter, navigablePath);
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        return expressionResolver.resolveSqlSelection(this.resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, creationState), jdbcMappingToUse.getJavaTypeDescriptor(), creationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public BasicFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, this.getUnderlyingJdbcMappingType(), tableGroup, creationState.getSqlAstCreationState());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, null, fetchTiming, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, this.getUnderlyingJdbcMappingType(), tableGroup, creationState.getSqlAstCreationState());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, this.getUnderlyingJdbcMappingType(), tableGroup, creationState.getSqlAstCreationState()), this.getJdbcMapping());
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, this.convertToRelational(value), this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(this.convertToRelational(domainValue), this);
    }

    private Object convertToRelational(Object domainValue) {
        if (this.domainResultConverter != null) {
            return this.domainResultConverter.toRelationalValue(domainValue);
        }
        return domainValue;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.convertToRelational(value);
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, this.convertToRelational(value), this.jdbcMapping);
        return 1;
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return EntityDiscriminatorMapping.super.forEachSelectable(consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return EntityDiscriminatorMapping.super.forEachSelectable(offset, consumer);
    }

    @Override
    public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        return EntityDiscriminatorMapping.super.forEachJdbcType(action);
    }

    protected static class DomainResultConverter<R>
    implements BasicValueConverter<Object, R> {
        private final Function<R, String> subtypeResolver;
        private final Function<String, Object> entityNameHandler;
        private final Function<Object, R> toRelationalConverter;
        private final JavaType<Object> domainJtd;
        private final JavaType<R> relationalJtd;

        public DomainResultConverter(Function<R, String> subtypeResolver, Function<String, Object> entityNameHandler, Function<Object, R> toRelationalConverter, JavaType<Object> domainJtd, JavaType<R> relationalJtd) {
            this.subtypeResolver = subtypeResolver;
            this.entityNameHandler = entityNameHandler;
            this.toRelationalConverter = toRelationalConverter;
            this.domainJtd = domainJtd;
            this.relationalJtd = relationalJtd;
        }

        private static <R> DomainResultConverter<R> create(EntityPersister entityDescriptor, Function<R, String> subtypeResolver, BasicType underlyingDiscriminatorType, SessionFactoryImplementor sessionFactory) {
            Function<Object, Object> toRelationalConverter;
            Function<String, Object> entityNameHandler;
            JavaType<Object> domainJtd;
            TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
            JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
            if (entityDescriptor.getRepresentationStrategy().getMode() == RepresentationMode.MAP) {
                domainJtd = jtdRegistry.getDescriptor((Type)((Object)String.class));
                entityNameHandler = entityName -> entityName;
                toRelationalConverter = domainValue -> {
                    String stringValue;
                    if (domainValue instanceof Class) {
                        throw new IllegalArgumentException("Illegal attempt to specify Class for discriminator for dynamic entity");
                    }
                    if (domainValue instanceof String && entityDescriptor.isSubclassEntityName(stringValue = (String)domainValue)) {
                        return entityDescriptor.getDiscriminatorValue();
                    }
                    assert (underlyingDiscriminatorType.getJavaTypeDescriptor().getJavaTypeClass().isInstance(domainJtd));
                    return domainJtd;
                };
            } else {
                ClassLoaderService cls = sessionFactory.getServiceRegistry().getService(ClassLoaderService.class);
                domainJtd = jtdRegistry.getDescriptor((Type)((Object)Class.class));
                entityNameHandler = cls::classForName;
                toRelationalConverter = domainValue -> {
                    String stringValue;
                    if (domainValue instanceof Class) {
                        Class classValue = (Class)domainValue;
                        EntityMappingType concreteEntityMapping = sessionFactory.getRuntimeMetamodels().getEntityMappingType(classValue);
                        return concreteEntityMapping.getDiscriminatorValue();
                    }
                    if (domainValue instanceof String && entityDescriptor.isSubclassEntityName(stringValue = (String)domainValue)) {
                        return entityDescriptor.getDiscriminatorValue();
                    }
                    assert (underlyingDiscriminatorType.getJavaTypeDescriptor().getJavaTypeClass().isInstance(domainJtd));
                    return domainJtd;
                };
            }
            return new DomainResultConverter<Object>(subtypeResolver, entityNameHandler, toRelationalConverter, domainJtd, underlyingDiscriminatorType.getJavaTypeDescriptor());
        }

        @Override
        public Object toDomainValue(R relationalForm) {
            String entityName = this.subtypeResolver.apply(relationalForm);
            return this.entityNameHandler.apply(entityName);
        }

        @Override
        public R toRelationalValue(Object domainForm) {
            return this.toRelationalConverter.apply(domainForm);
        }

        @Override
        public JavaType<Object> getDomainJavaType() {
            return this.domainJtd;
        }

        @Override
        public JavaType<R> getRelationalJavaType() {
            return this.relationalJtd;
        }
    }
}

