/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityCollectionPart
implements CollectionPart,
EntityAssociationMapping,
EntityValuedFetchable,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final EntityMappingType entityMappingType;
    private final Set<String> targetKeyPropertyNames;
    private ModelPart fkTargetModelPart;
    private ForeignKeyDescriptor fkDescriptor;

    public EntityCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, Value bootModelValue, EntityMappingType entityMappingType, MappingModelCreationProcess creationProcess) {
        HashSet<String> targetKeyPropertyNames;
        String mappedByProperty;
        this.navigableRole = collectionDescriptor.getNavigableRole().appendContainer(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.entityMappingType = entityMappingType;
        String referencedPropertyName = bootModelValue instanceof OneToMany ? ((mappedByProperty = collectionDescriptor.getMappedByProperty()) == null || mappedByProperty.isEmpty() ? null : mappedByProperty) : ((ToOne)bootModelValue).getReferencedPropertyName();
        if (referencedPropertyName == null) {
            targetKeyPropertyNames = new HashSet<String>(2);
            targetKeyPropertyNames.add("{id}");
            IdentifierProperty identifierProperty = this.getEntityMappingType().getEntityPersister().getEntityMetamodel().getIdentifierProperty();
            Type propertyType = identifierProperty.getType();
            if (identifierProperty.getName() == null) {
                CompositeType compositeType;
                if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, compositeType.getPropertyNames()[0], compositeType.getSubtypes()[0], creationProcess.getCreationContext().getSessionFactory());
                } else {
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, null, propertyType, creationProcess.getCreationContext().getSessionFactory());
                }
            } else {
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, identifierProperty.getName(), propertyType, creationProcess.getCreationContext().getSessionFactory());
            }
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else if (bootModelValue instanceof OneToMany) {
            targetKeyPropertyNames = new HashSet(2);
            int dotIndex = -1;
            while ((dotIndex = referencedPropertyName.indexOf(46, dotIndex + 1)) != -1) {
                targetKeyPropertyNames.add(referencedPropertyName.substring(0, dotIndex));
            }
            Type propertyType = ((PropertyMapping)((Object)entityMappingType.getEntityPersister())).toType(referencedPropertyName);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, referencedPropertyName, propertyType, creationProcess.getCreationContext().getSessionFactory());
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else {
            CompositeType compositeType;
            EntityMetamodel entityMetamodel = entityMappingType.getEntityPersister().getEntityMetamodel();
            int propertyIndex = entityMetamodel.getPropertyIndex(referencedPropertyName);
            Type propertyType = entityMetamodel.getPropertyTypes()[propertyIndex];
            if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                HashSet<String> targetKeyPropertyNames2 = new HashSet<String>(2);
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames2, compositeType.getPropertyNames()[0], compositeType.getSubtypes()[0], creationProcess.getCreationContext().getSessionFactory());
                this.targetKeyPropertyNames = targetKeyPropertyNames2;
            } else {
                String mapsIdAttributeName = ToOneAttributeMapping.findMapsIdPropertyName(entityMappingType, referencedPropertyName);
                if (mapsIdAttributeName != null) {
                    HashSet<String> targetKeyPropertyNames3 = new HashSet<String>(2);
                    targetKeyPropertyNames3.add(referencedPropertyName);
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames3, mapsIdAttributeName, entityMappingType.getEntityPersister().getIdentifierType(), creationProcess.getCreationContext().getSessionFactory());
                    this.targetKeyPropertyNames = targetKeyPropertyNames3;
                } else {
                    this.targetKeyPropertyNames = Collections.singleton(referencedPropertyName);
                }
            }
        }
    }

    public void finishInitialization(CollectionPersister collectionDescriptor, Collection bootValueMapping, String fkTargetModelPartName, MappingModelCreationProcess creationProcess) {
        if (fkTargetModelPartName == null) {
            if (this.nature == CollectionPart.Nature.INDEX) {
                String mapKeyPropertyName = ((Map)bootValueMapping).getMapKeyPropertyName();
                if (mapKeyPropertyName == null) {
                    this.fkTargetModelPart = this.entityMappingType.getIdentifierMapping();
                } else {
                    EntityPersister elementPersister = ((EntityType)collectionDescriptor.getElementType()).getAssociatedEntityPersister(creationProcess.getCreationContext().getSessionFactory());
                    this.fkTargetModelPart = elementPersister.findByPath(mapKeyPropertyName);
                    if (this.fkTargetModelPart == null) {
                        throw new RuntimeException("Couldn't find model part for path [" + mapKeyPropertyName + "] on entity: " + elementPersister.getEntityName());
                    }
                }
            } else {
                String mappedByProperty = bootValueMapping.getMappedByProperty();
                if (collectionDescriptor.isOneToMany() && mappedByProperty != null && !mappedByProperty.isEmpty()) {
                    this.fkTargetModelPart = this.entityMappingType.findByPath(mappedByProperty);
                    if (this.fkTargetModelPart == null) {
                        throw new RuntimeException("Couldn't find model part for path [" + mappedByProperty + "] on entity: " + this.entityMappingType.getEntityName());
                    }
                } else {
                    this.fkTargetModelPart = this.entityMappingType.getIdentifierMapping();
                }
            }
        } else {
            this.fkTargetModelPart = this.entityMappingType.findSubPart(fkTargetModelPartName, null);
        }
        this.fkDescriptor = this.nature == CollectionPart.Nature.ELEMENT ? this.createForeignKeyDescriptor(bootValueMapping.getElement(), (EntityType)collectionDescriptor.getElementType(), creationProcess, collectionDescriptor.getFactory().getJdbcServices().getDialect()) : this.createForeignKeyDescriptor(((IndexedCollection)bootValueMapping).getIndex(), (EntityType)collectionDescriptor.getIndexType(), creationProcess, collectionDescriptor.getFactory().getJdbcServices().getDialect());
    }

    private ForeignKeyDescriptor createForeignKeyDescriptor(Value fkBootDescriptorSource, EntityType entityType, MappingModelCreationProcess creationProcess, Dialect dialect) {
        String indexPropertyName;
        EntityPersister associatedEntityDescriptor = creationProcess.getEntityPersister(entityType.getAssociatedEntityName());
        if (this.fkTargetModelPart instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)this.fkTargetModelPart;
            if (toOneAttributeMapping.getForeignKeyDescriptor() == null) {
                throw new RuntimeException("Not yet ready: " + toOneAttributeMapping);
            }
            return toOneAttributeMapping.getForeignKeyDescriptor();
        }
        ModelPart fkTargetPart = this.fkTargetModelPart;
        String fkKeyTableName = this.nature == CollectionPart.Nature.INDEX ? ((indexPropertyName = this.collectionDescriptor.getAttributeMapping().getIndexMetadata().getIndexPropertyName()) == null ? ((Joinable)((Object)this.collectionDescriptor)).getTableName() : fkBootDescriptorSource.getTable().getQuotedName(dialect)) : ((Joinable)((Object)this.collectionDescriptor)).getTableName();
        if (fkTargetPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicFkTargetPart = (BasicValuedModelPart)fkTargetPart;
            SelectableMapping keySelectableMapping = SelectableMappingImpl.from(fkKeyTableName, fkBootDescriptorSource.getSelectables().get(0), basicFkTargetPart.getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            boolean hasConstraint = fkBootDescriptorSource instanceof SimpleValue ? ((SimpleValue)fkBootDescriptorSource).isConstrained() : !fkBootDescriptorSource.isNullable();
            return new SimpleForeignKeyDescriptor(associatedEntityDescriptor, basicFkTargetPart, null, keySelectableMapping, basicFkTargetPart, entityType.isReferenceToPrimaryKey(), hasConstraint);
        }
        if (fkTargetPart instanceof EmbeddableValuedModelPart) {
            return MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTargetPart, fkBootDescriptorSource, this.findContainingEntityMapping(), this.collectionDescriptor.getAttributeMapping(), false, dialect, creationProcess);
        }
        throw new NotYetImplementedFor6Exception("Support for composite foreign keys not yet implemented : " + this.collectionDescriptor.getRole());
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.INNER;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return this.fkDescriptor.isSimpleJoinPredicate(predicate);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.collectionDescriptor.isOneToMany() ? this.entityMappingType.getIdentifierMapping() : this.fkTargetModelPart;
    }

    @Override
    public <T> DomainResult<T> createDelayedDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getEntityMappingType().getJavaType();
    }

    public JavaType<?> getExpressibleJavaType() {
        return this.getJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public ModelPart findSubPart(String name) {
        return this.findSubPart(name, null);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType targetType) {
        if (!this.collectionDescriptor.isOneToMany() && this.targetKeyPropertyNames.contains(name)) {
            if (this.fkTargetModelPart instanceof ToOneAttributeMapping) {
                return this.fkTargetModelPart;
            }
            ModelPart keyPart = this.fkDescriptor.getKeyPart();
            if (keyPart instanceof EmbeddableValuedModelPart && keyPart instanceof VirtualModelPart) {
                return ((ModelPartContainer)keyPart).findSubPart(name, targetType);
            }
            return keyPart;
        }
        return EntityValuedFetchable.super.findSubPart(name, targetType);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isUnwrapProxy() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup partTableGroup = this.resolveTableGroup(navigablePath, creationState);
        return this.entityMappingType.createDomainResult(navigablePath, partTableGroup, resultVariable, creationState);
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        boolean added = creationState.registerVisitedAssociationKey(this.getForeignKeyDescriptor().getAssociationKey());
        TableGroup partTableGroup = this.resolveTableGroup(fetchablePath, creationState);
        EntityFetchJoinedImpl fetch = new EntityFetchJoinedImpl(fetchParent, this, partTableGroup, selected, fetchablePath, creationState);
        if (added) {
            creationState.removeVisitedAssociationKey(this.getForeignKeyDescriptor().getAssociationKey());
        }
        return fetch;
    }

    private TableGroup resolveTableGroup(NavigablePath fetchablePath, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        return fromClauseAccess.resolveTableGroup(fetchablePath, (NavigablePath np) -> {
            PluralTableGroup parentTableGroup = (PluralTableGroup)fromClauseAccess.getTableGroup(np.getParent());
            switch (this.nature) {
                case ELEMENT: {
                    return parentTableGroup.getElementTableGroup();
                }
                case INDEX: {
                    return parentTableGroup.getIndexTableGroup();
                }
            }
            throw new IllegalStateException("Could not find table group for: " + np);
        });
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.entityMappingType.forEachSelectable(offset, consumer);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.fkTargetModelPart.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.entityMappingType.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.entityMappingType.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.entityMappingType.getNumberOfFetchables();
    }

    public String getMappedBy() {
        return this.collectionDescriptor.getMappedByProperty();
    }

    public String toString() {
        return "EntityCollectionPart(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.fkDescriptor;
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return ForeignKeyDescriptor.Nature.TARGET;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup collectionTableGroup, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        if (this.collectionDescriptor.isOneToMany() && this.nature == CollectionPart.Nature.ELEMENT) {
            return new TableGroupJoin(navigablePath, sqlAstJoinType, ((OneToManyTableGroup)collectionTableGroup).getElementTableGroup(), null);
        }
        TableGroup lazyTableGroup = this.createRootTableGroupJoin(navigablePath, collectionTableGroup, explicitSourceAlias, sqlAstJoinType, fetched, (Consumer)null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        TableGroupJoin join = new TableGroupJoin(navigablePath, sqlAstJoinType, lazyTableGroup, null);
        ((LazyTableGroup)lazyTableGroup).setTableGroupInitializerCallback(tableGroup -> join.applyPredicate(this.fkDescriptor.generateJoinPredicate(tableGroup.getPrimaryTableReference(), collectionTableGroup.resolveTableReference(this.fkDescriptor.getKeyTable()), sqlAstJoinType, sqlExpressionResolver, creationContext)));
        return join;
    }

    @Override
    public LazyTableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem());
        boolean canUseInnerJoin = sqlAstJoinType == SqlAstJoinType.INNER || lhs.canUseInnerJoins();
        LazyTableGroup lazyTableGroup = new LazyTableGroup(canUseInnerJoin, navigablePath, fetched, () -> this.createTableGroupInternal(canUseInnerJoin, navigablePath, fetched, null, sqlAliasBase, sqlExpressionResolver, creationContext), (np, tableExpression) -> {
            NavigablePath path = np.getParent();
            if (path != null && navigablePath.equals(path)) {
                return this.targetKeyPropertyNames.contains(np.getUnaliasedLocalName()) && this.fkDescriptor.getKeyTable().equals(tableExpression);
            }
            StringBuilder sb = new StringBuilder(np.getFullPath().length());
            sb.append(np.getUnaliasedLocalName());
            while (path != null && !navigablePath.equals(path)) {
                sb.insert(0, '.');
                sb.insert(0, path.getUnaliasedLocalName());
                path = path.getParent();
            }
            return path != null && navigablePath.equals(path) && this.targetKeyPropertyNames.contains(sb.toString()) && this.fkDescriptor.getKeyTable().equals(tableExpression);
        }, this, explicitSourceAlias, sqlAliasBase, creationContext.getSessionFactory(), lhs);
        if (predicateConsumer != null) {
            TableReference keySideTableReference = lhs.resolveTableReference(navigablePath, this.fkDescriptor.getKeyTable());
            lazyTableGroup.setTableGroupInitializerCallback(tableGroup -> predicateConsumer.accept(this.fkDescriptor.generateJoinPredicate(tableGroup.getPrimaryTableReference(), keySideTableReference, sqlAstJoinType, sqlExpressionResolver, creationContext)));
        }
        return lazyTableGroup;
    }

    public TableGroup createTableGroupInternal(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, tableExpression -> this.getEntityMappingType().containsTableReference((String)tableExpression), (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
    }

    @Override
    public String getSqlAliasStem() {
        return this.collectionDescriptor.getAttributeMapping().getSqlAliasStem();
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return this.collectionDescriptor.getAttributeMapping().containsTableReference(tableExpression);
    }
}

