/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;

public class EntityVersionMappingImpl
implements EntityVersionMapping,
FetchOptions {
    private final String attributeName;
    private final EntityMappingType declaringType;
    private final String columnTableExpression;
    private final String columnExpression;
    private final BasicType versionBasicType;
    private final VersionValue unsavedValueStrategy;
    private BasicAttributeMapping attributeMapping;

    public EntityVersionMappingImpl(RootClass bootEntityDescriptor, Supplier<?> templateInstanceAccess, String attributeName, String columnTableExpression, String columnExpression, BasicType<?> versionBasicType, EntityMappingType declaringType, MappingModelCreationProcess creationProcess) {
        this.attributeName = attributeName;
        this.declaringType = declaringType;
        this.columnTableExpression = columnTableExpression;
        this.columnExpression = columnExpression;
        this.versionBasicType = versionBasicType;
        this.unsavedValueStrategy = UnsavedValueFactory.getUnsavedVersionValue((KeyValue)bootEntityDescriptor.getVersion().getValue(), (VersionJavaType)versionBasicType.getJavaTypeDescriptor(), declaringType.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getVersion()).getGetter(), templateInstanceAccess);
    }

    @Override
    public BasicAttributeMapping getVersionAttribute() {
        return (BasicAttributeMapping)this.declaringType.findAttributeMapping(this.attributeName);
    }

    @Override
    public VersionValue getUnsavedStrategy() {
        return this.unsavedValueStrategy;
    }

    @Override
    public String getContainingTableExpression() {
        return this.columnTableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnExpression;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.versionBasicType;
    }

    @Override
    public MappingType getMappedType() {
        return this.versionBasicType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.versionBasicType.getJdbcMapping();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.versionBasicType.getJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.attributeName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getVersionAttribute().getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }

    @Override
    public String getFetchableName() {
        return this.attributeName;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(fetchablePath, this.columnTableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnTableReference, this.columnExpression), sqlAstProcessingState -> new ColumnReference(columnTableReference, this.columnExpression, false, null, null, (JdbcMapping)this.versionBasicType, sqlAstCreationState.getCreationContext().getSessionFactory())), this.versionBasicType.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, null, fetchTiming, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaType(), navigablePath);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(tableGroup, creationState), this.getJdbcMapping());
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    private SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName()), this.columnTableExpression);
        return sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnTableReference, this.columnExpression), sqlAstProcessingState -> new ColumnReference(columnTableReference, this.columnExpression, false, null, null, (JdbcMapping)this.versionBasicType, sqlAstCreationState.getCreationContext().getSessionFactory())), this.versionBasicType.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.versionBasicType.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.versionBasicType.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }
}

