/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.AbstractDomainType;
import org.hibernate.metamodel.model.domain.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SetPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.DomainModelHelper;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractManagedType<J>
extends AbstractDomainType<J>
implements ManagedDomainType<J>,
AttributeContainer<J>,
Serializable {
    private final String hibernateTypeName;
    private final ManagedDomainType<? super J> superType;
    private final RepresentationMode representationMode;
    private final Map<String, SingularPersistentAttribute<J, ?>> declaredSingularAttributes = new LinkedHashMap();
    private volatile Map<String, PluralPersistentAttribute<J, ?, ?>> declaredPluralAttributes;
    private final List<ManagedDomainType> subTypes = new ArrayList<ManagedDomainType>();
    private transient AttributeContainer.InFlightAccess<J> inFlightAccess;

    protected AbstractManagedType(String hibernateTypeName, JavaType<J> javaType, ManagedDomainType<? super J> superType, JpaMetamodel domainMetamodel) {
        super(javaType, domainMetamodel);
        this.hibernateTypeName = hibernateTypeName;
        this.superType = superType;
        if (superType != null) {
            superType.addSubType(this);
        }
        this.representationMode = RepresentationMode.POJO;
        this.inFlightAccess = this.createInFlightAccess();
    }

    protected AttributeContainer.InFlightAccess<J> createInFlightAccess() {
        return new InFlightAccessImpl();
    }

    @Override
    public ManagedDomainType<? super J> getSuperType() {
        return this.superType;
    }

    @Override
    public void addSubType(ManagedDomainType subType) {
        this.subTypes.add(subType);
    }

    @Override
    public RepresentationMode getRepresentationMode() {
        return this.representationMode;
    }

    @Override
    public void visitAttributes(Consumer<? super PersistentAttribute<J, ?>> action) {
        this.visitDeclaredAttributes(action);
        if (this.getSuperType() != null) {
            this.getSuperType().visitAttributes(action);
        }
    }

    @Override
    public void visitDeclaredAttributes(Consumer<? super PersistentAttribute<J, ?>> action) {
        this.declaredSingularAttributes.values().forEach(action);
        if (this.declaredPluralAttributes != null) {
            this.declaredPluralAttributes.values().forEach(action);
        }
    }

    @Override
    public Set<Attribute<? super J, ?>> getAttributes() {
        LinkedHashSet attributes = new LinkedHashSet(this.getDeclaredAttributes());
        if (this.getSuperType() != null) {
            attributes.addAll(this.getSuperType().getAttributes());
        }
        return attributes;
    }

    @Override
    public Set<Attribute<J, ?>> getDeclaredAttributes() {
        LinkedHashSet<Attribute<J, ?>> attributes;
        boolean isDeclaredSingularAttributesEmpty = CollectionHelper.isEmpty(this.declaredSingularAttributes);
        boolean isDeclaredPluralAttributes = CollectionHelper.isEmpty(this.declaredPluralAttributes);
        if (isDeclaredSingularAttributesEmpty && isDeclaredPluralAttributes) {
            return Collections.emptySet();
        }
        if (!isDeclaredSingularAttributesEmpty) {
            attributes = new LinkedHashSet(this.declaredSingularAttributes.values());
            if (!isDeclaredPluralAttributes) {
                attributes.addAll(this.declaredPluralAttributes.values());
            }
        } else {
            attributes = new LinkedHashSet(this.declaredPluralAttributes.values());
        }
        return attributes;
    }

    @Override
    public PersistentAttribute<? super J, ?> getAttribute(String name) {
        PersistentAttribute<J, ?> attribute = this.findAttribute(name);
        this.checkNotNull("Attribute", attribute, name);
        return attribute;
    }

    @Override
    public PersistentAttribute<? super J, ?> findAttribute(String name) {
        PersistentAttribute<J, ?> attribute = this.findDeclaredAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (this.getSuperType() != null && (attribute = this.getSuperType().findAttributeInSuperTypes(name)) != null) {
            return attribute;
        }
        for (ManagedDomainType subType : this.subTypes) {
            PersistentAttribute subTypeAttribute = subType.findSubTypesAttribute(name);
            if (subTypeAttribute == null) continue;
            return subTypeAttribute;
        }
        return null;
    }

    @Override
    public PersistentAttribute<? super J, ?> findAttributeInSuperTypes(String name) {
        PersistentAttribute<J, ?> local = this.findDeclaredAttribute(name);
        if (local != null) {
            return local;
        }
        if (this.superType != null) {
            return this.superType.findAttributeInSuperTypes(name);
        }
        return null;
    }

    @Override
    public PersistentAttribute<? super J, ?> findSubTypesAttribute(String name) {
        PersistentAttribute<J, ?> attribute = this.findDeclaredAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        for (ManagedDomainType subType : this.subTypes) {
            PersistentAttribute subTypeAttribute = subType.findAttribute(name);
            if (subTypeAttribute == null) continue;
            return subTypeAttribute;
        }
        return null;
    }

    @Override
    public PersistentAttribute<J, ?> findDeclaredAttribute(String name) {
        PersistentAttribute attribute = this.declaredSingularAttributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        if (this.declaredPluralAttributes == null) {
            return null;
        }
        attribute = this.declaredPluralAttributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    @Override
    public PersistentAttribute<J, ?> getDeclaredAttribute(String name) {
        PersistentAttribute<J, ?> attr = this.findDeclaredAttribute(name);
        this.checkNotNull("Attribute", attr, name);
        return attr;
    }

    private void checkNotNull(String attributeType, Attribute<?, ?> attribute, String name) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Unable to locate %s with the given name [%s] on this ManagedType [%s]", attributeType, name, this.getTypeName()));
        }
    }

    @Override
    public String getTypeName() {
        return this.hibernateTypeName;
    }

    @Override
    public Set<SingularAttribute<? super J, ?>> getSingularAttributes() {
        HashSet attributes = new HashSet(this.declaredSingularAttributes.values());
        if (this.getSuperType() != null) {
            attributes.addAll(this.getSuperType().getSingularAttributes());
        }
        return attributes;
    }

    @Override
    public Set<SingularAttribute<J, ?>> getDeclaredSingularAttributes() {
        return new HashSet(this.declaredSingularAttributes.values());
    }

    @Override
    public SingularPersistentAttribute<? super J, ?> getSingularAttribute(String name) {
        SingularPersistentAttribute<J, ?> attribute = this.findSingularAttribute(name);
        this.checkNotNull("SingularAttribute", attribute, name);
        return attribute;
    }

    @Override
    public SingularPersistentAttribute<? super J, ?> findSingularAttribute(String name) {
        SingularPersistentAttribute<J, ?> attribute = this.findDeclaredSingularAttribute(name);
        if (attribute == null && this.getSuperType() != null) {
            attribute = this.getSuperType().findSingularAttribute(name);
        }
        return attribute;
    }

    @Override
    public <Y> SingularPersistentAttribute<? super J, Y> getSingularAttribute(String name, Class<Y> type) {
        SingularPersistentAttribute<J, ?> attribute = this.findSingularAttribute(name);
        this.checkTypeForSingleAttribute(attribute, name, type);
        return attribute;
    }

    @Override
    public SingularAttribute<J, ?> getDeclaredSingularAttribute(String name) {
        SingularPersistentAttribute<J, ?> attr = this.findDeclaredSingularAttribute(name);
        this.checkNotNull("SingularAttribute", attr, name);
        return attr;
    }

    @Override
    public SingularPersistentAttribute<? super J, ?> findDeclaredSingularAttribute(String name) {
        return this.declaredSingularAttributes.get(name);
    }

    @Override
    public <Y> SingularPersistentAttribute<J, Y> getDeclaredSingularAttribute(String name, Class<Y> javaType) {
        SingularPersistentAttribute<J, ?> attr = this.findDeclaredSingularAttribute(name);
        this.checkTypeForSingleAttribute(attr, name, javaType);
        return attr;
    }

    private <Y> void checkTypeForSingleAttribute(SingularAttribute<?, ?> attribute, String name, Class<Y> javaType) {
        if (attribute == null || javaType != null && !attribute.getBindableJavaType().equals(javaType)) {
            if (this.isPrimitiveVariant(attribute, javaType)) {
                return;
            }
            throw new IllegalArgumentException("SingularAttribute named " + name + (String)(javaType != null ? " and of type " + javaType.getName() : "") + " is not present");
        }
    }

    protected <Y> boolean isPrimitiveVariant(SingularAttribute<?, ?> attribute, Class<Y> javaType) {
        if (attribute == null) {
            return false;
        }
        Class declaredType = attribute.getBindableJavaType();
        if (declaredType.isPrimitive()) {
            return Boolean.class.equals(javaType) && Boolean.TYPE.equals(declaredType) || Character.class.equals(javaType) && Character.TYPE.equals(declaredType) || Byte.class.equals(javaType) && Byte.TYPE.equals(declaredType) || Short.class.equals(javaType) && Short.TYPE.equals(declaredType) || Integer.class.equals(javaType) && Integer.TYPE.equals(declaredType) || Long.class.equals(javaType) && Long.TYPE.equals(declaredType) || Float.class.equals(javaType) && Float.TYPE.equals(declaredType) || Double.class.equals(javaType) && Double.TYPE.equals(declaredType);
        }
        if (javaType.isPrimitive()) {
            return Boolean.class.equals(declaredType) && Boolean.TYPE.equals(javaType) || Character.class.equals(declaredType) && Character.TYPE.equals(javaType) || Byte.class.equals(declaredType) && Byte.TYPE.equals(javaType) || Short.class.equals(declaredType) && Short.TYPE.equals(javaType) || Integer.class.equals(declaredType) && Integer.TYPE.equals(javaType) || Long.class.equals(declaredType) && Long.TYPE.equals(javaType) || Float.class.equals(declaredType) && Float.TYPE.equals(javaType) || Double.class.equals(declaredType) && Double.TYPE.equals(javaType);
        }
        return false;
    }

    @Override
    public Set<PluralAttribute<? super J, ?, ?>> getPluralAttributes() {
        HashSet attributes;
        HashSet hashSet = attributes = this.declaredPluralAttributes == null ? new HashSet() : new HashSet(this.declaredPluralAttributes.values());
        if (this.getSuperType() != null) {
            attributes.addAll(this.getSuperType().getPluralAttributes());
        }
        return attributes;
    }

    @Override
    public Set<PluralAttribute<J, ?, ?>> getDeclaredPluralAttributes() {
        return this.declaredPluralAttributes == null ? Collections.EMPTY_SET : new HashSet(this.declaredPluralAttributes.values());
    }

    @Override
    public PluralPersistentAttribute findPluralAttribute(String name) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (this.getSuperType() != null && (attribute = this.getSuperType().findDeclaredPluralAttribute(name)) != null) {
            return attribute;
        }
        return null;
    }

    @Override
    public PluralPersistentAttribute<? super J, ?, ?> findDeclaredPluralAttribute(String name) {
        return this.declaredPluralAttributes == null ? null : this.declaredPluralAttributes.get(name);
    }

    private <E> void checkTypeForPluralAttributes(String attributeType, PluralAttribute<?, ?, ?> attribute, String name, Class<E> elementType, PluralAttribute.CollectionType collectionType) {
        if (attribute == null || elementType != null && !attribute.getBindableJavaType().equals(elementType) || attribute.getCollectionType() != collectionType) {
            throw new IllegalArgumentException(attributeType + " named " + name + (String)(elementType != null ? " and of element type " + elementType : "") + " is not present");
        }
    }

    @Override
    public BagPersistentAttribute<? super J, ?> getCollection(String name) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findPluralAttribute(name);
        if (attribute == null && this.getSuperType() != null) {
            attribute = this.getSuperType().findPluralAttribute(name);
        }
        this.basicCollectionCheck(attribute, name);
        return (BagPersistentAttribute)attribute;
    }

    private void basicCollectionCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("CollectionAttribute", attribute, name);
        if (!BagPersistentAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a CollectionAttribute: " + attribute.getClass());
        }
    }

    @Override
    public CollectionAttribute<J, ?> getDeclaredCollection(String name) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.basicCollectionCheck(attribute, name);
        return (CollectionAttribute)((Object)attribute);
    }

    @Override
    public <E> BagPersistentAttribute<? super J, E> getCollection(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkCollectionElementType(attribute, name, elementType);
        return (BagPersistentAttribute)attribute;
    }

    private <E> void checkCollectionElementType(PluralAttribute<?, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("CollectionAttribute", attribute, name, elementType, PluralAttribute.CollectionType.COLLECTION);
    }

    @Override
    public <E> CollectionAttribute<J, E> getDeclaredCollection(String name, Class<E> elementType) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.checkCollectionElementType(attribute, name, elementType);
        return (CollectionAttribute)((Object)attribute);
    }

    @Override
    public SetPersistentAttribute<? super J, ?> getSet(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.basicSetCheck(attribute, name);
        return (SetPersistentAttribute)attribute;
    }

    private void basicSetCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("SetAttribute", attribute, name);
        if (!SetPersistentAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a SetAttribute: " + attribute.getClass());
        }
    }

    @Override
    public SetPersistentAttribute<J, ?> getDeclaredSet(String name) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.basicSetCheck(attribute, name);
        return (SetPersistentAttribute)attribute;
    }

    @Override
    public <E> SetAttribute<? super J, E> getSet(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkSetElementType(attribute, name, elementType);
        return (SetAttribute)((Object)attribute);
    }

    private <E> void checkSetElementType(PluralAttribute<? super J, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("SetAttribute", attribute, name, elementType, PluralAttribute.CollectionType.SET);
    }

    @Override
    public <E> SetAttribute<J, E> getDeclaredSet(String name, Class<E> elementType) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.checkSetElementType(attribute, name, elementType);
        return (SetAttribute)((Object)attribute);
    }

    @Override
    public ListPersistentAttribute<? super J, ?> getList(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.basicListCheck(attribute, name);
        return (ListPersistentAttribute)attribute;
    }

    private void basicListCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("ListAttribute", attribute, name);
        if (!ListPersistentAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a ListAttribute: " + attribute.getClass());
        }
    }

    @Override
    public ListPersistentAttribute<J, ?> getDeclaredList(String name) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.basicListCheck(attribute, name);
        return (ListPersistentAttribute)attribute;
    }

    @Override
    public <E> ListAttribute<? super J, E> getList(String name, Class<E> elementType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkListElementType(attribute, name, elementType);
        return (ListAttribute)((Object)attribute);
    }

    private <E> void checkListElementType(PluralAttribute<? super J, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("ListAttribute", attribute, name, elementType, PluralAttribute.CollectionType.LIST);
    }

    @Override
    public <E> ListAttribute<J, E> getDeclaredList(String name, Class<E> elementType) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.checkListElementType(attribute, name, elementType);
        return (ListAttribute)((Object)attribute);
    }

    @Override
    public MapPersistentAttribute<? super J, ?, ?> getMap(String name) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.basicMapCheck(attribute, name);
        return (MapPersistentAttribute)attribute;
    }

    private void basicMapCheck(PluralAttribute<? super J, ?, ?> attribute, String name) {
        this.checkNotNull("MapAttribute", attribute, name);
        if (!MapAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a MapAttribute: " + attribute.getClass());
        }
    }

    @Override
    public MapPersistentAttribute<J, ?, ?> getDeclaredMap(String name) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.basicMapCheck(attribute, name);
        return (MapPersistentAttribute)attribute;
    }

    @Override
    public <K, V> MapAttribute<? super J, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralPersistentAttribute attribute = this.findPluralAttribute(name);
        this.checkMapValueType(attribute, name, valueType);
        MapAttribute mapAttribute = (MapAttribute)((Object)attribute);
        this.checkMapKeyType(mapAttribute, name, keyType);
        return mapAttribute;
    }

    private <V> void checkMapValueType(PluralAttribute<? super J, ?, ?> attribute, String name, Class<V> valueType) {
        this.checkTypeForPluralAttributes("MapAttribute", attribute, name, valueType, PluralAttribute.CollectionType.MAP);
    }

    private <K, V> void checkMapKeyType(MapAttribute<? super J, K, V> mapAttribute, String name, Class<K> keyType) {
        if (mapAttribute.getKeyJavaType() != keyType) {
            throw new IllegalArgumentException("MapAttribute named " + name + " does not support a key of type " + keyType);
        }
    }

    @Override
    public <K, V> MapAttribute<J, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralPersistentAttribute<J, ?, ?> attribute = this.findDeclaredPluralAttribute(name);
        this.checkMapValueType(attribute, name, valueType);
        MapAttribute mapAttribute = (MapAttribute)((Object)attribute);
        this.checkMapKeyType(mapAttribute, name, keyType);
        return mapAttribute;
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return new SubGraphImpl(this, true, this.jpaMetamodel());
    }

    @Override
    public <S extends J> ManagedDomainType<S> findSubType(String subTypeName) {
        return DomainModelHelper.resolveSubType(this, subTypeName, this.jpaMetamodel());
    }

    @Override
    public <S extends J> ManagedDomainType<S> findSubType(Class<S> subType) {
        return DomainModelHelper.resolveSubType(this, subType, this.jpaMetamodel());
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.jpaMetamodel(), this.getJavaType());
    }

    @Override
    public AttributeContainer.InFlightAccess<J> getInFlightAccess() {
        if (this.inFlightAccess == null) {
            throw new IllegalStateException("Type has been locked");
        }
        return this.inFlightAccess;
    }

    protected class InFlightAccessImpl
    implements AttributeContainer.InFlightAccess<J> {
        protected InFlightAccessImpl() {
        }

        @Override
        public void addAttribute(PersistentAttribute<J, ?> attribute) {
            if (attribute instanceof SingularPersistentAttribute) {
                AbstractManagedType.this.declaredSingularAttributes.put(attribute.getName(), (SingularPersistentAttribute)attribute);
            } else if (attribute instanceof PluralPersistentAttribute) {
                if (AbstractManagedType.this.declaredPluralAttributes == null) {
                    AbstractManagedType.this.declaredPluralAttributes = new HashMap();
                }
                AbstractManagedType.this.declaredPluralAttributes.put(attribute.getName(), (PluralPersistentAttribute)attribute);
            } else {
                throw new IllegalArgumentException("Unable to classify attribute as singular or plural [" + attribute + "] for `" + this + "`");
            }
        }

        @Override
        public void finishUp() {
            AbstractManagedType.this.inFlightAccess = null;
        }
    }

    private static class SerialForm
    implements Serializable {
        private final JpaMetamodel jpaMetamodel;
        private final Class<?> typeClass;

        public SerialForm(JpaMetamodel jpaMetamodel, Class<?> typeClass) {
            this.jpaMetamodel = jpaMetamodel;
            this.typeClass = typeClass;
        }

        private Object readResolve() {
            return this.jpaMetamodel.managedType(this.typeClass);
        }
    }
}

