/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCall;

public class PostgresCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final PostgresCallableStatementSupport INSTANCE = new PostgresCallableStatementSupport();

    @Override
    public JdbcCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        StringBuilder buffer;
        int startIndex;
        int offset;
        boolean firstParamIsRefCursor;
        String procedureName = procedureCall.getProcedureName();
        FunctionReturnImplementor functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        SharedSessionContractImplementor session = procedureCall.getSession();
        boolean bl = firstParamIsRefCursor = parameterMetadata.getParameterCount() != 0 && PostgresCallableStatementSupport.isFirstParameterModeRefCursor(parameterMetadata);
        if (firstParamIsRefCursor && parameterMetadata.hasNamedParameters()) {
            throw new HibernateException("Cannot mix named parameters and REF_CURSOR parameter on PostgreSQL");
        }
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder(parameterMetadata.hasNamedParameters() ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL);
        if (functionReturn != null) {
            offset = 2;
            startIndex = 0;
            buffer = new StringBuilder(11 + procedureName.length() + registrations.size() * 2).append("{?=call ");
            builder.setFunctionReturn(functionReturn.toJdbcFunctionReturn(session));
        } else if (firstParamIsRefCursor) {
            offset = 1;
            startIndex = 1;
            buffer = new StringBuilder(11 + procedureName.length() + registrations.size() * 2).append("{?=call ");
            builder.addParameterRegistration(registrations.get(0).toJdbcParameterRegistration(1, procedureCall));
        } else {
            offset = 1;
            startIndex = 0;
            buffer = new StringBuilder(9 + procedureName.length() + registrations.size() * 2).append("{call ");
        }
        buffer.append(procedureName).append("(");
        String sep = "";
        for (int i = startIndex; i < registrations.size(); ++i) {
            ProcedureParameterImplementor<?> parameter = registrations.get(i);
            if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                throw new HibernateException("PostgreSQL supports only one REF_CURSOR parameter, but multiple were registered");
            }
            buffer.append(sep).append("?");
            sep = ",";
            builder.addParameterRegistration(parameter.toJdbcParameterRegistration(i + offset, procedureCall));
        }
        buffer.append(")}");
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }

    private static boolean isFirstParameterModeRefCursor(ProcedureParameterMetadataImplementor parameterMetadata) {
        return parameterMetadata.getRegistrationsAsList().get(0).getMode() == ParameterMode.REF_CURSOR;
    }
}

