/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCall;

public class StandardCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final StandardCallableStatementSupport NO_REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(false);
    public static final StandardCallableStatementSupport REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(true);
    private final boolean supportsRefCursors;

    public StandardCallableStatementSupport(boolean supportsRefCursors) {
        this.supportsRefCursors = supportsRefCursors;
    }

    @Override
    public JdbcCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        StringBuilder buffer;
        int offset;
        String procedureName = procedureCall.getProcedureName();
        FunctionReturnImplementor functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        SharedSessionContractImplementor session = procedureCall.getSession();
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder(parameterMetadata.hasNamedParameters() ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL);
        if (functionReturn != null) {
            offset = 2;
            buffer = new StringBuilder(11 + procedureName.length() + registrations.size() * 2).append("{?=call ");
            builder.setFunctionReturn(functionReturn.toJdbcFunctionReturn(session));
        } else {
            offset = 1;
            buffer = new StringBuilder(9 + procedureName.length() + registrations.size() * 2).append("{call ");
        }
        buffer.append(procedureName).append("(");
        String sep = "";
        for (int i = 0; i < registrations.size(); ++i) {
            ProcedureParameterImplementor<?> parameter = registrations.get(i);
            if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                this.verifyRefCursorSupport(session.getJdbcServices().getJdbcEnvironment().getDialect());
            }
            buffer.append(sep).append("?");
            sep = ",";
            builder.addParameterRegistration(parameter.toJdbcParameterRegistration(i + offset, procedureCall));
        }
        buffer.append(")}");
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }

    private void verifyRefCursorSupport(Dialect dialect) {
        if (!this.supportsRefCursors) {
            throw new QueryException("Dialect [" + dialect.getClass().getName() + "] not known to support REF_CURSOR parameters");
        }
    }
}

