/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import org.hibernate.HibernateException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90003001, max=90003500)
public interface QueryLogging
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.query";
    public static final Logger QUERY_LOGGER = Logger.getLogger("org.hibernate.orm.query");
    public static final QueryLogging QUERY_MESSAGE_LOGGER = Logger.getMessageLogger(QueryLogging.class, "org.hibernate.orm.query");
    public static final boolean TRACE_ENABLED = QUERY_LOGGER.isTraceEnabled();
    public static final boolean DEBUG_ENABLED = QUERY_LOGGER.isDebugEnabled();

    public static String subLoggerName(String subName) {
        return "org.hibernate.orm.query." + subName;
    }

    public static Logger subLogger(String subName) {
        return Logger.getLogger(QueryLogging.subLoggerName(subName));
    }

    public static <T> T subLogger(String subName, Class<T> loggerJavaType) {
        return Logger.getMessageLogger(loggerJavaType, QueryLogging.subLoggerName(subName));
    }

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error in named query: %s", id=90003001)
    public void namedQueryError(String var1, @Cause HibernateException var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to determine lock mode value : %s -> %s", id=90003002)
    public void unableToDetermineLockModeValue(String var1, Object var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring unrecognized query hint [%s]", id=90003003)
    public void ignoringUnrecognizedQueryHint(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="firstResult/maxResults specified with collection fetch; applying in memory!", id=90003004)
    public void firstOrMaxResultsSpecifiedWithCollectionFetch();
}

