/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.BitSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.hibernate.QueryException;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.internal.SqmTreePrinter;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmStatement;

public class StandardHqlTranslator
implements HqlTranslator {
    protected static final ANTLRErrorListener ERR_LISTENER = new ANTLRErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new ParsingException("line " + line + ":" + charPositionInLine + " " + msg);
        }

        @Override
        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    };
    private final SqmCreationContext sqmCreationContext;
    private final SqmCreationOptions sqmCreationOptions;

    public StandardHqlTranslator(SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        this.sqmCreationContext = sqmCreationContext;
        this.sqmCreationOptions = sqmCreationOptions;
    }

    @Override
    public <R> SqmStatement<R> translate(String query) {
        HqlLogging.QUERY_LOGGER.debugf("HQL : " + query, new Object[0]);
        HqlParser.StatementContext hqlParseTree = this.parseHql(query);
        try {
            SqmStatement sqmStatement = SemanticQueryBuilder.buildSemanticModel(hqlParseTree, this.sqmCreationOptions, this.sqmCreationContext);
            SqmTreePrinter.logTree(sqmStatement);
            return sqmStatement;
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InterpretationException(query, e);
        }
    }

    private HqlParser.StatementContext parseHql(String hql) {
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        HqlParser hqlParser = HqlParseTreeBuilder.INSTANCE.buildHqlParser(hql, hqlLexer);
        hqlLexer.addErrorListener(ERR_LISTENER);
        ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        hqlParser.removeErrorListeners();
        hqlParser.addErrorListener(ERR_LISTENER);
        hqlParser.setErrorHandler(new BailErrorStrategy());
        try {
            return hqlParser.statement();
        }
        catch (ParseCancellationException e) {
            hqlLexer.reset();
            hqlParser.reset();
            ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            hqlParser.setErrorHandler(new DefaultErrorStrategy());
            return hqlParser.statement();
        }
        catch (ParsingException ex) {
            throw new SemanticException("A query exception occurred", hql, ex);
        }
    }
}

